/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.domain.DurableCqNamesResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;

public class ListDurableCqNamesFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    protected Cache getCache() {
        return CacheFactory.getAnyInstance();
    }

    @Override
    public String getId() {
        return ListDurableCqNamesFunction.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FunctionContext context) {
        Cache cache = this.getCache();
        DistributedMember member = cache.getDistributedSystem().getDistributedMember();
        String memberNameOrId = CliUtil.getMemberNameOrId(member);
        DurableCqNamesResult result = new DurableCqNamesResult(memberNameOrId);
        String durableClientId = (String)context.getArguments();
        try {
            CacheClientNotifier ccn = CacheClientNotifier.getInstance();
            if (ccn != null) {
                CacheClientProxy ccp = ccn.getClientProxy(durableClientId);
                if (ccp != null) {
                    CqService cqService = ccp.getCache().getCqService();
                    if (cqService != null && cqService.isRunning()) {
                        List<String> durableCqNames = cqService.getAllDurableClientCqs(ccp.getProxyID());
                        if (durableCqNames != null && !durableCqNames.isEmpty()) {
                            result.setCqNamesList(new ArrayList<String>(durableCqNames));
                        } else {
                            result.setErrorMessage(CliStrings.format("No durable cqs found for durable-client-id : \"{0}\".", (Object)durableClientId));
                        }
                    } else {
                        result.setErrorMessage("No durable cq's registered on this member.");
                    }
                } else {
                    result.setErrorMessage(CliStrings.format("No client found with client-id : {0}", (Object)durableClientId));
                }
            } else {
                result.setErrorMessage("No client found on this server");
            }
        }
        catch (Exception e) {
            result.setExceptionMessage(e.getMessage());
        }
        finally {
            context.getResultSender().lastResult(result);
        }
    }
}

