/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.ConfigSource;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.CacheConfig;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.management.internal.cli.domain.MemberConfigurationInfo;

public class GetMemberConfigInformationFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        Object argsObject = context.getArguments();
        boolean hideDefaults = (Boolean)argsObject;
        Cache cache = CacheFactory.getAnyInstance();
        InternalDistributedSystem system = (InternalDistributedSystem)cache.getDistributedSystem();
        DistributionConfig config = system.getConfig();
        DistributionConfigImpl distConfigImpl = (DistributionConfigImpl)config;
        MemberConfigurationInfo memberConfigInfo = new MemberConfigurationInfo();
        memberConfigInfo.setJvmInputArguments(this.getJvmInputArguments());
        memberConfigInfo.setGfePropsRuntime(distConfigImpl.getConfigPropsFromSource(ConfigSource.runtime()));
        memberConfigInfo.setGfePropsSetUsingApi(distConfigImpl.getConfigPropsFromSource(ConfigSource.api()));
        if (!hideDefaults) {
            memberConfigInfo.setGfePropsSetWithDefaults(distConfigImpl.getConfigPropsFromSource(null));
        }
        memberConfigInfo.setGfePropsSetFromFile(distConfigImpl.getConfigPropsDefinedUsingFiles());
        HashMap<String, String> cacheAttributes = new HashMap<String, String>();
        cacheAttributes.put("copy-on-read", Boolean.toString(cache.getCopyOnRead()));
        cacheAttributes.put("is-server", Boolean.toString(cache.isServer()));
        cacheAttributes.put("lock-timeout", Integer.toString(cache.getLockTimeout()));
        cacheAttributes.put("lock-lease", Integer.toString(cache.getLockLease()));
        cacheAttributes.put("message-sync-interval", Integer.toString(cache.getMessageSyncInterval()));
        cacheAttributes.put("search-timeout", Integer.toString(cache.getSearchTimeout()));
        if (cache.getPdxDiskStore() == null) {
            cacheAttributes.put("pdx-disk-store", "");
        } else {
            cacheAttributes.put("pdx-disk-store", cache.getPdxDiskStore());
        }
        cacheAttributes.put("pdx-ignore-unread-fields", Boolean.toString(cache.getPdxIgnoreUnreadFields()));
        cacheAttributes.put("pdx-persistent", Boolean.toString(cache.getPdxPersistent()));
        cacheAttributes.put("pdx-read-serialized", Boolean.toString(cache.getPdxReadSerialized()));
        if (hideDefaults) {
            this.removeDefaults(cacheAttributes, this.getCacheAttributesDefaultValues());
        }
        memberConfigInfo.setCacheAttributes(cacheAttributes);
        ArrayList<Map<String, String>> cacheServerAttributesList = new ArrayList<Map<String, String>>();
        List<CacheServer> cacheServers = cache.getCacheServers();
        if (cacheServers != null) {
            for (CacheServer cacheServer : cacheServers) {
                HashMap<String, String> cacheServerAttributes = new HashMap<String, String>();
                cacheServerAttributes.put("bind-address", cacheServer.getBindAddress());
                cacheServerAttributes.put("hostname-for-clients", cacheServer.getHostnameForClients());
                cacheServerAttributes.put("max-connections", Integer.toString(cacheServer.getMaxConnections()));
                cacheServerAttributes.put("maximum-message-count", Integer.toString(cacheServer.getMaximumMessageCount()));
                cacheServerAttributes.put("maximum-time-between-pings", Integer.toString(cacheServer.getMaximumTimeBetweenPings()));
                cacheServerAttributes.put("max-threads", Integer.toString(cacheServer.getMaxThreads()));
                cacheServerAttributes.put("message-time-to-live", Integer.toString(cacheServer.getMessageTimeToLive()));
                cacheServerAttributes.put("notify-by-subscription", Boolean.toString(cacheServer.getNotifyBySubscription()));
                cacheServerAttributes.put("port", Integer.toString(cacheServer.getPort()));
                cacheServerAttributes.put("socket-buffer-size", Integer.toString(cacheServer.getSocketBufferSize()));
                cacheServerAttributes.put("load-poll-interval", Long.toString(cacheServer.getLoadPollInterval()));
                cacheServerAttributes.put("tcp-no-delay", Boolean.toString(cacheServer.getTcpNoDelay()));
                if (hideDefaults) {
                    this.removeDefaults(cacheServerAttributes, this.getCacheServerAttributesDefaultValues());
                }
                cacheServerAttributesList.add(cacheServerAttributes);
            }
        }
        memberConfigInfo.setCacheServerAttributes(cacheServerAttributesList);
        context.getResultSender().lastResult(memberConfigInfo);
    }

    private Map<String, String> getCacheAttributesDefaultValues() {
        String d = CacheConfig.DEFAULT_PDX_DISK_STORE;
        HashMap<String, String> cacheAttributesDefault = new HashMap<String, String>();
        cacheAttributesDefault.put("pdx-disk-store", "");
        cacheAttributesDefault.put("pdx-read-serialized", Boolean.toString(CacheConfig.DEFAULT_PDX_READ_SERIALIZED));
        cacheAttributesDefault.put("pdx-ignore-unread-fields", Boolean.toString(CacheConfig.DEFAULT_PDX_IGNORE_UNREAD_FIELDS));
        cacheAttributesDefault.put("pdx-persistent", Boolean.toString(CacheConfig.DEFAULT_PDX_PERSISTENT));
        cacheAttributesDefault.put("copy-on-read", Boolean.toString(false));
        cacheAttributesDefault.put("lock-timeout", Integer.toString(GemFireCacheImpl.DEFAULT_LOCK_TIMEOUT));
        cacheAttributesDefault.put("lock-lease", Integer.toString(GemFireCacheImpl.DEFAULT_LOCK_LEASE));
        cacheAttributesDefault.put("message-sync-interval", Integer.toString(1));
        cacheAttributesDefault.put("search-timeout", Integer.toString(GemFireCacheImpl.DEFAULT_SEARCH_TIMEOUT));
        cacheAttributesDefault.put("is-server", Boolean.toString(false));
        return cacheAttributesDefault;
    }

    private Map<String, String> getCacheServerAttributesDefaultValues() {
        HashMap<String, String> csAttributesDefault = new HashMap<String, String>();
        csAttributesDefault.put("bind-address", "");
        csAttributesDefault.put("hostname-for-clients", "");
        csAttributesDefault.put("max-connections", Integer.toString(800));
        csAttributesDefault.put("maximum-message-count", Integer.toString(230000));
        csAttributesDefault.put("maximum-time-between-pings", Integer.toString(60000));
        csAttributesDefault.put("max-threads", Integer.toString(0));
        csAttributesDefault.put("message-time-to-live", Integer.toString(180));
        csAttributesDefault.put("notify-by-subscription", Boolean.toString(true));
        csAttributesDefault.put("port", Integer.toString(40404));
        csAttributesDefault.put("socket-buffer-size", Integer.toString(32768));
        csAttributesDefault.put("load-poll-interval", Long.toString(5000L));
        return csAttributesDefault;
    }

    private void removeDefaults(Map<String, String> attributesMap, Map<String, String> defaultAttributesMap) {
        HashSet<String> attributesSet = new HashSet<String>(attributesMap.keySet());
        if (attributesSet != null) {
            for (String attribute : attributesSet) {
                String attributeValue = attributesMap.get(attribute);
                String defaultValue = defaultAttributesMap.get(attribute);
                if (attributeValue != null) {
                    if (!attributeValue.equals(defaultValue)) continue;
                    attributesMap.remove(attribute);
                    continue;
                }
                if (defaultValue != null && !defaultValue.equals("")) continue;
                attributesMap.remove(attribute);
            }
        }
    }

    @Override
    public String getId() {
        return GetMemberConfigInformationFunction.class.toString();
    }

    private List<String> getJvmInputArguments() {
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        return runtimeBean.getInputArguments();
    }
}

