/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class LocatorIdNameConverter
implements Converter<String> {
    public boolean supports(Class<?> type, String optionContext) {
        return String.class.equals(type) && "converter.hint.locatormember.idOrName".equals(optionContext);
    }

    public String convertFromText(String value, Class<?> targetType, String optionContext) {
        return value;
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        if (String.class.equals(targetType) && "converter.hint.locatormember.idOrName".equals(optionContext)) {
            Set<String> locatorIdsAndNames = this.getLocatorIdAndNames();
            for (String string : locatorIdsAndNames) {
                completions.add(new Completion(string));
            }
        }
        return !completions.isEmpty();
    }

    private Set<String> getLocatorIdAndNames() {
        String[] locatorIds;
        TreeSet<String> locatorIdsAndNames = new TreeSet<String>();
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh != null && gfsh.isConnectedAndReady() && (locatorIds = gfsh.getOperationInvoker().getDistributedSystemMXBean().listLocatorMembers(true)) != null && locatorIds.length != 0) {
            locatorIdsAndNames.addAll(Arrays.asList(locatorIds));
        }
        return locatorIdsAndNames;
    }
}

