/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.util.List;
import java.util.Set;
import org.apache.geode.management.internal.cli.CommandManager;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class HintTopicConverter
implements Converter<String> {
    public boolean supports(Class<?> type, String optionContext) {
        return String.class.equals(type) && "converter.hint.gfsh.hint.topic".equals(optionContext);
    }

    public String convertFromText(String value, Class<?> targetType, String optionContext) {
        return value;
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        CommandManager commandManager;
        if (String.class.equals(targetType) && "converter.hint.gfsh.hint.topic".equals(optionContext) && (commandManager = CommandManager.getExisting()) != null) {
            Set<String> topicNames = commandManager.getTopicNames();
            for (String topicName : topicNames) {
                if (existingData != null && !existingData.isEmpty()) {
                    if (topicName.startsWith(existingData)) {
                        completions.add(new Completion(topicName));
                        continue;
                    }
                    if (!topicName.toLowerCase().startsWith(existingData.toLowerCase())) continue;
                    String completionStr = existingData + topicName.substring(existingData.length());
                    completions.add(new Completion(completionStr));
                    continue;
                }
                completions.add(new Completion(topicName));
            }
        }
        return !completions.isEmpty();
    }
}

