/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class FilePathStringConverter
implements Converter<String> {
    public boolean supports(Class<?> type, String optionContext) {
        return String.class.equals(type) && "converter.hint.file.path.string".equals(optionContext);
    }

    public String convertFromText(String value, Class<?> targetType, String optionContext) {
        return value;
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        String prefixToUse = "";
        boolean prependAbsolute = true;
        File parentDir = null;
        if (existingData != null) {
            String[] completionValues = new String[]{};
            if ("converter.hint.file.path.string".equals(optionContext)) {
                if (existingData != null && existingData.trim().isEmpty()) {
                    File[] listRoots = File.listRoots();
                    completionValues = new String[listRoots.length];
                    for (int i = 0; i < listRoots.length; ++i) {
                        completionValues[i] = listRoots[i].getPath();
                    }
                    prefixToUse = File.separator;
                } else {
                    File file = new File(existingData);
                    if (file.isDirectory()) {
                        parentDir = file;
                        completionValues = parentDir.list();
                    } else if (!file.exists()) {
                        parentDir = file.getParentFile();
                        if (parentDir == null) {
                            try {
                                parentDir = file.getCanonicalFile().getParentFile();
                            }
                            catch (IOException e) {
                                parentDir = null;
                            }
                        }
                        if (parentDir != null) {
                            completionValues = parentDir.list(new FileNameFilterImpl(parentDir, file.getName()));
                        }
                    }
                    prependAbsolute = file.isAbsolute();
                }
            }
            if (completionValues.length > 0) {
                if (parentDir != null) {
                    if (existingData.startsWith(".")) {
                        prefixToUse = parentDir.getPath();
                    } else if (prependAbsolute) {
                        prefixToUse = parentDir.getAbsolutePath();
                    }
                }
                if (!prefixToUse.endsWith(File.separator) && (prependAbsolute || existingData.startsWith("."))) {
                    prefixToUse = prefixToUse + File.separator;
                }
                for (int i = 0; i < completionValues.length; ++i) {
                    completions.add(new Completion(prefixToUse + completionValues[i]));
                }
            }
        }
        return !completions.isEmpty();
    }

    class FileNameFilterImpl
    implements FilenameFilter {
        private File parentDirectory;
        private String userInput;

        public FileNameFilterImpl(File parentDirectory, String userInput) {
            this.parentDirectory = parentDirectory;
            this.userInput = userInput;
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.parentDirectory.equals(dir) && name.startsWith(this.userInput);
        }
    }
}

