/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.AlreadyBoundException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.security.shiro.JMXShiroAuthenticator;
import org.apache.geode.internal.tcp.TCPConduit;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.ManagerMXBean;
import org.apache.geode.management.internal.AgentUtil;
import org.apache.geode.management.internal.JettyHelper;
import org.apache.geode.management.internal.RestAgent;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.security.AccessControlMBean;
import org.apache.geode.management.internal.security.MBeanServerWrapper;
import org.apache.geode.management.internal.unsafe.ReadOpFileAccessController;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;

public class ManagementAgent {
    private static final Logger logger = LogService.getLogger();
    private boolean running = false;
    private Registry registry;
    private JMXConnectorServer jmxConnectorServer;
    private JMXShiroAuthenticator shiroAuthenticator;
    private final DistributionConfig config;
    private SecurityService securityService = SecurityService.getSecurityService();
    private boolean isHttpServiceRunning = false;
    private static final String PULSE_EMBEDDED_PROP = "pulse.embedded";
    private Server httpServer;
    private final String GEMFIRE_VERSION = GemFireVersion.getGemFireVersion();
    private AgentUtil agentUtil = new AgentUtil(this.GEMFIRE_VERSION);

    public ManagementAgent(DistributionConfig config) {
        this.config = config;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized boolean isHttpServiceRunning() {
        return this.isHttpServiceRunning;
    }

    public synchronized void setHttpServiceRunning(boolean isHttpServiceRunning) {
        this.isHttpServiceRunning = isHttpServiceRunning;
    }

    private boolean isAPIRestServiceRunning(GemFireCacheImpl cache) {
        return cache != null && cache.getRestAgent() != null && cache.getRestAgent().isRunning();
    }

    private boolean isServerNode(GemFireCacheImpl cache) {
        return cache.getDistributedSystem().getDistributedMember().getVmKind() != 11 && cache.getDistributedSystem().getDistributedMember().getVmKind() != 12 && !cache.isClient();
    }

    public synchronized void startAgent(GemFireCacheImpl cache) {
        if (!this.isAPIRestServiceRunning(cache)) {
            this.startHttpService(this.isServerNode(cache));
        } else if (logger.isDebugEnabled()) {
            logger.debug("Developer REST APIs webapp is already running, Not Starting M&M REST and pulse!");
        }
        if (!this.running && this.config.getJmxManagerPort() != 0) {
            try {
                this.configureAndStart();
            }
            catch (IOException e) {
                throw new ManagementException(e);
            }
            this.running = true;
        }
    }

    public synchronized void stopAgent() {
        this.stopHttpService();
        if (!this.running) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping jmx manager agent");
        }
        try {
            this.jmxConnectorServer.stop();
            UnicastRemoteObject.unexportObject(this.registry, true);
        }
        catch (Exception e) {
            throw new ManagementException(e);
        }
        this.running = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startHttpService(boolean isServer) {
        SystemManagementService managementService = (SystemManagementService)ManagementService.getManagementService(CacheFactory.getAnyInstance());
        ManagerMXBean managerBean = managementService.getManagerMXBean();
        if (this.config.getHttpServicePort() != 0) {
            String pulseWar;
            String gemfireWar;
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to start HTTP service on port ({}) at bind-address ({})...", (Object)this.config.getHttpServicePort(), (Object)this.config.getHttpServiceBindAddress());
            }
            if ((gemfireWar = this.agentUtil.findWarLocation("geode-web")) == null && logger.isDebugEnabled()) {
                logger.debug("Unable to find GemFire Management REST API WAR file; the Management REST Interface for GemFire will not be accessible.");
            }
            if ((pulseWar = this.agentUtil.findWarLocation("geode-pulse")) == null) {
                String message = "Unable to find Pulse web application WAR file; Pulse for GemFire will not be accessible";
                this.setStatusMessage(managerBean, "Unable to find Pulse web application WAR file; Pulse for GemFire will not be accessible");
                if (logger.isDebugEnabled()) {
                    logger.debug("Unable to find Pulse web application WAR file; Pulse for GemFire will not be accessible");
                }
            } else if (this.securityService.isIntegratedSecurity()) {
                System.setProperty("spring.profiles.active", "pulse.authentication.gemfire");
            }
            String gemfireAPIWar = this.agentUtil.findWarLocation("geode-web-api");
            if (gemfireAPIWar == null) {
                String message = "Unable to find GemFire Developer REST API WAR file; the Developer REST Interface for GemFire will not be accessible.";
                this.setStatusMessage(managerBean, "Unable to find GemFire Developer REST API WAR file; the Developer REST Interface for GemFire will not be accessible.");
                if (logger.isDebugEnabled()) {
                    logger.debug("Unable to find GemFire Developer REST API WAR file; the Developer REST Interface for GemFire will not be accessible.");
                }
            }
            try {
                if (!this.agentUtil.isWebApplicationAvailable(gemfireWar, pulseWar, gemfireAPIWar)) return;
                String bindAddress = this.config.getHttpServiceBindAddress();
                int port = this.config.getHttpServicePort();
                boolean isRestWebAppAdded = false;
                this.httpServer = JettyHelper.initJetty(bindAddress, port, SSLConfigurationFactory.getSSLConfigForComponent(SecurableCommunicationChannel.WEB));
                if (this.agentUtil.isWebApplicationAvailable(gemfireWar)) {
                    this.httpServer = JettyHelper.addWebApplication(this.httpServer, "/gemfire", gemfireWar);
                    this.httpServer = JettyHelper.addWebApplication(this.httpServer, "/geode-mgmt", gemfireWar);
                }
                if (this.agentUtil.isWebApplicationAvailable(pulseWar)) {
                    this.httpServer = JettyHelper.addWebApplication(this.httpServer, "/pulse", pulseWar);
                }
                if (isServer && this.config.getStartDevRestApi()) {
                    if (this.agentUtil.isWebApplicationAvailable(gemfireAPIWar)) {
                        this.httpServer = JettyHelper.addWebApplication(this.httpServer, "/geode", gemfireAPIWar);
                        this.httpServer = JettyHelper.addWebApplication(this.httpServer, "/gemfire-api", gemfireAPIWar);
                        isRestWebAppAdded = true;
                    }
                } else {
                    String message = "Developer REST API web application will not start when start-dev-rest-api is not set and node is not server";
                    this.setStatusMessage(managerBean, "Developer REST API web application will not start when start-dev-rest-api is not set and node is not server");
                    if (logger.isDebugEnabled()) {
                        logger.debug("Developer REST API web application will not start when start-dev-rest-api is not set and node is not server");
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Starting HTTP embedded server on port ({}) at bind-address ({})...", (Object)((ServerConnector)this.httpServer.getConnectors()[0]).getPort(), (Object)bindAddress);
                }
                System.setProperty(PULSE_EMBEDDED_PROP, "true");
                this.httpServer = JettyHelper.startJetty(this.httpServer);
                if (this.agentUtil.isWebApplicationAvailable(pulseWar)) {
                    managerBean.setPulseURL("http://".concat(this.getHost(bindAddress)).concat(":").concat(String.valueOf(port)).concat("/pulse/"));
                }
                if (isRestWebAppAdded) {
                    GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.getAnyInstance();
                    cache.setRESTServiceRunning(true);
                    RestAgent.createParameterizedQueryRegion();
                }
                this.setHttpServiceRunning(true);
                return;
            }
            catch (Exception e) {
                this.stopHttpService();
                this.setStatusMessage(managerBean, "HTTP service failed to start with " + e.getClass().getSimpleName() + " '" + e.getMessage() + "'");
                throw new ManagementException("HTTP service failed to start", e);
            }
        } else {
            this.setStatusMessage(managerBean, "Embedded HTTP server configured not to start (http-service-port=0) or (jmx-manager-http-port=0)");
        }
    }

    private String getHost(String bindAddress) throws UnknownHostException {
        if (!StringUtils.isBlank(this.config.getJmxManagerHostnameForClients())) {
            return this.config.getJmxManagerHostnameForClients();
        }
        if (!StringUtils.isBlank(bindAddress)) {
            return InetAddress.getByName(bindAddress).getHostAddress();
        }
        return SocketCreator.getLocalHost().getHostAddress();
    }

    private void setStatusMessage(ManagerMXBean mBean, String message) {
        mBean.setPulseURL("");
        mBean.setStatusMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stopHttpService() {
        if (this.httpServer == null) return;
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping the HTTP service...");
        }
        try {
            this.httpServer.stop();
            return;
        }
        catch (Exception e) {
            logger.warn("Failed to stop the HTTP service because: {}", (Object)e.getMessage(), (Object)e);
            return;
        }
        finally {
            try {
                this.httpServer.destroy();
            }
            catch (Exception ignore) {
                logger.error("Failed to properly release resources held by the HTTP service: {}", (Object)ignore.getMessage(), (Object)ignore);
            }
            finally {
                this.httpServer = null;
                System.clearProperty("catalina.base");
                System.clearProperty("catalina.home");
            }
        }
    }

    private void configureAndStart() throws IOException {
        InetAddress bindAddr;
        String hostname;
        int port = this.config.getJmxManagerPort();
        if (StringUtils.isBlank(this.config.getJmxManagerBindAddress())) {
            hostname = SocketCreator.getLocalHost().getHostName();
            bindAddr = null;
        } else {
            hostname = this.config.getJmxManagerBindAddress();
            bindAddr = InetAddress.getByName(hostname);
        }
        String jmxManagerHostnameForClients = this.config.getJmxManagerHostnameForClients();
        if (!StringUtils.isBlank(jmxManagerHostnameForClients)) {
            System.setProperty("java.rmi.server.hostname", jmxManagerHostnameForClients);
        }
        SocketCreator socketCreator = SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.JMX);
        boolean ssl = socketCreator.useSSL();
        if (logger.isDebugEnabled()) {
            logger.debug("Starting jmx manager agent on port {}{}", (Object)port, (Object)((bindAddr != null ? " bound to " + bindAddr : "") + (ssl ? " using SSL" : "")));
        }
        SslRMIClientSocketFactory rmiClientSocketFactory = ssl ? new SslRMIClientSocketFactory() : null;
        GemFireRMIServerSocketFactory rmiServerSocketFactory = new GemFireRMIServerSocketFactory(socketCreator, bindAddr);
        System.setProperty("sun.rmi.dgc.server.gcInterval", Long.toString(0x7FFFFFFFFFFFFFFEL));
        this.registry = LocateRegistry.createRegistry(port, rmiClientSocketFactory, rmiServerSocketFactory);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        HashMap<String, Object> env = new HashMap<String, Object>();
        final RMIJRMPServerImpl stub = new RMIJRMPServerImpl(port, rmiClientSocketFactory, rmiServerSocketFactory, env);
        final JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://" + hostname + ":" + port + "/jndi/rmi://" + hostname + ":" + port + "/jmxrmi");
        this.jmxConnectorServer = new RMIConnectorServer(new JMXServiceURL("rmi", hostname, port), env, stub, mbs){

            @Override
            public JMXServiceURL getAddress() {
                return url;
            }

            @Override
            public synchronized void start() throws IOException {
                try {
                    ManagementAgent.this.registry.bind("jmxrmi", stub);
                }
                catch (AlreadyBoundException x) {
                    IOException io = new IOException(x.getMessage());
                    io.initCause(x);
                    throw io;
                }
                super.start();
            }
        };
        if (this.securityService.isIntegratedSecurity()) {
            this.shiroAuthenticator = new JMXShiroAuthenticator();
            env.put("jmx.remote.authenticator", this.shiroAuthenticator);
            this.jmxConnectorServer.addNotificationListener(this.shiroAuthenticator, null, this.jmxConnectorServer.getAttributes());
            MBeanServerWrapper mBeanServerWrapper = new MBeanServerWrapper();
            this.jmxConnectorServer.setMBeanServerForwarder(mBeanServerWrapper);
            this.registerAccessControlMBean();
        } else {
            String accessFile;
            String pwFile = this.config.getJmxManagerPasswordFile();
            if (pwFile != null && pwFile.length() > 0) {
                env.put("jmx.remote.x.password.file", pwFile);
            }
            if ((accessFile = this.config.getJmxManagerAccessFile()) != null && accessFile.length() > 0) {
                ReadOpFileAccessController controller = new ReadOpFileAccessController(accessFile);
                controller.setMBeanServer(mbs);
                mbs = controller;
            }
        }
        this.jmxConnectorServer.start();
        if (logger.isDebugEnabled()) {
            logger.debug("Finished starting jmx manager agent.");
        }
    }

    private void registerAccessControlMBean() {
        block6: {
            try {
                AccessControlMBean acc = new AccessControlMBean();
                ObjectName accessControlMBeanON = new ObjectName("GemFire:service=AccessControl,type=Distributed");
                MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
                Set<ObjectName> names = platformMBeanServer.queryNames(accessControlMBeanON, null);
                if (!names.isEmpty()) break block6;
                try {
                    platformMBeanServer.registerMBean(acc, accessControlMBeanON);
                    logger.info("Registered AccessContorlMBean on " + accessControlMBeanON);
                }
                catch (InstanceAlreadyExistsException e) {
                    throw new GemFireConfigException("Error while configuring accesscontrol for jmx resource", e);
                }
                catch (MBeanRegistrationException e) {
                    throw new GemFireConfigException("Error while configuring accesscontrol for jmx resource", e);
                }
                catch (NotCompliantMBeanException e) {
                    throw new GemFireConfigException("Error while configuring accesscontrol for jmx resource", e);
                }
            }
            catch (MalformedObjectNameException e) {
                throw new GemFireConfigException("Error while configuring accesscontrol for jmx resource", e);
            }
        }
    }

    private static class GemFireRMIServerSocketFactory
    implements RMIServerSocketFactory,
    Serializable {
        private static final long serialVersionUID = -811909050641332716L;
        private transient SocketCreator sc;
        private final InetAddress bindAddr;

        public GemFireRMIServerSocketFactory(SocketCreator sc, InetAddress bindAddr) {
            this.sc = sc;
            this.bindAddr = bindAddr;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            return this.sc.createServerSocket(port, TCPConduit.getBackLog(), this.bindAddr);
        }
    }

    private static class GemFireRMIClientSocketFactory
    implements RMIClientSocketFactory,
    Serializable {
        private static final long serialVersionUID = -7604285019188827617L;
        private transient SocketCreator sc;

        public GemFireRMIClientSocketFactory(SocketCreator sc) {
            this.sc = sc;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.sc.connectForClient(host, port, 0);
        }
    }
}

