/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.util.Transformer;

public final class TransformUtils {
    public static final Transformer<Map.Entry<PersistentMemberID, Set<Integer>>, String> persistentMemberEntryToLogEntryTransformer = new Transformer<Map.Entry<PersistentMemberID, Set<Integer>>, String>(){

        @Override
        public String transform(Map.Entry<PersistentMemberID, Set<Integer>> entry) {
            PersistentMemberID memberId = entry.getKey();
            Set<Integer> bucketIds = entry.getValue();
            StringBuilder builder = new StringBuilder();
            builder.append(persistentMemberIdToLogEntryTransformer.transform(memberId));
            if (null != bucketIds) {
                builder.append("  Buckets: ");
                builder.append(bucketIds);
            }
            builder.append("\n");
            return builder.toString();
        }
    };
    public static final Transformer<PersistentMemberID, String> persistentMemberIdToLogEntryTransformer = new Transformer<PersistentMemberID, String>(){

        @Override
        public String transform(PersistentMemberID memberId) {
            StringBuilder builder = new StringBuilder();
            if (null != memberId) {
                if (null != memberId.diskStoreId) {
                    builder.append("\n  DiskStore ID: ");
                    builder.append(memberId.diskStoreId.toUUID().toString());
                }
                if (null != memberId.name) {
                    builder.append("\n  Name: ");
                    builder.append(memberId.name);
                }
                if (null != memberId.host && null != memberId.directory) {
                    builder.append("\n  Location: ");
                }
                if (null != memberId.host) {
                    builder.append("/");
                    builder.append(memberId.host.getHostAddress());
                    builder.append(":");
                }
                if (null != memberId.directory) {
                    builder.append(memberId.directory);
                }
                builder.append("\n");
            }
            return builder.toString();
        }
    };
    public static final Transformer<File, String> fileNameTransformer = new Transformer<File, String>(){

        @Override
        public String transform(File file) {
            return file.getName();
        }
    };

    public static <T1, T2> void transform(Collection<T1> from, Collection<T2> to, Transformer<T1, T2> transformer) {
        for (T1 instance : from) {
            to.add(transformer.transform(instance));
        }
    }

    public static <T1, T2> Map<T2, T1> transformAndMap(Collection<T1> from, Transformer<T1, T2> transformer) {
        HashMap<T2, T1> map = new HashMap<T2, T1>();
        for (T1 instance : from) {
            map.put(transformer.transform(instance), instance);
        }
        return map;
    }
}

