/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import org.apache.geode.internal.lang.SystemUtils;

public class HostName {
    static final String COMPUTER_NAME_PROPERTY = "COMPUTERNAME";
    static final String HOSTNAME_PROPERTY = "HOSTNAME";
    private static final String HOSTNAME = "hostname";
    private static final String START_OF_STRING = "\\A";
    private static final String UNKNOWN = "unknown";

    public String determineHostName() {
        String hostname = this.getHostNameFromEnv();
        if (this.isEmpty(hostname)) {
            hostname = this.execHostName();
        }
        assert (!this.isEmpty(hostname));
        return hostname;
    }

    String execHostName() {
        String hostname;
        try {
            Process process = new ProcessBuilder(HOSTNAME).start();
            try (InputStream stream = process.getInputStream();
                 Scanner s = new Scanner(stream).useDelimiter(START_OF_STRING);){
                hostname = s.hasNext() ? s.next().trim() : UNKNOWN;
            }
        }
        catch (IOException hostnameBinaryNotFound) {
            hostname = UNKNOWN;
        }
        return hostname;
    }

    String getHostNameFromEnv() {
        String hostname = SystemUtils.isWindows() ? System.getenv(COMPUTER_NAME_PROPERTY) : System.getenv(HOSTNAME_PROPERTY);
        return hostname;
    }

    private boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

