/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.tcp.ByteBufferInputStream;
import org.apache.geode.internal.tcp.Connection;
import org.apache.geode.internal.tcp.MsgDestreamer;
import org.apache.geode.internal.tcp.VersionedByteBufferInputStream;

public abstract class MsgReader {
    protected final Connection conn;
    protected final Header header = new Header();
    private final ByteBufferInputStream bbis;

    public MsgReader(Connection conn, Version version) {
        this.conn = conn;
        this.bbis = version == null ? new ByteBufferInputStream() : new VersionedByteBufferInputStream(version);
    }

    public Header readHeader() throws IOException {
        boolean directAck;
        ByteBuffer nioInputBuffer = this.readAtLeast(7);
        int nioMessageLength = nioInputBuffer.getInt();
        Connection.calcHdrVersion(nioMessageLength);
        nioMessageLength = Connection.calcMsgByteSize(nioMessageLength);
        byte nioMessageType = nioInputBuffer.get();
        short nioMsgId = nioInputBuffer.getShort();
        boolean bl = directAck = (nioMessageType & 0x20) != 0;
        if (directAck) {
            nioMessageType = (byte)(nioMessageType & 0xFFFFFFDF);
        }
        this.header.nioMessageLength = nioMessageLength;
        this.header.nioMessageType = nioMessageType;
        this.header.nioMsgId = nioMsgId;
        return this.header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributionMessage readMessage(Header header) throws IOException, ClassNotFoundException, InterruptedException {
        ByteBuffer nioInputBuffer = this.readAtLeast(header.nioMessageLength);
        this.getStats().incMessagesBeingReceived(true, header.nioMessageLength);
        long startSer = this.getStats().startMsgDeserialization();
        try {
            this.bbis.setBuffer(nioInputBuffer);
            DistributionMessage msg = null;
            ReplyProcessor21.initMessageRPId();
            DistributionMessage distributionMessage = msg = (DistributionMessage)InternalDataSerializer.readDSFID(this.bbis);
            return distributionMessage;
        }
        finally {
            this.getStats().endMsgDeserialization(startSer);
            this.getStats().decMessagesBeingReceived(header.nioMessageLength);
        }
    }

    public void readChunk(Header header, MsgDestreamer md) throws IOException, ClassNotFoundException, InterruptedException {
        ByteBuffer nioInputBuffer = this.readAtLeast(header.nioMessageLength);
        this.getStats().incMessagesBeingReceived(md.size() == 0, header.nioMessageLength);
        md.addChunk(nioInputBuffer, header.nioMessageLength);
    }

    public abstract ByteBuffer readAtLeast(int var1) throws IOException;

    protected DMStats getStats() {
        return this.conn.owner.getConduit().stats;
    }

    public void close() {
    }

    public static class Header {
        int nioMessageLength;
        byte nioMessageType;
        short nioMsgId;

        public int getNioMessageLength() {
            return this.nioMessageLength;
        }

        public byte getNioMessageType() {
            return this.nioMessageType;
        }

        public short getNioMessageId() {
            return this.nioMsgId;
        }
    }
}

