/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.geode.internal.statistics.ResourceInstance;
import org.apache.geode.internal.statistics.SampleCollector;
import org.apache.geode.internal.statistics.StatMonitorHandler;
import org.apache.geode.internal.statistics.StatisticId;
import org.apache.geode.internal.statistics.StatisticsListener;
import org.apache.geode.internal.statistics.StatisticsNotification;

public abstract class StatisticsMonitor {
    private final Object mutex = new Object();
    private volatile List<StatisticsListener> listeners = Collections.emptyList();
    private volatile List<StatisticId> statisticIds = Collections.emptyList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticsMonitor addStatistic(StatisticId statId) {
        if (statId == null) {
            throw new NullPointerException("StatisticId is null");
        }
        Object object = this.mutex;
        synchronized (object) {
            List<StatisticId> oldStatisticIds = this.statisticIds;
            if (!oldStatisticIds.contains(statId)) {
                ArrayList<StatisticId> newStatisticIds = new ArrayList<StatisticId>(oldStatisticIds);
                newStatisticIds.add(statId);
                this.statisticIds = Collections.unmodifiableList(newStatisticIds);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticsMonitor removeStatistic(StatisticId statId) {
        if (statId == null) {
            throw new NullPointerException("StatisticId is null");
        }
        Object object = this.mutex;
        synchronized (object) {
            List<StatisticId> oldStatisticIds = this.statisticIds;
            if (oldStatisticIds.contains(statId)) {
                ArrayList<StatisticId> newStatisticIds = new ArrayList<StatisticId>(oldStatisticIds);
                newStatisticIds.remove(statId);
                this.statisticIds = Collections.unmodifiableList(newStatisticIds);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(StatisticsListener listener) {
        if (listener == null) {
            throw new NullPointerException("StatisticsListener is null");
        }
        Object object = this.mutex;
        synchronized (object) {
            List<StatisticsListener> oldListeners = this.listeners;
            if (!oldListeners.contains(listener)) {
                ArrayList<StatisticsListener> newListeners = new ArrayList<StatisticsListener>(oldListeners);
                newListeners.add(listener);
                this.listeners = Collections.unmodifiableList(newListeners);
                this.getStatMonitorHandler().addMonitor(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(StatisticsListener listener) {
        if (listener == null) {
            throw new NullPointerException("StatisticsListener is null");
        }
        Object object = this.mutex;
        synchronized (object) {
            List<StatisticsListener> oldListeners = this.listeners;
            if (oldListeners.contains(listener)) {
                ArrayList<StatisticsListener> newListeners = new ArrayList<StatisticsListener>(oldListeners);
                newListeners.remove(listener);
                if (newListeners.isEmpty()) {
                    try {
                        this.getStatMonitorHandler().removeMonitor(this);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                this.listeners = Collections.unmodifiableList(newListeners);
            }
        }
    }

    protected void monitor(long millisTimeStamp, List<ResourceInstance> resourceInstances) {
        this.monitorStatisticIds(millisTimeStamp, resourceInstances);
    }

    private final void monitorStatisticIds(long millisTimeStamp, List<ResourceInstance> resourceInstances) {
        List<StatisticId> statisticIdsToMonitor = this.statisticIds;
        if (!statisticIdsToMonitor.isEmpty()) {
            // empty if block
        }
    }

    protected final void notifyListeners(StatisticsNotification notification) {
        List<StatisticsListener> listenersToNotify = this.listeners;
        for (StatisticsListener listener : listenersToNotify) {
            listener.handleNotification(notification);
        }
    }

    protected final Object mutex() {
        return this.mutex;
    }

    StatMonitorHandler getStatMonitorHandler() {
        return SampleCollector.getStatMonitorHandler();
    }

    List<StatisticsListener> getStatisticsListenersSnapshot() {
        return this.listeners;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("@").append(System.identityHashCode(this)).append("{");
        sb.append("statisticIds=").append(this.statisticIds);
        sb.append(", listeners=").append(this.listeners);
        StringBuilder toAppend = this.appendToString();
        if (toAppend == null) {
            sb.append(", ").append((CharSequence)toAppend);
        }
        sb.append("}");
        return sb.toString();
    }

    protected StringBuilder appendToString() {
        return null;
    }
}

