/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.sequencelog;

import java.util.EnumSet;

public enum GraphType {
    REGION,
    KEY,
    MESSAGE,
    MEMBER;


    public byte getId() {
        return (byte)this.ordinal();
    }

    public static GraphType getType(byte id) {
        return GraphType.values()[id];
    }

    public static EnumSet<GraphType> parse(String enabledTypesString) {
        EnumSet<GraphType> set = EnumSet.noneOf(GraphType.class);
        if (enabledTypesString.contains("region")) {
            set.add(REGION);
        }
        if (enabledTypesString.contains("key")) {
            set.add(KEY);
        }
        if (enabledTypesString.contains("message")) {
            set.add(MESSAGE);
        }
        if (enabledTypesString.contains("member")) {
            set.add(MEMBER);
        }
        if (enabledTypesString.contains("all")) {
            set = EnumSet.allOf(GraphType.class);
        }
        return set;
    }
}

