/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.File;
import java.io.IOException;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

final class ControlFileWatchdog
implements Runnable {
    private static final Logger logger = LogService.getLogger();
    private static final long STOP_TIMEOUT_MILLIS = 60000L;
    private static final long SLEEP_MILLIS = 1000L;
    private final File workingDir;
    private final File file;
    private final ControlRequestHandler requestHandler;
    private final boolean stopAfterRequest;
    private Thread thread;
    private boolean alive;

    ControlFileWatchdog(File workingDir, String fileName, ControlRequestHandler requestHandler, boolean stopAfterRequest) {
        this.workingDir = workingDir;
        this.file = new File(this.workingDir, fileName);
        this.requestHandler = requestHandler;
        this.stopAfterRequest = stopAfterRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block18: {
            block15: while (true) {
                while (this.isAlive()) {
                    try {
                        Thread.sleep(1000L);
                        if (!this.file.exists()) continue block15;
                        try {
                            this.work();
                            continue block15;
                        }
                        finally {
                            if (this.stopAfterRequest) {
                                this.stopMe();
                            }
                            continue block15;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (IOException e) {
                        logger.error("Unable to control process with {}. Please add tools.jar from JDK to classpath for improved process control.", (Object)this.file);
                    }
                }
                break block18;
                {
                    continue block15;
                    break;
                }
                break;
            }
            finally {
                ControlFileWatchdog controlFileWatchdog = this;
                synchronized (controlFileWatchdog) {
                    this.alive = false;
                }
            }
        }
    }

    private void work() throws IOException {
        try {
            this.requestHandler.handleRequest();
        }
        finally {
            try {
                this.file.delete();
            }
            catch (SecurityException e) {
                logger.warn("Unable to delete {}", (Object)this.file, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        ControlFileWatchdog controlFileWatchdog = this;
        synchronized (controlFileWatchdog) {
            if (this.thread == null) {
                this.thread = new Thread((Runnable)this, this.createThreadName());
                this.thread.setDaemon(true);
                this.alive = true;
                this.thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() throws InterruptedException {
        Thread stopping = null;
        ControlFileWatchdog controlFileWatchdog = this;
        synchronized (controlFileWatchdog) {
            if (this.thread != null) {
                this.alive = false;
                if (this.thread != Thread.currentThread()) {
                    this.thread.interrupt();
                    stopping = this.thread;
                }
                this.thread = null;
            }
        }
        if (stopping != null) {
            stopping.join(60000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAlive() {
        ControlFileWatchdog controlFileWatchdog = this;
        synchronized (controlFileWatchdog) {
            return this.alive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMe() {
        ControlFileWatchdog controlFileWatchdog = this;
        synchronized (controlFileWatchdog) {
            if (this.thread != null) {
                this.alive = false;
                this.thread = null;
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("@").append(System.identityHashCode(this)).append("{");
        sb.append("workingDir=").append(this.workingDir);
        sb.append(", file=").append(this.file);
        sb.append(", alive=").append(this.alive);
        sb.append(", stopAfterRequest=").append(this.stopAfterRequest);
        return sb.append("}").toString();
    }

    private String createThreadName() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " monitoring " + this.file.getName();
    }

    static interface ControlRequestHandler {
        public void handleRequest() throws IOException;
    }
}

