/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.Instantiator;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.internal.DSCODE;
import org.apache.geode.internal.DSFIDFactory;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.pdx.internal.EnumInfo;
import org.apache.geode.pdx.internal.PdxType;

public class DataType
implements DSCODE {
    public static final String getDataType(byte[] bytes) {
        DataInput in = DataType.getDataInput(bytes);
        byte header = 0;
        try {
            header = in.readByte();
        }
        catch (IOException e) {
            return "IOException: " + e.getMessage();
        }
        try {
            switch (header) {
                case 1: {
                    return "org.apache.geode.internal.DataSerializableFixedID:" + DSFIDFactory.create(in.readByte(), in).getClass().getName();
                }
                case 2: {
                    return "org.apache.geode.internal.DataSerializableFixedID:" + DSFIDFactory.create(in.readShort(), in).getClass().getName();
                }
                case 3: {
                    return "org.apache.geode.internal.DataSerializableFixedID:" + DSFIDFactory.create(in.readInt(), in).getClass().getName();
                }
                case 4: {
                    return "org.apache.geode.internal.DataSerializableFixedID:" + DataSerializer.readClass(in).getName();
                }
                case 41: {
                    return "null";
                }
                case 42: 
                case 69: 
                case 87: 
                case 88: 
                case 89: {
                    return "java.lang.String";
                }
                case 43: {
                    return "java.lang.Class";
                }
                case 61: {
                    return "java.util.Date";
                }
                case 63: {
                    return "java.io.File";
                }
                case 62: {
                    return "java.net.InetAddress";
                }
                case 53: {
                    return "java.lang.Boolean";
                }
                case 54: {
                    return "java.lang.Character";
                }
                case 55: {
                    return "java.lang.Byte";
                }
                case 56: {
                    return "java.lang.Short";
                }
                case 57: {
                    return "java.lang.Integer";
                }
                case 58: {
                    return "java.lang.Long";
                }
                case 59: {
                    return "java.lang.Float";
                }
                case 60: {
                    return "java.lang.Double";
                }
                case 46: {
                    return "byte[]";
                }
                case 91: {
                    return "byte[][]";
                }
                case 47: {
                    return "short[]";
                }
                case 64: {
                    return "java.lang.String[]";
                }
                case 48: {
                    return "int[]";
                }
                case 49: {
                    return "long[]";
                }
                case 50: {
                    return "float[]";
                }
                case 51: {
                    return "double[]";
                }
                case 26: {
                    return "boolean[]";
                }
                case 27: {
                    return "char[]";
                }
                case 52: {
                    return "java.lang.Object[]";
                }
                case 65: {
                    return "java.util.ArrayList";
                }
                case 10: {
                    return "java.util.LinkedList";
                }
                case 66: {
                    return "java.util.HashSet";
                }
                case 73: {
                    return "java.util.LinkedHashSet";
                }
                case 67: {
                    return "java.util.HashMap";
                }
                case 72: {
                    return "java.util.IdentityHashMap";
                }
                case 70: {
                    return "java.util.Hashtable";
                }
                case 11: {
                    return "java.util.Properties";
                }
                case 68: {
                    return "java.util.concurrent.TimeUnit";
                }
                case 40: {
                    byte userClassDSId = in.readByte();
                    return "DataSerializer: with Id:" + userClassDSId;
                }
                case 5: {
                    short userClass2DSId = in.readShort();
                    return "DataSerializer: with Id:" + userClass2DSId;
                }
                case 6: {
                    int userClass4DSId = in.readInt();
                    return "DataSerializer: with Id:" + userClass4DSId;
                }
                case 71: {
                    return "java.util.Vector";
                }
                case 74: {
                    return "java.util.Stack";
                }
                case 75: {
                    return "java.util.TreeMap";
                }
                case 76: {
                    return "java.util.TreeSet";
                }
                case 17: {
                    return "java.lang.Boolean.class";
                }
                case 18: {
                    return "java.lang.Character.class";
                }
                case 19: {
                    return "java.lang.Byte.class";
                }
                case 20: {
                    return "java.lang.Short.class";
                }
                case 21: {
                    return "java.lang.Integer.class";
                }
                case 22: {
                    return "java.lang.Long.class";
                }
                case 23: {
                    return "java.lang.Float.class";
                }
                case 24: {
                    return "java.lang.Double.class";
                }
                case 25: {
                    return "java.lang.Void.class";
                }
                case 39: {
                    Instantiator instantiator = InternalInstantiator.getInstantiator(in.readByte());
                    return "org.apache.geode.Instantiator:" + instantiator.getInstantiatedClass().getName();
                }
                case 38: {
                    Instantiator instantiator = InternalInstantiator.getInstantiator(in.readShort());
                    return "org.apache.geode.Instantiator:" + instantiator.getInstantiatedClass().getName();
                }
                case 37: {
                    Instantiator instantiator = InternalInstantiator.getInstantiator(in.readInt());
                    return "org.apache.geode.Instantiator:" + instantiator.getInstantiatedClass().getName();
                }
                case 45: {
                    return "org.apache.geode.DataSerializable:" + DataSerializer.readClass(in).getName();
                }
                case 44: {
                    String name = null;
                    try {
                        Object obj = InternalDataSerializer.basicReadObject(DataType.getDataInput(bytes));
                        name = obj.getClass().getName();
                    }
                    catch (ClassNotFoundException e) {
                        name = e.getMessage();
                    }
                    return "java.io.Serializable:" + name;
                }
                case 93: {
                    int typeId = in.readInt();
                    try {
                        GemFireCacheImpl gfc = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.");
                        PdxType pdxType = gfc.getPdxRegistry().getType(typeId);
                        if (pdxType == null) {
                            return "org.apache.geode.pdx.PdxInstance: unknown id=" + typeId;
                        }
                        return "org.apache.geode.pdx.PdxInstance:" + pdxType.getClassName();
                    }
                    catch (CacheClosedException e) {
                        return "org.apache.geode.pdx.PdxInstance:PdxRegistryClosed";
                    }
                }
                case 94: {
                    byte dsId = in.readByte();
                    int tmp = InternalDataSerializer.readArrayLength(in);
                    int enumId = dsId << 24 | tmp & 0xFFFFFF;
                    try {
                        GemFireCacheImpl gfc = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.");
                        EnumInfo enumInfo = gfc.getPdxRegistry().getEnumInfoById(enumId);
                        return "PdxRegistry/java.lang.Enum:" + enumInfo.getClassName();
                    }
                    catch (CacheClosedException e) {
                        return "PdxRegistry/java.lang.Enum:PdxRegistryClosed";
                    }
                }
                case 100: {
                    String name = DataSerializer.readString(in);
                    return "java.lang.Enum:" + name;
                }
                case 101: {
                    String name = DataSerializer.readString(in);
                    return "java.lang.Enum:" + name;
                }
                case 95: {
                    return "java.math.BigInteger";
                }
                case 96: {
                    return "java.math.BigDecimal";
                }
                case 98: {
                    return "java.util.UUID";
                }
                case 99: {
                    return "java.sql.Timestamp";
                }
            }
            return "Unknown header byte: " + header;
        }
        catch (IOException e) {
            throw new Error(e);
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
    }

    public static DataInput getDataInput(byte[] bytes) {
        return new DataInputStream(new ByteArrayInputStream(bytes));
    }
}

