/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.io.PrintStream;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.internal.logging.LogConfig;
import org.apache.geode.internal.logging.ManagerLogWriter;
import org.apache.geode.internal.logging.SecurityLogConfig;

public final class SecurityManagerLogWriter
extends ManagerLogWriter {
    public SecurityManagerLogWriter(int level, PrintStream stream) {
        super(level, stream);
    }

    public SecurityManagerLogWriter(int level, PrintStream stream, String connectionName) {
        super(level, stream, connectionName);
    }

    @Override
    public void setConfig(LogConfig config) {
        if (config instanceof DistributionConfig) {
            config = new SecurityLogConfig((DistributionConfig)config);
        }
        super.setConfig(config);
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public void put(int msgLevel, String msg, Throwable exception) {
        super.put(msgLevel, "security-" + SecurityManagerLogWriter.levelToString(msgLevel) + " " + msg, exception);
    }
}

