/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.FileUtil;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogFileParser;

public class MergeLogFiles {
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;

    public static boolean mergeLogFiles(InputStream[] logFiles, String[] logFileNames, PrintWriter mergedFile) {
        return MergeLogFiles.mergeLogFiles(logFiles, logFileNames, mergedFile, false, false, false, new LinkedList<String>());
    }

    public static boolean mergeLogFiles(InputStream[] logFiles, String[] logFileNames, PrintWriter mergedFile, boolean tabOut, boolean suppressBlanks, boolean multithreaded, List<String> patterns) {
        return Sorter.mergeLogFiles(logFiles, logFileNames, mergedFile, tabOut, suppressBlanks, multithreaded, patterns);
    }

    private static void usage(String s) {
        err.println("\n** " + s + "\n");
        err.println(LocalizedStrings.MergeLogFiles_USAGE.toLocalizedString() + ": java MergeLogFiles [(directory | logFile)]+");
        err.println("-dirCount n      " + LocalizedStrings.MergeLogFiles_NUMBER_OF_PARENT_DIRS_TO_PRINT.toLocalizedString());
        err.println("-mergeFile file  " + LocalizedStrings.MergeLogFiles_FILE_IN_WHICH_TO_PUT_MERGED_LOGS.toLocalizedString());
        err.println("-pids            " + LocalizedStrings.MergeLogFiles_SEARCH_FOR_PIDS_IN_FILE_NAMES_AND_USE_THEM_TO_IDENTIFY_FILES.toLocalizedString());
        err.println("-align           " + LocalizedStrings.MergeLogFiles_ALIGN_NONTIMESTAMPED_LINES_WITH_OTHERS.toLocalizedString());
        err.println("-noblanks        " + LocalizedStrings.MergeLogFiles_SUPPRESS_OUTPUT_OF_BLANK_LINES.toLocalizedString());
        err.println("-threaded        " + LocalizedStrings.MergeLogFiles_USE_MULTITHREADING_TO_TAKE_ADVANTAGE_OF_MULTIPLE_CPUS.toLocalizedString());
        err.println("");
        err.println(LocalizedStrings.MergeLogFiles_MERGES_MULTIPLE_GEMFIRE_LOG_FILES_AND_SORTS_THEM_BY_TIMESTAMP.toLocalizedString());
        err.println(LocalizedStrings.MergeLogFiles_THE_MERGED_LOG_FILE_IS_WRITTEN_TO_SYSTEM_OUT_OR_A_FILE.toLocalizedString());
        err.println("");
        err.println(LocalizedStrings.MergeLogFiles_IF_A_DIRECTORY_IS_SPECIFIED_ALL_LOG_FILES_IN_THAT_DIRECTORY_ARE_MERGED.toLocalizedString());
        err.println("");
        System.exit(1);
    }

    static ArrayList getLogFiles(String dirName) {
        ArrayList<File> result = new ArrayList<File>();
        File dir = new File(dirName);
        File[] names = FileUtil.listFiles(dir);
        for (int i = 0; i < names.length; ++i) {
            String n = names[i].getAbsolutePath();
            if (!n.endsWith(".log") && !n.endsWith(".log.gz")) continue;
            result.add(names[i]);
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        File mergeFile = null;
        ArrayList<File> files = new ArrayList<File>();
        ArrayList nickNames = null;
        int dirCount = 0;
        boolean findPIDs = false;
        boolean tabOut = false;
        boolean suppressBlanks = false;
        boolean multithreaded = false;
        LinkedList<String> patterns = new LinkedList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-align")) {
                tabOut = true;
                continue;
            }
            if (args[i].equals("-noblanks")) {
                suppressBlanks = true;
                continue;
            }
            if (args[i].equals("-pids")) {
                findPIDs = true;
                continue;
            }
            if (args[i].equals("-threaded")) {
                multithreaded = true;
                continue;
            }
            if (args[i].equals("-regex")) {
                if (i + 1 >= args.length) {
                    MergeLogFiles.usage("missing pattern for -regex option");
                }
                patterns.add(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equals("-dirCount")) {
                if (++i >= args.length) {
                    MergeLogFiles.usage(LocalizedStrings.MergeLogFiles_MISSING_NUMBER_OF_PARENT_DIRECTORIES.toLocalizedString());
                }
                try {
                    dirCount = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    MergeLogFiles.usage(LocalizedStrings.MergeLogFiles_NOT_A_NUMBER_0.toLocalizedString(args[i]));
                }
                continue;
            }
            if (args[i].equals("-mergeFile")) {
                if (++i >= args.length) {
                    MergeLogFiles.usage(LocalizedStrings.MergeLogFiles_MISSING_MERGE_FILE_NAME.toLocalizedString());
                }
                mergeFile = new File(args[i]);
                continue;
            }
            File file = new File(args[i]);
            if (!file.exists()) {
                MergeLogFiles.usage(LocalizedStrings.MergeLogFiles_FILE_0_DOES_NOT_EXIST.toLocalizedString(file));
            }
            files.add(file.getAbsoluteFile());
        }
        if (files.isEmpty()) {
            MergeLogFiles.usage(LocalizedStrings.MergeLogFiles_MISSING_FILENAME.toLocalizedString());
        }
        ArrayList<File> expandedFiles = new ArrayList<File>();
        for (int i = 0; i < files.size(); ++i) {
            File f = (File)files.get(i);
            String n = f.getAbsolutePath();
            if (!f.exists()) {
                MergeLogFiles.usage(LocalizedStrings.MergeLogFiles_FILE_0_DOES_NOT_EXIST.toLocalizedString(n));
            }
            if (f.isFile()) {
                expandedFiles.add(f);
                continue;
            }
            if (f.isDirectory()) {
                ArrayList moreFiles = MergeLogFiles.getLogFiles(n);
                expandedFiles.addAll(moreFiles);
                continue;
            }
            MergeLogFiles.usage(LocalizedStrings.MergeLogFiles_FILE_0_IS_NEITHER_A_FILE_NOR_A_DIRECTORY.toLocalizedString(n));
        }
        Collections.sort(expandedFiles);
        files = expandedFiles;
        PrintStream ps = mergeFile != null ? new PrintStream(new FileOutputStream(mergeFile), true) : out;
        PrintWriter mergedFile = new PrintWriter(ps, true);
        ps.println("Merged files (count = " + expandedFiles.size() + ") input list:");
        for (int i = 0; i < expandedFiles.size(); ++i) {
            ps.println("  " + expandedFiles.get(i));
        }
        ps.println("");
        if (findPIDs) {
            nickNames = MergeLogFiles.findPIDs(files, mergedFile);
        }
        InputStream[] logFiles = new InputStream[files.size()];
        String[] logFileNames = new String[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            File file = (File)files.get(i);
            logFiles[i] = new FileInputStream(file);
            if (findPIDs && nickNames.get(i) != null) {
                if (file.getCanonicalPath().toLowerCase().endsWith("gz")) {
                    logFileNames[i] = (String)nickNames.get(i) + ".gz";
                    continue;
                }
                logFileNames[i] = (String)nickNames.get(i);
                continue;
            }
            StringBuffer sb = new StringBuffer();
            File parent = file.getParentFile();
            for (int j = 0; j < dirCount && parent != null; ++j) {
                String parentName = parent.getName() + "/";
                if (parentName.equals("./")) {
                    parent = null;
                    continue;
                }
                sb.insert(0, parentName);
                parent = parent.getParentFile();
            }
            sb.append(file.getName());
            logFileNames[i] = sb.toString();
        }
        MergeLogFiles.mergeLogFiles(logFiles, logFileNames, mergedFile, tabOut, suppressBlanks, multithreaded, patterns);
        System.exit(0);
    }

    private static ArrayList findPIDs(ArrayList files, PrintWriter output) {
        int[] pidTable = new int[files.size()];
        int[] pidTableCounter = new int[pidTable.length];
        ArrayList<String> nickNames = new ArrayList<String>();
        char sep = File.separatorChar;
        block2: for (File f : files) {
            String slashdotslash;
            String name = f.getPath();
            int startIdx = name.lastIndexOf(slashdotslash = "" + sep + "." + sep);
            if (startIdx > 0) {
                name = name.substring(startIdx + slashdotslash.length());
            }
            if ((startIdx = name.lastIndexOf(sep)) > 0) {
                char c;
                if ('0' > (c = name.charAt(--startIdx)) || c > '9') {
                    startIdx = 0;
                } else {
                    int testIdx;
                    for (testIdx = startIdx - 1; testIdx > 0 && '0' <= name.charAt(testIdx) && name.charAt(testIdx) <= '9'; --testIdx) {
                    }
                    if (testIdx < 1 || name.charAt(testIdx) == '-') {
                        startIdx = 0;
                    }
                }
            }
            if (startIdx <= 0) {
                startIdx = name.length() - 1;
                if (startIdx > 6 && name.charAt(startIdx) == 'z' && name.charAt(startIdx - 1) == 'g' && name.charAt(startIdx - 2) == '.' && name.charAt(startIdx - 3) == 'g' && name.charAt(startIdx - 4) == 'o' && name.charAt(startIdx - 5) == 'l' && name.charAt(startIdx - 6) == '.') {
                    startIdx -= 7;
                } else if (startIdx > 3 && name.charAt(startIdx) == 'g' && name.charAt(startIdx - 1) == 'o' && name.charAt(startIdx - 2) == 'l' && name.charAt(startIdx - 3) == '.') {
                    startIdx -= 4;
                }
            }
            String PID = null;
            for (int i = startIdx; i >= 0; --i) {
                char c = name.charAt(i);
                if ('0' <= c && c <= '9') continue;
                if (i < name.length() - 1) {
                    PID = name.substring(i + 1, startIdx + 1);
                    try {
                        int iPID = Integer.valueOf(PID);
                        if (iPID > 0) {
                            int p;
                            for (p = 0; p < pidTable.length; ++p) {
                                if (pidTable[p] == 0) {
                                    pidTable[p] = iPID;
                                    pidTableCounter[p] = 1;
                                    break;
                                }
                                if (pidTable[p] != iPID) continue;
                                int n = p;
                                pidTableCounter[n] = pidTableCounter[n] + 1;
                                break;
                            }
                            Assert.assertTrue(p < pidTableCounter.length);
                            nickNames.add("" + iPID + "-" + pidTableCounter[p]);
                            output.println("nickname " + iPID + "-" + pidTableCounter[p] + ": " + name);
                            continue block2;
                        }
                        nickNames.add(null);
                    }
                    catch (NumberFormatException nfe) {
                        nickNames.add(null);
                    }
                    continue block2;
                }
                nickNames.add(null);
                continue block2;
            }
        }
        return nickNames;
    }

    protected static class ReaderComparator
    implements Comparator {
        protected ReaderComparator() {
        }

        public int compare(Object o1, Object o2) {
            String timestamp2;
            Reader reader1 = (Reader)o1;
            int id1 = reader1.getUniqueId();
            Reader reader2 = (Reader)o2;
            int id2 = reader2.getUniqueId();
            LogFileParser.LogEntry entry1 = reader1.peek();
            LogFileParser.LogEntry entry2 = reader2.peek();
            if (entry1 == null) {
                if (entry2 == null) {
                    if (id1 < id2) {
                        return -1;
                    }
                    return 1;
                }
                return -1;
            }
            if (entry2 == null) {
                return 1;
            }
            String timestamp1 = entry1.getTimestamp();
            int compare = timestamp1.compareTo(timestamp2 = entry2.getTimestamp());
            if (compare == 0) {
                if (id1 < id2) {
                    return -1;
                }
                return 1;
            }
            return compare;
        }
    }

    static class Sorter {
        Sorter() {
        }

        public static boolean mergeLogFiles(InputStream[] logFiles, String[] logFileNames, PrintWriter mergedFile, boolean tabOut, boolean suppressBlanks, boolean multithreaded, List<String> patterns) {
            if (logFiles.length != logFileNames.length) {
                throw new IllegalArgumentException(LocalizedStrings.MergeLogFiles_NUMBER_OF_LOG_FILES_0_IS_NOT_THE_SAME_AS_THE_NUMBER_OF_LOG_FILE_NAMES_1.toLocalizedString(logFiles.length, logFileNames.length));
            }
            LinkedList<Pattern> compiledPatterns = new LinkedList<Pattern>();
            for (String pattern : patterns) {
                compiledPatterns.add(Pattern.compile(pattern, 2));
            }
            ReaderGroup group = new ReaderGroup(LocalizedStrings.MergeLogFiles_READER_THREADS.toLocalizedString());
            ArrayList<Reader> readers = new ArrayList<Reader>(logFiles.length);
            for (int i = 0; i < logFiles.length; ++i) {
                if (multithreaded) {
                    readers.add(new ThreadedReader(logFiles[i], logFileNames[i], group, tabOut, suppressBlanks, compiledPatterns));
                    continue;
                }
                readers.add(new NonThreadedReader(logFiles[i], logFileNames[i], group, tabOut, suppressBlanks, compiledPatterns));
            }
            Reader lastOldest = null;
            Set sorted = Sorter.sortReaders(readers);
            while (!readers.isEmpty()) {
                Reader oldest = null;
                Iterator sortedIt = sorted.iterator();
                if (!sortedIt.hasNext()) break;
                oldest = (Reader)sortedIt.next();
                sortedIt.remove();
                String nextReaderTimestamp = null;
                Reader nextInLine = null;
                if (sortedIt.hasNext()) {
                    nextInLine = (Reader)sortedIt.next();
                    nextReaderTimestamp = nextInLine.peek().getTimestamp();
                }
                if (oldest != lastOldest) {
                    mergedFile.println();
                    lastOldest = oldest;
                }
                LogFileParser.LogEntry entry = null;
                do {
                    entry = oldest.peek();
                    String timestamp = entry.getTimestamp();
                    if (nextReaderTimestamp != null && nextReaderTimestamp.compareTo(timestamp) < 0) {
                        sorted.add(oldest);
                        entry = null;
                        break;
                    }
                    entry = oldest.poll();
                    entry.writeTo(mergedFile);
                } while (!entry.isLast());
                if (entry == null || !entry.isLast()) continue;
                readers.remove(oldest);
            }
            return group.exceptionOccurred();
        }

        private static Set sortReaders(Collection readers) {
            TreeSet<Reader> sorted = new TreeSet<Reader>(new ReaderComparator());
            int uniqueId = 1;
            for (Reader reader : readers) {
                if (reader == null) continue;
                reader.setUniqueId(uniqueId++);
                sorted.add(reader);
            }
            return sorted;
        }
    }

    static class ReaderGroup
    extends ThreadGroup {
        private boolean exceptionOccurred = false;

        ReaderGroup(String groupName) {
            super(groupName);
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (e instanceof VirtualMachineError) {
                SystemFailure.setFailure((VirtualMachineError)e);
            }
            this.exceptionOccurred = true;
            System.err.println(LocalizedStrings.MergeLogFiles_EXCEPTION_IN_0.toLocalizedString(t));
            e.printStackTrace(System.err);
        }

        public boolean exceptionOccurred() {
            return this.exceptionOccurred;
        }
    }

    static class ThreadedReader
    extends Thread
    implements Reader {
        private static int QUEUE_CAPACITY = 1000;
        private BufferedReader logFile;
        private String logFileName;
        private BlockingQueue queue;
        private boolean suppressBlanks;
        private boolean tabOut;
        private List<Pattern> patterns;
        private int uniqueId;

        public ThreadedReader(InputStream logFile, String logFileName, ThreadGroup group, boolean tabOut, boolean suppressBlanks, List<Pattern> patterns) {
            super(group, LocalizedStrings.MergeLogFiles_LOG_FILE_READER.toLocalizedString());
            if (logFileName.endsWith(".gz")) {
                try {
                    this.logFile = new BufferedReader(new InputStreamReader(new GZIPInputStream(logFile)));
                }
                catch (IOException e) {
                    System.err.println(logFileName + " does not appear to be in gzip format");
                    this.logFile = new BufferedReader(new InputStreamReader(logFile));
                }
            } else {
                this.logFile = new BufferedReader(new InputStreamReader(logFile));
            }
            this.logFileName = logFileName;
            this.queue = new LinkedBlockingQueue(QUEUE_CAPACITY);
            this.suppressBlanks = suppressBlanks;
            this.tabOut = tabOut;
            this.patterns = patterns;
            this.start();
        }

        @Override
        public String getFileName() {
            return this.logFileName;
        }

        @Override
        public void setUniqueId(int id) {
            this.uniqueId = id;
        }

        @Override
        public int getUniqueId() {
            return this.uniqueId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LogFileParser parser = new LogFileParser(this.logFileName, this.logFile, this.tabOut, this.suppressBlanks);
            try {
                LogFileParser.LogEntry entry;
                do {
                    SystemFailure.checkFailure();
                    entry = parser.getNextEntry();
                    if (!entry.isLast() && !this.patternMatch(entry)) continue;
                    this.queue.put(entry);
                    ThreadedReader threadedReader = this;
                    synchronized (threadedReader) {
                        this.notify();
                    }
                } while (!entry.isLast());
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }

        private boolean patternMatch(LogFileParser.LogEntry entry) {
            if (this.patterns == null || this.patterns.isEmpty()) {
                return true;
            }
            for (Pattern p : this.patterns) {
                if (!p.matcher(entry.getContents()).matches()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LogFileParser.LogEntry peek() {
            LogFileParser.LogEntry entry = (LogFileParser.LogEntry)this.queue.peek();
            if (entry == null) {
                ThreadedReader threadedReader = this;
                synchronized (threadedReader) {
                    entry = (LogFileParser.LogEntry)this.queue.peek();
                    while (entry == null) {
                        boolean interrupted = Thread.interrupted();
                        try {
                            this.wait();
                            entry = (LogFileParser.LogEntry)this.queue.peek();
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                        finally {
                            if (!interrupted) continue;
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
            return entry;
        }

        @Override
        public LogFileParser.LogEntry poll() {
            return (LogFileParser.LogEntry)this.queue.poll();
        }
    }

    static class NonThreadedReader
    implements Reader {
        private BufferedReader logFile;
        private String logFileName;
        private LogFileParser parser;
        private LogFileParser.LogEntry nextEntry;
        private List<Pattern> patterns;
        private int uniqueId;

        public NonThreadedReader(InputStream logFile, String logFileName, ThreadGroup group, boolean tabOut, boolean suppressBlanks, List<Pattern> patterns) {
            if (logFileName.endsWith(".gz")) {
                try {
                    this.logFile = new BufferedReader(new InputStreamReader(new GZIPInputStream(logFile)));
                }
                catch (IOException e) {
                    System.err.println(logFileName + " does not appear to be in gzip format");
                    this.logFile = new BufferedReader(new InputStreamReader(logFile));
                }
            } else {
                this.logFile = new BufferedReader(new InputStreamReader(logFile));
            }
            this.logFileName = logFileName;
            this.patterns = patterns;
            this.parser = new LogFileParser(this.logFileName, this.logFile, tabOut, suppressBlanks);
        }

        @Override
        public String getFileName() {
            return this.logFileName;
        }

        @Override
        public void setUniqueId(int id) {
            this.uniqueId = id;
        }

        @Override
        public int getUniqueId() {
            return this.uniqueId;
        }

        @Override
        public synchronized LogFileParser.LogEntry peek() {
            while (this.nextEntry == null) {
                try {
                    this.nextEntry = this.parser.getNextEntry();
                    if (this.nextEntry == null) {
                        return null;
                    }
                    if (!this.nextEntry.isLast() && this.patternMatch(this.nextEntry)) continue;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.err);
                }
            }
            return this.nextEntry;
        }

        private boolean patternMatch(LogFileParser.LogEntry entry) {
            if (this.patterns == null || this.patterns.isEmpty()) {
                return true;
            }
            for (Pattern p : this.patterns) {
                if (!p.matcher(entry.getContents()).matches()) continue;
                return true;
            }
            return false;
        }

        @Override
        public LogFileParser.LogEntry poll() {
            LogFileParser.LogEntry returnValue = null;
            if (this.nextEntry != null) {
                returnValue = this.nextEntry;
                this.nextEntry = null;
            } else {
                while (returnValue == null) {
                    try {
                        returnValue = this.parser.getNextEntry();
                        if (returnValue.isLast() || this.patternMatch(returnValue)) continue;
                        returnValue = null;
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace(System.err);
                        break;
                    }
                }
            }
            return returnValue;
        }
    }

    static interface Reader {
        public LogFileParser.LogEntry peek();

        public LogFileParser.LogEntry poll();

        public String getFileName();

        public void setUniqueId(int var1);

        public int getUniqueId();
    }
}

