/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.xmlcache;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.GatewayException;
import org.apache.geode.cache.InterestPolicy;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.SubscriptionAttributes;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientRegionFactory;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.PoolFactoryImpl;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.cache.xmlcache.DiskStoreAttributesCreation;
import org.apache.geode.internal.cache.xmlcache.RegionAttributesCreation;
import org.apache.geode.internal.cache.xmlcache.RegionCreation;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class ClientCacheCreation
extends CacheCreation
implements ClientCache {
    private static final RegionAttributes clientDefaults;

    public ClientCacheCreation() {
        this(false);
    }

    public ClientCacheCreation(boolean forParsing) {
        super(forParsing);
    }

    @Override
    RegionAttributes getDefaultAttributes() {
        return clientDefaults;
    }

    @Override
    protected void initializeRegionShortcuts() {
        GemFireCacheImpl.initializeClientRegionShortcuts(this);
    }

    @Override
    public QueryService getQueryService(String poolName) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public QueryService getLocalQueryService() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public <K, V> ClientRegionFactory<K, V> createClientRegionFactory(ClientRegionShortcut atts) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public <K, V> ClientRegionFactory<K, V> createClientRegionFactory(String regionAttributesId) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public RegionService createAuthenticatedView(Properties properties, String poolName) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public RegionService createAuthenticatedView(Properties userSecurityProperties) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setLockTimeout(int seconds) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setLockLease(int seconds) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setSearchTimeout(int seconds) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setMessageSyncInterval(int seconds) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public CacheServer addCacheServer() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setIsServer(boolean isServer) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void addBackup(File backup) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    void create(GemFireCacheImpl cache) throws TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        Object object;
        cache.setDeclarativeCacheConfig(this.getCacheConfig());
        if (!cache.isClient()) {
            throw new IllegalStateException("You must use ClientCacheFactory when the cache.xml uses client-cache.");
        }
        Map m = this.getPools();
        if (!m.isEmpty()) {
            boolean setDefault = m.size() == 1;
            for (Pool cp : m.values()) {
                PoolFactoryImpl f = (PoolFactoryImpl)PoolManager.createFactory();
                f.init(cp);
                object = (PoolImpl)f.create(cp.getName());
            }
        }
        cache.determineDefaultPool();
        if (this.hasResourceManager()) {
            this.getResourceManager().configure(cache.getResourceManager());
        }
        DiskStoreAttributesCreation pdxRegDSC = this.initializePdxDiskStore(cache);
        cache.initializePdxRegistry();
        for (DiskStoreAttributesCreation diskStoreAttributesCreation : this.listDiskStores()) {
            if (diskStoreAttributesCreation == pdxRegDSC) continue;
            this.createDiskStore(diskStoreAttributesCreation, cache);
        }
        for (DiskStoreAttributesCreation diskStoreAttributesCreation : this.listDiskStores()) {
            GemFireCacheImpl gfc = cache;
            DiskStoreFactory factory = gfc.createDiskStoreFactory(diskStoreAttributesCreation);
            object = factory.create(diskStoreAttributesCreation.getName());
        }
        if (this.hasDynamicRegionFactory()) {
            DynamicRegionFactory.get().open(this.getDynamicRegionFactoryConfig());
        }
        if (this.hasCopyOnRead()) {
            cache.setCopyOnRead(this.getCopyOnRead());
        }
        if (this.txMgrCreation != null && this.txMgrCreation.getListeners().length > 0 && cache.getCacheTransactionManager() != null) {
            cache.getCacheTransactionManager().initListeners(this.txMgrCreation.getListeners());
        }
        if (this.txMgrCreation != null && cache.getCacheTransactionManager() != null && this.txMgrCreation.getWriter() != null) {
            throw new IllegalStateException(LocalizedStrings.TXManager_NO_WRITER_ON_CLIENT.toLocalizedString());
        }
        cache.initializePdxRegistry();
        for (String string : this.regionAttributesNames) {
            RegionAttributesCreation creation = (RegionAttributesCreation)this.getRegionAttributes(string);
            creation.inheritAttributes(cache, false);
            AttributesFactory factory = new AttributesFactory(creation);
            RegionAttributes attrs = factory.createRegionAttributes();
            cache.setRegionAttributes(string, attrs);
        }
        for (RegionCreation regionCreation : this.roots.values()) {
            regionCreation.createRoot(cache);
        }
        cache.readyDynamicRegionFactory();
        this.runInitializer();
    }

    public String getDefaultPoolName() {
        String result = null;
        Map m = this.getPools();
        if (m.size() == 1) {
            Pool p = (Pool)m.values().iterator().next();
            result = p.getName();
        } else if (m.isEmpty()) {
            result = "DEFAULT";
        }
        return result;
    }

    @Override
    public Pool getDefaultPool() {
        return (Pool)this.getPools().get(this.getDefaultPoolName());
    }

    @Override
    public boolean getPdxReadSerialized() {
        return false;
    }

    @Override
    public Set<InetSocketAddress> getCurrentServers() {
        return Collections.EMPTY_SET;
    }

    static {
        AttributesFactory af = new AttributesFactory();
        af.setScope(Scope.LOCAL);
        af.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
        clientDefaults = af.create();
    }
}

