/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.pdx.internal.EnumInfo;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.logging.log4j.Logger;

public class AddPdxEnum
extends BaseCommand {
    private static final Logger logger = LogService.getLogger();
    private static final AddPdxEnum singleton = new AddPdxEnum();

    public static Command getCommand() {
        return singleton;
    }

    private AddPdxEnum() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException {
        servConn.setAsTrue(2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received get pdx id for enum request ({} parts) from {}", (Object)servConn.getName(), (Object)msg.getNumberOfParts(), (Object)servConn.getSocketString());
        }
        int noOfParts = msg.getNumberOfParts();
        EnumInfo enumInfo = (EnumInfo)msg.getPart(0).getObject();
        int enumId = msg.getPart(1).getInt();
        try {
            GemFireCacheImpl cache = (GemFireCacheImpl)servConn.getCache();
            TypeRegistry registry = cache.getPdxRegistry();
            registry.addRemoteEnum(enumId, enumInfo);
        }
        catch (Exception e) {
            AddPdxEnum.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        this.writeReply(msg, servConn);
        servConn.setAsTrue(1);
    }
}

