/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.AddPdxEnum;
import org.apache.geode.internal.cache.tier.sockets.command.AddPdxType;
import org.apache.geode.internal.cache.tier.sockets.command.ClearRegion;
import org.apache.geode.internal.cache.tier.sockets.command.ClientReady;
import org.apache.geode.internal.cache.tier.sockets.command.CloseConnection;
import org.apache.geode.internal.cache.tier.sockets.command.CommitCommand;
import org.apache.geode.internal.cache.tier.sockets.command.ContainsKey;
import org.apache.geode.internal.cache.tier.sockets.command.ContainsKey66;
import org.apache.geode.internal.cache.tier.sockets.command.CreateRegion;
import org.apache.geode.internal.cache.tier.sockets.command.Destroy;
import org.apache.geode.internal.cache.tier.sockets.command.Destroy65;
import org.apache.geode.internal.cache.tier.sockets.command.Destroy70;
import org.apache.geode.internal.cache.tier.sockets.command.DestroyRegion;
import org.apache.geode.internal.cache.tier.sockets.command.ExecuteFunction;
import org.apache.geode.internal.cache.tier.sockets.command.ExecuteFunction65;
import org.apache.geode.internal.cache.tier.sockets.command.ExecuteFunction66;
import org.apache.geode.internal.cache.tier.sockets.command.ExecuteFunction70;
import org.apache.geode.internal.cache.tier.sockets.command.ExecuteRegionFunction;
import org.apache.geode.internal.cache.tier.sockets.command.ExecuteRegionFunction65;
import org.apache.geode.internal.cache.tier.sockets.command.ExecuteRegionFunction66;
import org.apache.geode.internal.cache.tier.sockets.command.ExecuteRegionFunctionSingleHop;
import org.apache.geode.internal.cache.tier.sockets.command.GatewayReceiverCommand;
import org.apache.geode.internal.cache.tier.sockets.command.Get70;
import org.apache.geode.internal.cache.tier.sockets.command.GetAll;
import org.apache.geode.internal.cache.tier.sockets.command.GetAll651;
import org.apache.geode.internal.cache.tier.sockets.command.GetAll70;
import org.apache.geode.internal.cache.tier.sockets.command.GetAllForRI;
import org.apache.geode.internal.cache.tier.sockets.command.GetAllWithCallback;
import org.apache.geode.internal.cache.tier.sockets.command.GetClientPRMetadataCommand;
import org.apache.geode.internal.cache.tier.sockets.command.GetClientPRMetadataCommand66;
import org.apache.geode.internal.cache.tier.sockets.command.GetClientPartitionAttributesCommand;
import org.apache.geode.internal.cache.tier.sockets.command.GetClientPartitionAttributesCommand66;
import org.apache.geode.internal.cache.tier.sockets.command.GetEntry70;
import org.apache.geode.internal.cache.tier.sockets.command.GetEntryCommand;
import org.apache.geode.internal.cache.tier.sockets.command.GetFunctionAttribute;
import org.apache.geode.internal.cache.tier.sockets.command.GetPDXEnumById;
import org.apache.geode.internal.cache.tier.sockets.command.GetPDXIdForEnum;
import org.apache.geode.internal.cache.tier.sockets.command.GetPDXIdForType;
import org.apache.geode.internal.cache.tier.sockets.command.GetPDXTypeById;
import org.apache.geode.internal.cache.tier.sockets.command.GetPdxEnums70;
import org.apache.geode.internal.cache.tier.sockets.command.GetPdxTypes70;
import org.apache.geode.internal.cache.tier.sockets.command.Invalid;
import org.apache.geode.internal.cache.tier.sockets.command.Invalidate;
import org.apache.geode.internal.cache.tier.sockets.command.Invalidate70;
import org.apache.geode.internal.cache.tier.sockets.command.KeySet;
import org.apache.geode.internal.cache.tier.sockets.command.MakePrimary;
import org.apache.geode.internal.cache.tier.sockets.command.PeriodicAck;
import org.apache.geode.internal.cache.tier.sockets.command.Ping;
import org.apache.geode.internal.cache.tier.sockets.command.Put;
import org.apache.geode.internal.cache.tier.sockets.command.Put61;
import org.apache.geode.internal.cache.tier.sockets.command.Put65;
import org.apache.geode.internal.cache.tier.sockets.command.Put70;
import org.apache.geode.internal.cache.tier.sockets.command.PutAll;
import org.apache.geode.internal.cache.tier.sockets.command.PutAll70;
import org.apache.geode.internal.cache.tier.sockets.command.PutAll80;
import org.apache.geode.internal.cache.tier.sockets.command.PutAllWithCallback;
import org.apache.geode.internal.cache.tier.sockets.command.PutUserCredentials;
import org.apache.geode.internal.cache.tier.sockets.command.Query;
import org.apache.geode.internal.cache.tier.sockets.command.Query651;
import org.apache.geode.internal.cache.tier.sockets.command.RegisterDataSerializers;
import org.apache.geode.internal.cache.tier.sockets.command.RegisterInstantiators;
import org.apache.geode.internal.cache.tier.sockets.command.RegisterInterest;
import org.apache.geode.internal.cache.tier.sockets.command.RegisterInterest61;
import org.apache.geode.internal.cache.tier.sockets.command.RegisterInterestList;
import org.apache.geode.internal.cache.tier.sockets.command.RegisterInterestList61;
import org.apache.geode.internal.cache.tier.sockets.command.RegisterInterestList66;
import org.apache.geode.internal.cache.tier.sockets.command.RemoveAll;
import org.apache.geode.internal.cache.tier.sockets.command.RemoveUserAuth;
import org.apache.geode.internal.cache.tier.sockets.command.Request;
import org.apache.geode.internal.cache.tier.sockets.command.RequestEventValue;
import org.apache.geode.internal.cache.tier.sockets.command.RollbackCommand;
import org.apache.geode.internal.cache.tier.sockets.command.Size;
import org.apache.geode.internal.cache.tier.sockets.command.TXFailoverCommand;
import org.apache.geode.internal.cache.tier.sockets.command.TXSynchronizationCommand;
import org.apache.geode.internal.cache.tier.sockets.command.UnregisterInterest;
import org.apache.geode.internal.cache.tier.sockets.command.UnregisterInterestList;
import org.apache.geode.internal.cache.tier.sockets.command.UpdateClientNotification;

public class CommandInitializer {
    static Map<Version, Map<Integer, Command>> ALL_COMMANDS;

    public static void registerCommand(int messageType2, Map<Version, Command> versionToNewCommand) {
        Command command = null;
        for (Map.Entry<Version, Map<Integer, Command>> entry : ALL_COMMANDS.entrySet()) {
            Version version = entry.getKey();
            Map<Integer, Command> commandMap = entry.getValue();
            Command newerVersion = versionToNewCommand.get(version);
            if (newerVersion != null) {
                command = newerVersion;
            }
            if (command == null) continue;
            Command oldCommand = commandMap.get(messageType2);
            if (oldCommand != null && oldCommand != command) {
                throw new InternalGemFireError("Command is already defined int the map for message Type " + MessageType.getString(messageType2) + ". Old Value=" + commandMap.get(messageType2) + ", newValue=" + command + ", version=" + version);
            }
            commandMap.put(messageType2, command);
        }
    }

    private static void initializeAllCommands() {
        ALL_COMMANDS = new LinkedHashMap<Version, Map<Integer, Command>>();
        HashMap<Integer, Command> gfe57Commands = new HashMap<Integer, Command>();
        ALL_COMMANDS.put(Version.GFE_57, gfe57Commands);
        gfe57Commands.put(5, Ping.getCommand());
        gfe57Commands.put(0, Request.getCommand());
        gfe57Commands.put(7, Put.getCommand());
        gfe57Commands.put(56, PutAll.getCommand());
        gfe57Commands.put(9, Destroy.getCommand());
        gfe57Commands.put(34, Query.getCommand());
        gfe57Commands.put(36, ClearRegion.getCommand());
        gfe57Commands.put(11, DestroyRegion.getCommand());
        gfe57Commands.put(20, RegisterInterest.getCommand());
        gfe57Commands.put(22, UnregisterInterest.getCommand());
        gfe57Commands.put(24, RegisterInterestList.getCommand());
        gfe57Commands.put(25, UnregisterInterestList.getCommand());
        gfe57Commands.put(40, KeySet.getCommand());
        gfe57Commands.put(38, ContainsKey.getCommand());
        gfe57Commands.put(29, CreateRegion.getCommand());
        gfe57Commands.put(31, MakePrimary.getCommand());
        gfe57Commands.put(52, PeriodicAck.getCommand());
        gfe57Commands.put(51, RegisterInstantiators.getCommand());
        gfe57Commands.put(14, UpdateClientNotification.getCommand());
        gfe57Commands.put(18, CloseConnection.getCommand());
        gfe57Commands.put(53, ClientReady.getCommand());
        gfe57Commands.put(-1, Invalid.getCommand());
        gfe57Commands.put(57, GetAll.getCommand());
        HashMap<Integer, Command> gfe58Commands = new HashMap<Integer, Command>();
        ALL_COMMANDS.put(Version.GFE_58, gfe58Commands);
        gfe58Commands.putAll(ALL_COMMANDS.get(Version.GFE_57));
        gfe58Commands.put(59, ExecuteRegionFunction.getCommand());
        gfe58Commands.put(62, ExecuteFunction.getCommand());
        HashMap<Integer, Command> gfe603Commands = new HashMap<Integer, Command>();
        gfe603Commands.putAll(ALL_COMMANDS.get(Version.GFE_58));
        ALL_COMMANDS.put(Version.GFE_603, gfe603Commands);
        HashMap<Integer, Command> gfe61Commands = new HashMap<Integer, Command>();
        ALL_COMMANDS.put(Version.GFE_61, gfe61Commands);
        gfe61Commands.putAll(ALL_COMMANDS.get(Version.GFE_603));
        gfe61Commands.put(20, RegisterInterest61.getCommand());
        gfe61Commands.put(24, RegisterInterestList61.getCommand());
        gfe61Commands.put(68, RequestEventValue.getCommand());
        gfe61Commands.put(7, Put61.getCommand());
        gfe61Commands.put(67, RegisterDataSerializers.getCommand());
        HashMap<Integer, Command> gfe65Commands = new HashMap<Integer, Command>();
        ALL_COMMANDS.put(Version.GFE_65, gfe65Commands);
        gfe65Commands.putAll(ALL_COMMANDS.get(Version.GFE_61));
        gfe65Commands.put(9, Destroy65.getCommand());
        gfe65Commands.put(7, Put65.getCommand());
        gfe65Commands.put(59, ExecuteRegionFunction65.getCommand());
        gfe65Commands.put(62, ExecuteFunction65.getCommand());
        gfe65Commands.put(71, GetClientPRMetadataCommand.getCommand());
        gfe65Commands.put(73, GetClientPartitionAttributesCommand.getCommand());
        gfe65Commands.put(77, PutUserCredentials.getCommand());
        gfe65Commands.put(78, RemoveUserAuth.getCommand());
        gfe65Commands.put(79, ExecuteRegionFunctionSingleHop.getCommand());
        HashMap<Integer, Command> gfe651Commands = new HashMap<Integer, Command>();
        ALL_COMMANDS.put(Version.GFE_651, gfe651Commands);
        gfe651Commands.putAll(ALL_COMMANDS.get(Version.GFE_65));
        gfe651Commands.put(80, Query651.getCommand());
        HashMap<Integer, Command> gfe6516Commands = new HashMap<Integer, Command>();
        ALL_COMMANDS.put(Version.GFE_6516, gfe6516Commands);
        gfe6516Commands.putAll(ALL_COMMANDS.get(Version.GFE_651));
        gfe6516Commands.put(57, GetAll651.getCommand());
        gfe6516Commands.put(71, GetClientPRMetadataCommand66.getCommand());
        HashMap<Integer, Command> gfe66Commands = new HashMap<Integer, Command>();
        ALL_COMMANDS.put(Version.GFE_66, gfe66Commands);
        gfe66Commands.putAll(ALL_COMMANDS.get(Version.GFE_6516));
        gfe66Commands.put(94, AddPdxType.getCommand());
        gfe66Commands.put(93, GetPDXIdForType.getCommand());
        gfe66Commands.put(92, GetPDXTypeById.getCommand());
        gfe66Commands.put(81, Size.getCommand());
        gfe66Commands.put(83, Invalidate.getCommand());
        gfe66Commands.put(85, CommitCommand.getCommand());
        gfe66Commands.put(87, RollbackCommand.getCommand());
        gfe66Commands.put(88, TXFailoverCommand.getCommand());
        gfe66Commands.put(89, GetEntryCommand.getCommand());
        gfe66Commands.put(90, TXSynchronizationCommand.getCommand());
        gfe66Commands.put(73, GetClientPartitionAttributesCommand66.getCommand());
        gfe66Commands.put(24, RegisterInterestList66.getCommand());
        gfe66Commands.put(91, GetFunctionAttribute.getCommand());
        gfe66Commands.put(59, ExecuteRegionFunction66.getCommand());
        gfe66Commands.put(62, ExecuteFunction66.getCommand());
        gfe66Commands.put(95, GetAllForRI.getCommand());
        gfe66Commands.put(104, GatewayReceiverCommand.getCommand());
        gfe66Commands.put(38, ContainsKey66.getCommand());
        HashMap<Integer, Command> gfe662Commands = new HashMap<Integer, Command>();
        ALL_COMMANDS.put(Version.GFE_662, gfe662Commands);
        gfe662Commands.putAll(ALL_COMMANDS.get(Version.GFE_66));
        gfe662Commands.put(96, AddPdxEnum.getCommand());
        gfe662Commands.put(97, GetPDXIdForEnum.getCommand());
        gfe662Commands.put(98, GetPDXEnumById.getCommand());
        ALL_COMMANDS.put(Version.GFE_6622, gfe662Commands);
        HashMap<Integer, Command> gfe70Commands = new HashMap<Integer, Command>();
        ALL_COMMANDS.put(Version.GFE_70, gfe70Commands);
        gfe70Commands.putAll(ALL_COMMANDS.get(Version.GFE_662));
        gfe70Commands.remove(95);
        gfe70Commands.put(0, Get70.getCommand());
        gfe70Commands.put(89, GetEntry70.getCommand());
        gfe70Commands.put(100, GetAll70.getCommand());
        gfe70Commands.put(56, PutAll70.getCommand());
        gfe70Commands.put(7, Put70.getCommand());
        gfe70Commands.put(9, Destroy70.getCommand());
        gfe70Commands.put(83, Invalidate70.getCommand());
        gfe70Commands.put(101, GetPdxTypes70.getCommand());
        gfe70Commands.put(102, GetPdxEnums70.getCommand());
        gfe70Commands.put(62, ExecuteFunction70.getCommand());
        HashMap<Integer, Command> gfe701Commands = new HashMap<Integer, Command>();
        gfe701Commands.putAll(gfe70Commands);
        ALL_COMMANDS.put(Version.GFE_701, gfe701Commands);
        HashMap<Integer, Command> gfe71Commands = new HashMap<Integer, Command>();
        gfe71Commands.putAll(ALL_COMMANDS.get(Version.GFE_701));
        ALL_COMMANDS.put(Version.GFE_71, gfe71Commands);
        HashMap<Integer, Command> gfe80Commands = new HashMap<Integer, Command>();
        gfe80Commands.putAll(ALL_COMMANDS.get(Version.GFE_71));
        gfe80Commands.put(56, PutAll80.getCommand());
        ALL_COMMANDS.put(Version.GFE_80, gfe80Commands);
        HashMap<Integer, Command> gfe8009Commands = new HashMap<Integer, Command>();
        gfe8009Commands.putAll(ALL_COMMANDS.get(Version.GFE_80));
        ALL_COMMANDS.put(Version.GFE_8009, gfe8009Commands);
        HashMap<Integer, Command> gfe81Commands = new HashMap<Integer, Command>();
        gfe81Commands.putAll(ALL_COMMANDS.get(Version.GFE_80));
        gfe81Commands.put(107, GetAllWithCallback.getCommand());
        gfe81Commands.put(108, PutAllWithCallback.getCommand());
        gfe81Commands.put(109, RemoveAll.getCommand());
        ALL_COMMANDS.put(Version.GFE_81, gfe81Commands);
        HashMap<Integer, Command> gfe82Commands = new HashMap<Integer, Command>();
        gfe82Commands.putAll(ALL_COMMANDS.get(Version.GFE_81));
        ALL_COMMANDS.put(Version.GFE_82, gfe82Commands);
        HashMap<Integer, Command> gfe90Commands = new HashMap<Integer, Command>();
        gfe90Commands.putAll(ALL_COMMANDS.get(Version.GFE_82));
        ALL_COMMANDS.put(Version.GFE_90, gfe90Commands);
    }

    public static Map<Integer, Command> getCommands(Version version) {
        return ALL_COMMANDS.get(version);
    }

    public static Map<Integer, Command> getCommands(ServerConnection connection) {
        return CommandInitializer.getCommands(connection.getClientVersion());
    }

    public static void testSetCommands(Map<Integer, Command> testCommands) {
        ALL_COMMANDS.put(Version.TEST_VERSION, testCommands);
    }

    static {
        CommandInitializer.initializeAllCommands();
    }
}

