/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.snapshot;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.cache.snapshot.SnapshotOptions;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.execute.InternalExecution;
import org.apache.geode.internal.cache.execute.LocalResultCollector;
import org.apache.geode.internal.cache.snapshot.FlowController;
import org.apache.geode.internal.cache.snapshot.RegionSnapshotServiceImpl;
import org.apache.geode.internal.cache.snapshot.SnapshotPacket;

public class WindowedExporter<K, V>
implements RegionSnapshotServiceImpl.Exporter<K, V> {
    private static final int WINDOW_SIZE = Integer.getInteger("gemfire.WindowedExporter.WINDOW_SIZE", 10);

    @Override
    public long export(Region<K, V> region, RegionSnapshotServiceImpl.ExportSink sink, SnapshotOptions<K, V> options) throws IOException {
        long count = 0L;
        boolean error = true;
        LocalRegion local = RegionSnapshotServiceImpl.getLocalRegion(region);
        SnapshotPacket last = new SnapshotPacket();
        DistributedMember me = region.getCache().getDistributedSystem().getDistributedMember();
        WindowedArgs<K, V> args = new WindowedArgs<K, V>(me, options);
        WindowedExportCollector results = new WindowedExportCollector(local, last);
        try {
            SnapshotPacket packet;
            InternalExecution exec = (InternalExecution)FunctionService.onRegion(region).withArgs(args).withCollector(results);
            exec.setForwardExceptions(true);
            exec.execute(new WindowedExportFunction());
            Object queue = results.getResult();
            while ((packet = (SnapshotPacket)queue.take()) != last) {
                results.ack(packet);
                sink.write(packet.getRecords());
                count += (long)packet.getRecords().length;
            }
            error = false;
            FunctionException ex = results.getException();
            if (ex != null) {
                throw new IOException(ex);
            }
        }
        catch (FunctionException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        finally {
            if (error) {
                results.abort();
            }
        }
        return count;
    }

    private static class WindowedExportCollector
    implements LocalResultCollector<Object, BlockingQueue<SnapshotPacket>> {
        private final LocalRegion region;
        private final SnapshotPacket end;
        private final BlockingQueue<SnapshotPacket> entries;
        private final AtomicBoolean done;
        private final Map<DistributedMember, Integer> members;
        private volatile FunctionException exception;
        private volatile ReplyProcessor21 processor;

        public WindowedExportCollector(LocalRegion region, SnapshotPacket end) {
            this.region = region;
            this.end = end;
            this.done = new AtomicBoolean(false);
            this.members = new ConcurrentHashMap<DistributedMember, Integer>();
            this.entries = new LinkedBlockingQueue<SnapshotPacket>();
        }

        @Override
        public BlockingQueue<SnapshotPacket> getResult() throws FunctionException {
            return this.entries;
        }

        @Override
        public BlockingQueue<SnapshotPacket> getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
            return this.getResult();
        }

        public FunctionException getException() {
            return this.exception;
        }

        public void abort() {
            try {
                if (this.done.compareAndSet(false, true)) {
                    if (InternalDistributedSystem.getLoggerI18n().fineEnabled()) {
                        InternalDistributedSystem.getLoggerI18n().fine("SNP: Aborting export of region");
                    }
                    this.entries.clear();
                    this.entries.put(this.end);
                    for (Map.Entry<DistributedMember, Integer> entry : this.members.entrySet()) {
                        this.sendAbort(entry.getKey(), entry.getValue());
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        public void ack(SnapshotPacket packet) {
            FlowController.getInstance().sendAck(this.region.getDistributionManager(), packet.getSender(), packet.getWindowId(), packet.getPacketId());
        }

        @Override
        public void addResult(DistributedMember memberID, Object result) {
            if (!(result instanceof Throwable)) {
                int flowId = ((SnapshotPacket)result).getWindowId();
                if (this.done.get()) {
                    this.sendAbort(memberID, flowId);
                } else {
                    this.members.put(memberID, flowId);
                }
            }
            if (!this.done.get()) {
                try {
                    if (result instanceof Throwable) {
                        this.setException((Throwable)result);
                        this.endResults();
                    } else {
                        SnapshotPacket sp = (SnapshotPacket)result;
                        this.entries.put(sp);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        public void endResults() {
            try {
                if (this.done.compareAndSet(false, true)) {
                    if (InternalDistributedSystem.getLoggerI18n().fineEnabled()) {
                        InternalDistributedSystem.getLoggerI18n().fine("SNP: All results received for export of region " + this.region.getName());
                    }
                    this.entries.put(this.end);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void clearResults() {
            this.entries.clear();
            this.done.set(false);
            this.exception = null;
        }

        @Override
        public void setException(Throwable ex) {
            this.exception = ex instanceof FunctionException ? (FunctionException)ex : new FunctionException(ex);
        }

        @Override
        public void setProcessor(ReplyProcessor21 processor) {
            this.processor = processor;
        }

        @Override
        public ReplyProcessor21 getProcessor() {
            return this.processor;
        }

        private void sendAbort(DistributedMember member, int flowId) {
            FlowController.getInstance().sendAbort(this.region.getDistributionManager(), flowId, member);
        }
    }

    private static class WindowedExportFunction<K, V>
    implements Function {
        private static final long serialVersionUID = 1L;
        private volatile transient FlowController.Window window;

        private WindowedExportFunction() {
        }

        @Override
        public boolean hasResult() {
            return true;
        }

        @Override
        public void execute(FunctionContext context) {
            RegionFunctionContext ctx = (RegionFunctionContext)context;
            WindowedArgs args = (WindowedArgs)ctx.getArguments();
            ResultSender<SnapshotPacket> rs = ctx.getResultSender();
            Region region = ctx.getDataSet();
            if (PartitionRegionHelper.isPartitionedRegion(region)) {
                region = PartitionRegionHelper.getLocalDataForContext(ctx);
            }
            LocalRegion local = RegionSnapshotServiceImpl.getLocalRegion(region);
            this.window = FlowController.getInstance().create(region, args.getExporter(), WINDOW_SIZE);
            try {
                int bufferSize = 0;
                ArrayList<SnapshotPacket.SnapshotRecord> buffer = new ArrayList<SnapshotPacket.SnapshotRecord>();
                DistributedMember me = region.getCache().getDistributedSystem().getDistributedMember();
                Iterator iter = region.entrySet().iterator();
                while (iter.hasNext() && !this.window.isAborted()) {
                    Map.Entry entry = iter.next();
                    try {
                        SnapshotOptions options = args.getOptions();
                        if (options.getFilter() == null || options.getFilter().accept(entry)) {
                            SnapshotPacket.SnapshotRecord rec = new SnapshotPacket.SnapshotRecord(local, entry);
                            buffer.add(rec);
                            bufferSize += rec.getSize();
                        }
                    }
                    catch (EntryDestroyedException options) {
                    }
                    catch (IOException e) {
                        throw new FunctionException(e);
                    }
                    if (bufferSize <= RegionSnapshotServiceImpl.BUFFER_SIZE) continue;
                    this.window.waitForOpening();
                    rs.sendResult(new SnapshotPacket(this.window.getWindowId(), me, buffer));
                    buffer.clear();
                    bufferSize = 0;
                }
                this.window.waitForOpening();
                rs.lastResult(new SnapshotPacket(this.window.getWindowId(), me, buffer));
                if (InternalDistributedSystem.getLoggerI18n().fineEnabled()) {
                    InternalDistributedSystem.getLoggerI18n().fine("SNP: Sent all entries in region " + region.getName());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new FunctionException(e);
            }
            finally {
                this.window.close();
            }
        }

        @Override
        public String getId() {
            return "org.apache.geode.cache.snapshot.WindowedExport";
        }

        @Override
        public boolean optimizeForWrite() {
            return false;
        }

        @Override
        public boolean isHA() {
            return false;
        }
    }

    private static class WindowedArgs<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final DistributedMember exporter;
        private final SnapshotOptions<K, V> options;

        public WindowedArgs(DistributedMember exporter, SnapshotOptions<K, V> options) {
            this.exporter = exporter;
            this.options = options;
        }

        public DistributedMember getExporter() {
            return this.exporter;
        }

        public SnapshotOptions<K, V> getOptions() {
            return this.options;
        }
    }
}

