/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence.query.mock;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.persistence.query.CloseableIterator;
import org.apache.geode.internal.cache.persistence.query.IdentityExtractor;
import org.apache.geode.internal.cache.persistence.query.ResultBag;
import org.apache.geode.internal.cache.persistence.query.SortKeyExtractor;
import org.apache.geode.internal.cache.persistence.query.mock.IndexMapImpl;

public class SortedResultBagImpl
implements ResultBag {
    private final IndexMapImpl map;
    private AtomicLong counter = new AtomicLong();
    private SortKeyExtractor extractor;
    private boolean reverse;

    public SortedResultBagImpl(SortKeyExtractor extractor, boolean reverse) {
        this.extractor = extractor == null ? new IdentityExtractor() : extractor;
        this.map = new IndexMapImpl();
        this.reverse = reverse;
    }

    @Override
    public void add(Object e) {
        this.map.put(this.extractor.getSortKey(e), this.counter.incrementAndGet(), e);
    }

    @Override
    public CloseableIterator<CachedDeserializable> iterator() {
        if (this.reverse) {
            return this.map.descendingValueIterator();
        }
        return this.map.valueIterator();
    }

    @Override
    public void close() {
        this.map.destroy();
    }
}

