/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.partitioned.IdentityRequestMessage;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public final class IdentityUpdateMessage
extends DistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private int processorId;
    private int newId;

    public IdentityUpdateMessage() {
    }

    public IdentityUpdateMessage(Set recipients, int processorId, int newId) {
        this.setRecipients(recipients);
        this.processorId = processorId;
        this.newId = newId;
    }

    @Override
    public int getProcessorType() {
        return 75;
    }

    @Override
    protected void process(DistributionManager dm) {
        try {
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{}: processing message {}", (Object)this.getClass().getName(), (Object)this);
            }
            IdentityRequestMessage.setLatestId(this.newId);
            ReplyMessage.send(this.getSender(), this.getProcessorId(), null, (ReplySender)dm);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            logger.debug("{} Caught throwable {}", (Object)this, (Object)t.getMessage(), (Object)t);
        }
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    public static IdentityUpdateResponse send(Set recipients, InternalDistributedSystem is, int currentPRId) {
        Assert.assertTrue(recipients != null, "IdentityUpdateMessage NULL recipients set");
        IdentityRequestMessage.setLatestId(currentPRId);
        IdentityUpdateResponse p = new IdentityUpdateResponse(is, recipients);
        IdentityUpdateMessage m = new IdentityUpdateMessage(recipients, p.getProcessorId(), currentPRId);
        is.getDistributionManager().putOutgoing(m);
        return p;
    }

    @Override
    public int getDSFID() {
        return 51;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
        this.newId = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.processorId);
        out.writeInt(this.newId);
    }

    @Override
    public String toString() {
        return new StringBuffer().append(this.getClass().getName()).append("(sender=").append(this.getSender()).append("; processorId=").append(this.processorId).append("; newPRId=").append(this.newId).append(")").toString();
    }

    public static class IdentityUpdateResponse
    extends ReplyProcessor21 {
        public IdentityUpdateResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, (Collection)recipients);
        }

        @Override
        protected synchronized void processException(ReplyException ex) {
            logger.debug("IdentityUpdateResponse ignoring exception {}", (Object)ex.getMessage(), (Object)ex);
        }
    }
}

