/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.ha;

import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.ha.HARegionQueue;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;

class ThreadIdentifierCustomExpiry
implements CustomExpiry {
    private static final ExpirationAttributes DEFAULT_THREAD_ID_EXP_ATTS = new ExpirationAttributes(300, ExpirationAction.LOCAL_INVALIDATE);
    private static volatile ExpirationAttributes testExpAtts = null;

    ThreadIdentifierCustomExpiry() {
    }

    public ExpirationAttributes getExpiry(Region.Entry entry) {
        Object key = entry.getKey();
        if (key instanceof ThreadIdentifier) {
            int expTime = HARegionQueue.threadIdExpiryTime;
            if (expTime != 300) {
                ExpirationAttributes result = testExpAtts;
                if (result == null || result.getTimeout() != expTime) {
                    testExpAtts = result = new ExpirationAttributes(expTime, ExpirationAction.LOCAL_INVALIDATE);
                }
                return result;
            }
            return DEFAULT_THREAD_ID_EXP_ATTS;
        }
        return null;
    }

    @Override
    public void close() {
    }
}

