/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.ha;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.MirrorType;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.query.internal.CqQueryVsdStats;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.InternalCqQuery;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.Conflatable;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.HARegion;
import org.apache.geode.internal.cache.RegionQueue;
import org.apache.geode.internal.cache.ha.HAContainerMap;
import org.apache.geode.internal.cache.ha.HAContainerWrapper;
import org.apache.geode.internal.cache.ha.HARegionQueueAttributes;
import org.apache.geode.internal.cache.ha.HARegionQueueStats;
import org.apache.geode.internal.cache.ha.MapWrapper;
import org.apache.geode.internal.cache.ha.QueueRemovalMessage;
import org.apache.geode.internal.cache.ha.RemovedEventInfo;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.ha.ThreadIdentifierCustomExpiry;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.ClientMarkerMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.HAEventWrapper;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.util.concurrent.StoppableCondition;
import org.apache.geode.internal.util.concurrent.StoppableReentrantLock;
import org.apache.geode.internal.util.concurrent.StoppableReentrantReadWriteLock;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class HARegionQueue
implements RegionQueue {
    private static final Logger logger = LogService.getLogger();
    protected HARegion region;
    protected final AtomicLong tailKey = new AtomicLong(0L);
    protected final ConcurrentMap eventsMap = new ConcurrentHashMap();
    protected volatile Map indexes = Collections.unmodifiableMap(new HashMap());
    private final StoppableReentrantReadWriteLock rwLock;
    private final StoppableReentrantReadWriteLock.StoppableReadLock readLock;
    private final StoppableReentrantReadWriteLock.StoppableWriteLock writeLock;
    private final String regionName;
    private final ClientProxyMembershipID clientProxyID;
    public final HARegionQueueStats stats;
    protected LinkedHashSet idsAvailable;
    static ConcurrentMap dispatchedMessagesMap;
    protected final MapWrapper threadIdToSeqId;
    protected boolean puttingGIIDataInQueue;
    private boolean hasRegisteredInterest;
    protected static final ThreadLocal peekedEventsContext;
    private static QueueRemovalThread qrmThread;
    private final StoppableReentrantReadWriteLock giiLock;
    private volatile int giiCount;
    private Queue giiQueue = new ConcurrentLinkedQueue();
    public static final int BLOCKING_HA_QUEUE = 1;
    public static final int NON_BLOCKING_HA_QUEUE = 2;
    public static final String HA_EVICTION_POLICY_NONE = "none";
    public static final String HA_EVICTION_POLICY_MEMORY = "mem";
    public static final String HA_EVICTION_POLICY_ENTRY = "entry";
    public static final long INIT_OF_SEQUENCEID = -1L;
    public static final String REGION_ENTRY_EXPIRY_TIME = "gemfire.MessageTimeToLive";
    public static final int DEFAULT_MESSAGE_SYNC_INTERVAL = 1;
    protected static volatile int messageSyncInterval;
    protected Map haContainer;
    private volatile boolean isPrimary = false;
    protected volatile boolean destroyInProgress = false;
    private final CancelCriterion stopper;
    protected byte clientConflation = 0;
    public boolean isClientSlowReciever = false;
    final AtomicBoolean initialized = new AtomicBoolean();
    static boolean testMarkerMessageRecieved;
    static boolean isUsedByTest;
    static final int DEFAULT_THREAD_ID_EXPIRY_TIME = 300;
    public static int threadIdExpiryTime;
    protected Map ackedEvents;
    protected long maxQueueSizeHitCount = 0L;

    public static String createRegionName(String regionName) {
        String result = regionName.replace('/', '#');
        return result;
    }

    protected HARegionQueue(String regionName, GemFireCacheImpl cache, HARegionQueueAttributes haAttributes, Map haContainer, ClientProxyMembershipID clientProxyId, byte clientConflation, boolean isPrimary) throws IOException, ClassNotFoundException, CacheException, InterruptedException {
        String processedRegionName = HARegionQueue.createRegionName(regionName);
        this.threadIdToSeqId = new MapWrapper();
        this.idsAvailable = new LinkedHashSet();
        this.regionName = processedRegionName;
        this.setClientConflation(clientConflation);
        this.isPrimary = isPrimary;
        InternalDistributedSystem factory = cache.getDistributedSystem();
        this.stats = new HARegionQueueStats(factory, processedRegionName);
        this.haContainer = haContainer;
        this.giiLock = new StoppableReentrantReadWriteLock(cache.getCancelCriterion());
        this.clientProxyID = clientProxyId;
        this.createHARegion(processedRegionName, cache);
        this.stopper = this.region.getCancelCriterion();
        this.rwLock = new StoppableReentrantReadWriteLock(this.stopper);
        this.readLock = this.rwLock.readLock();
        this.writeLock = this.rwLock.writeLock();
        this.putGIIDataInRegion();
        if (this.getClass() == HARegionQueue.class) {
            this.initialized.set(true);
        }
    }

    private void createHARegion(String processedRegionName, GemFireCacheImpl cache) throws IOException, ClassNotFoundException {
        AttributesFactory af = new AttributesFactory();
        af.setMirrorType(MirrorType.KEYS_VALUES);
        af.addCacheListener(this.createCacheListenerForHARegion());
        af.setStatisticsEnabled(true);
        RegionAttributes ra = af.create();
        this.region = HARegion.getInstance(processedRegionName, cache, this, ra);
        if (this.isPrimary) {
            this.disableEntryExpiryTasks();
        }
    }

    public void reinitializeRegion() {
        GemFireCacheImpl cache = this.region.getCache();
        String regionName = this.region.getName();
        this.region.destroyRegion();
        Exception problem = null;
        try {
            this.createHARegion(regionName, cache);
        }
        catch (IOException e) {
            problem = e;
        }
        catch (ClassNotFoundException e) {
            problem = e;
        }
        if (problem != null) {
            throw new InternalGemFireException("Problem recreating region queue '" + regionName + "'");
        }
        try {
            this.putGIIDataInRegion();
        }
        catch (InterruptedException e) {
            cache.getCancelCriterion().checkCancelInProgress(e);
            Thread.currentThread().interrupt();
        }
    }

    public void recordEventState(InternalDistributedMember sender, Map eventState) {
        StringBuffer sb = null;
        boolean isDebugEnabled_BS = logger.isTraceEnabled(LogMarker.BRIDGE_SERVER);
        if (isDebugEnabled_BS) {
            sb = new StringBuffer(500);
            sb.append("Recording initial event state for ").append(this.regionName).append(" from ").append(sender);
        }
        for (Map.Entry entry : eventState.entrySet()) {
            DispatchedAndCurrentEvents o;
            DispatchedAndCurrentEvents giiDace = (DispatchedAndCurrentEvents)entry.getValue();
            if (giiDace == null) continue;
            giiDace.owningQueue = this;
            giiDace.isGIIDace = true;
            if (giiDace.QRM_LOCK == null) {
                giiDace.QRM_LOCK = new Object();
            }
            if (isDebugEnabled_BS) {
                sb.append("\n  ").append(((ThreadIdentifier)entry.getKey()).expensiveToString()).append("; sequenceID=").append(giiDace.lastSequenceIDPut);
            }
            if ((o = this.eventsMap.putIfAbsent(entry.getKey(), giiDace)) == null || !isDebugEnabled_BS) continue;
            sb.append(" -- could not store.  found " + o);
        }
        if (isDebugEnabled_BS) {
            logger.trace(LogMarker.BRIDGE_SERVER, sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putGIIDataInRegion() throws CacheException, InterruptedException {
        Set entrySet = this.region.entries(false);
        if (!entrySet.isEmpty()) {
            this.puttingGIIDataInQueue = true;
            boolean isDebugEnabled = logger.isDebugEnabled();
            try {
                Region.Entry entry = null;
                TreeMap orderedMap = new TreeMap();
                Iterator<Object> iterator = entrySet.iterator();
                Object key = null;
                while (iterator.hasNext()) {
                    entry = (Region.Entry)iterator.next();
                    key = entry.getKey();
                    if (isDebugEnabled) {
                        logger.debug("processing queue key {} and value {}", key, entry.getValue());
                    }
                    if (key instanceof Long && !(entry.getValue() instanceof ClientMarkerMessageImpl)) {
                        orderedMap.put(key, entry.getValue());
                    }
                    this.region.localDestroy(key);
                }
                long max = 0L;
                long counterInRegion = 0L;
                entrySet = orderedMap.entrySet();
                if (!entrySet.isEmpty()) {
                    Object var11_9 = null;
                    for (Map.Entry entry2 : entrySet) {
                        Conflatable val = (Conflatable)entry2.getValue();
                        if (val.getEventId() != null) {
                            counterInRegion = ((Long)entry2.getKey()).intValue();
                            Assert.assertTrue(counterInRegion > max);
                            max = counterInRegion;
                            this.put(val);
                            continue;
                        }
                        if (!isDebugEnabled) continue;
                        logger.debug("bug 44959 encountered: HARegion.putGIIDataInRegion found null eventId in {}", (Object)val);
                    }
                }
                this.tailKey.set(max);
            }
            finally {
                this.puttingGIIDataInQueue = false;
                if (isDebugEnabled) {
                    logger.debug("{} done putting GII data into queue", (Object)this);
                }
            }
        }
        HARegionQueue.startHAServices(this.region.getCache());
    }

    protected void putInQueue(Object val) throws InterruptedException {
        if (val instanceof HAEventWrapper && ((HAEventWrapper)val).getClientUpdateMessage() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("HARegionQueue.putGIIDataInRegion(): key={} was removed at sender side, so not putting it into the ha queue.", ((HAEventWrapper)val).getKeyToConflate());
            }
        } else {
            this.put(val);
        }
    }

    protected boolean shouldBeConflated(Conflatable event) {
        boolean retVal = event.shouldBeConflated();
        if (event instanceof ClientMarkerMessageImpl) {
            return retVal;
        }
        switch (this.clientConflation) {
            case 2: {
                return false;
            }
            case 1: {
                if (event instanceof HAEventWrapper) {
                    ClientUpdateMessage cum = (ClientUpdateMessage)this.haContainer.get(event);
                    if (cum == null) break;
                    retVal = cum.isUpdate();
                    break;
                }
                if (!(event instanceof ClientUpdateMessage)) break;
                retVal = ((ClientUpdateMessage)event).isUpdate();
                break;
            }
            case 0: {
                return retVal;
            }
            default: {
                throw new InternalGemFireError("Invalid clientConflation");
            }
        }
        return retVal;
    }

    @Override
    public boolean put(Object object) throws CacheException, InterruptedException {
        this.giiLock.readLock().lock();
        try {
            if (this.giiCount > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: adding message to GII queue of size {}: {}", (Object)this.region.getName(), (Object)this.giiQueue.size(), object);
                }
                if (object instanceof HAEventWrapper) {
                    this.putEntryConditionallyIntoHAContainer((HAEventWrapper)object);
                }
                this.giiQueue.add(object);
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("{}: adding message to HA queue: {}", (Object)this.region.getName(), object);
                }
                this.basicPut(object);
            }
        }
        finally {
            this.giiLock.readLock().unlock();
        }
        return true;
    }

    private void basicPut(Object object) throws CacheException, InterruptedException {
        try {
            this.checkQueueSizeConstraint();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            this.region.getCache().getCancelCriterion().checkCancelInProgress(ie);
        }
        Conflatable event = (Conflatable)object;
        EventID eventId = event.getEventId();
        ThreadIdentifier ti = HARegionQueue.getThreadIdentifier(eventId);
        long sequenceID = eventId.getSequenceID();
        DispatchedAndCurrentEvents dace = (DispatchedAndCurrentEvents)this.eventsMap.get(ti);
        if (dace != null && dace.isGIIDace && this.puttingGIIDataInQueue) {
            dace = null;
        }
        if (dace != null) {
            if (this.puttingGIIDataInQueue || sequenceID > dace.lastDispatchedSequenceId) {
                if (!dace.putObject(event, sequenceID)) {
                    if (!this.puttingGIIDataInQueue) {
                        this.put(object);
                    }
                } else if (logger.isTraceEnabled(LogMarker.BRIDGE_SERVER)) {
                    logger.trace(LogMarker.BRIDGE_SERVER, "{}: Adding message to queue: {}", (Object)this, object);
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: This queue has already seen this event.  The highest sequence number in the queue for {} is {}, but this event's sequence number is {}", (Object)this.regionName, (Object)ti, (Object)dace.lastDispatchedSequenceId, (Object)sequenceID);
                }
                this.incrementTakeSidePutPermits();
            }
        } else {
            dace = new DispatchedAndCurrentEvents(this);
            DispatchedAndCurrentEvents oldDace = this.eventsMap.putIfAbsent(ti, dace);
            if (oldDace != null) {
                dace = oldDace;
            } else {
                this.region.put(ti, (Object)dace.lastDispatchedSequenceId);
                this.stats.incThreadIdentifiers();
            }
            if (!dace.putObject(event, sequenceID)) {
                this.put(object);
            } else if (logger.isTraceEnabled(LogMarker.BRIDGE_SERVER)) {
                logger.trace(LogMarker.BRIDGE_SERVER, "{}: Adding message to queue: {}", (Object)this, object);
            }
        }
    }

    public void startGiiQueueing() {
        this.giiLock.writeLock().lock();
        ++this.giiCount;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: startGiiQueueing count is now {}", (Object)this.region.getName(), (Object)this.giiCount);
        }
        this.giiLock.writeLock().unlock();
    }

    public void endGiiQueueing() {
        block20: {
            this.giiLock.writeLock().lock();
            boolean isDebugEnabled = logger.isDebugEnabled();
            try {
                --this.giiCount;
                if (isDebugEnabled) {
                    logger.debug("{}: endGiiQueueing count is now {}", (Object)this.region.getName(), (Object)this.giiCount);
                }
                if (this.giiCount < 0) {
                    if (isDebugEnabled) {
                        logger.debug("{} found giiCount to be {}", (Object)this.region.getName(), (Object)this.giiCount);
                    }
                    this.giiCount = 0;
                }
                if (this.giiCount != 0) break block20;
                if (isDebugEnabled) {
                    logger.debug("all GII requests completed - draining {} messages", (Object)this.giiQueue.size());
                }
                boolean interrupted = false;
                int expectedCount = this.giiQueue.size();
                int actualCount = 0;
                while (true) {
                    Object value;
                    try {
                        value = this.giiQueue.remove();
                    }
                    catch (NoSuchElementException e) {
                        break;
                    }
                    ++actualCount;
                    try {
                        if (isDebugEnabled) {
                            logger.debug("draining #{}: {}", (Object)(actualCount + 1), value);
                        }
                        if (value instanceof HAEventWrapper && ((HAEventWrapper)value).getClientUpdateMessage() == null && (value = this.haContainer.get(value)) == null) {
                            if (!isDebugEnabled) continue;
                            logger.debug("ATTENTION: found gii queued event with null event message.  Please see bug #44852: {}", value);
                            continue;
                        }
                        this.basicPut(value);
                        if (!(value instanceof HAEventWrapper)) continue;
                        this.decAndRemoveFromHAContainer((HAEventWrapper)value);
                        continue;
                    }
                    catch (NoSuchElementException e) {
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
                if (interrupted) {
                    this.region.getCache().getCancelCriterion().checkCancelInProgress(new InterruptedException());
                    Thread.currentThread().interrupt();
                }
            }
            catch (RuntimeException t) {
                logger.fatal("endGiiQueueing terminating due to uncaught runtime exception", (Throwable)t);
                throw t;
            }
            catch (Error t) {
                logger.fatal("endGiiQueueing terminating due to uncaught error", (Throwable)t);
                throw t;
            }
            finally {
                if (logger.isTraceEnabled()) {
                    logger.trace("endGiiQueueing completed");
                }
                this.giiLock.writeLock().unlock();
            }
        }
    }

    public Map getEventMapForGII() {
        ConcurrentMap events = this.eventsMap;
        boolean isDebugEnabled = logger.isDebugEnabled();
        while (true) {
            HashMap result = new HashMap();
            try {
                for (Map.Entry entry : events.entrySet()) {
                    if (!((DispatchedAndCurrentEvents)entry.getValue()).isCountersEmpty()) continue;
                    result.put(entry.getKey(), entry.getValue());
                }
                return result;
            }
            catch (ConcurrentModificationException e) {
                if (!isDebugEnabled) continue;
                logger.debug("HARegion encountered concurrent modification exception while analysing event state - will try again");
                continue;
            }
            break;
        }
    }

    void checkQueueSizeConstraint() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    void incrementTakeSidePutPermitsWithoutNotify() {
    }

    public static synchronized void startHAServices(GemFireCacheImpl c) {
        if (qrmThread == null) {
            dispatchedMessagesMap = new ConcurrentHashMap();
            qrmThread = new QueueRemovalThread(c);
            qrmThread.setName("Queue Removal Thread");
            qrmThread.start();
        }
    }

    public static synchronized void stopHAServices() {
        if (qrmThread != null) {
            qrmThread.shutdown();
            qrmThread = null;
            dispatchedMessagesMap.clear();
            dispatchedMessagesMap = null;
        }
    }

    public static int getMessageSyncInterval() {
        return messageSyncInterval;
    }

    public static void setMessageSyncInterval(int seconds) {
        messageSyncInterval = seconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long addToConflationMap(Conflatable event, Long newPosition) {
        String r = event.getRegionToConflate();
        ConcurrentMap latestIndexesForRegion = (ConcurrentMap)this.indexes.get(r);
        if (latestIndexesForRegion == null) {
            HARegionQueue hARegionQueue = this;
            synchronized (hARegionQueue) {
                latestIndexesForRegion = (ConcurrentMap)this.indexes.get(r);
                if (latestIndexesForRegion == null) {
                    latestIndexesForRegion = this.createConcurrentMap();
                    HashMap<String, ConcurrentMap> newMap = new HashMap<String, ConcurrentMap>(this.indexes);
                    newMap.put(r, latestIndexesForRegion);
                    this.indexes = Collections.unmodifiableMap(newMap);
                }
            }
        }
        Object key = event.getKeyToConflate();
        Long previousPosition = latestIndexesForRegion.put(key, newPosition);
        return previousPosition;
    }

    ConcurrentMap createConcurrentMap() {
        return new ConcurrentHashMap();
    }

    CacheListener createCacheListenerForHARegion() {
        return new CacheListenerAdapter(){

            @Override
            public void afterInvalidate(EntryEvent event) {
                block3: {
                    try {
                        HARegionQueue.this.expireTheEventOrThreadIdentifier(event);
                    }
                    catch (CancelException cancelException) {
                    }
                    catch (CacheException ce) {
                        if (HARegionQueue.this.destroyInProgress) break block3;
                        logger.error((Message)LocalizedMessage.create(LocalizedStrings.HARegionQueue_HAREGIONQUEUECREATECACHELISTNEREXCEPTION_IN_THE_EXPIRY_THREAD), (Throwable)ce);
                    }
                }
            }
        };
    }

    void expireTheEventOrThreadIdentifier(EntryEvent event) throws CacheException {
        Object key;
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("HARegionQueue::afterInvalidate. Entry Event being invalidated:{}, isPrimaryQueue:{}", (Object)event, (Object)this.isPrimary());
        }
        if ((key = event.getKey()) instanceof ThreadIdentifier) {
            DispatchedAndCurrentEvents dace = (DispatchedAndCurrentEvents)this.eventsMap.get(key);
            Assert.assertTrue(dace != null);
            Long expirySequenceID = (Long)event.getOldValue();
            boolean expired = dace.expireOrUpdate(expirySequenceID, (ThreadIdentifier)key);
            if (isDebugEnabled) {
                logger.debug("HARegionQueue::afterInvalidate:Size of the region after expiring or updating the ThreadIdentifier={}", (Object)this.region.keys().size());
                logger.debug("HARegionQueue::afterInvalidate:ThreadIdentifier expired={}", (Object)expired);
            }
        } else if (key instanceof Long) {
            this.destroyFromQueue(key);
            Conflatable cf = (Conflatable)event.getOldValue();
            EventID id = cf.getEventId();
            byte[] memID = id.getMembershipID();
            long threadId = id.getThreadID();
            DispatchedAndCurrentEvents dace = (DispatchedAndCurrentEvents)this.eventsMap.get(new ThreadIdentifier(memID, threadId));
            if (this.shouldBeConflated(cf)) {
                dace.destroy((Long)key, cf.getKeyToConflate(), cf.getRegionToConflate());
            } else {
                dace.destroy((Long)key);
            }
        }
    }

    void publish(Long position) throws InterruptedException {
        this.acquireWriteLock();
        try {
            this.idsAvailable.add(position);
            this.notifyPeekAndTakeThreads();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    protected boolean removeFromOtherLists(Long position) {
        return false;
    }

    public boolean destroyFromAvailableIDs(Long position) throws InterruptedException {
        boolean removedOK = false;
        this.acquireWriteLock();
        try {
            removedOK = this.idsAvailable.remove(position);
            if (!removedOK) {
                removedOK = this.removeFromOtherLists(position);
            }
            if (removedOK) {
                this.incrementTakeSidePutPermits();
            }
        }
        finally {
            this.releaseWriteLock();
        }
        return removedOK;
    }

    protected boolean destroyFromAvailableIDsAndRegion(Long position) throws InterruptedException {
        boolean removedOK;
        block3: {
            removedOK = this.destroyFromAvailableIDs(position);
            if (removedOK) {
                try {
                    this.destroyFromQueue(position);
                }
                catch (EntryNotFoundException enfe) {
                    if (this.destroyInProgress || this.region.isDestroyed()) break block3;
                    Assert.assertTrue(false, "HARegionQueue::remove: The position " + position + "existed in availableIDs set but not in Region object is not expected");
                }
            }
        }
        return removedOK;
    }

    private void destroyFromQueue(Object key) {
        Object event = this.region.get(key);
        this.region.localDestroy(key);
        this.maintainCqStats(event, -1L);
    }

    public String toString() {
        return "RegionQueue on " + this.regionName + "(" + (this.isPrimary ? "primary" : "backup") + ")";
    }

    @Override
    public HARegion getRegion() {
        return this.region;
    }

    protected Long getAndRemoveNextAvailableID() throws InterruptedException {
        Long next = null;
        this.acquireWriteLock();
        try {
            if (this.idsAvailable.isEmpty()) {
                if (this.waitForData()) {
                    Iterator itr = this.idsAvailable.iterator();
                    next = (Long)itr.next();
                    itr.remove();
                    this.incrementTakeSidePutPermits();
                }
            } else {
                Iterator itr = this.idsAvailable.iterator();
                next = (Long)itr.next();
                itr.remove();
                this.incrementTakeSidePutPermits();
            }
        }
        finally {
            this.releaseWriteLock();
        }
        return next;
    }

    private Long getNextAvailableID() throws InterruptedException {
        Long next = null;
        this.acquireReadLock();
        try {
            if (this.idsAvailable.isEmpty()) {
                if (this.waitForData()) {
                    next = (Long)this.idsAvailable.iterator().next();
                }
            } else {
                next = (Long)this.idsAvailable.iterator().next();
            }
        }
        finally {
            this.releaseReadLock();
        }
        return next;
    }

    @Override
    public Object take() throws CacheException, InterruptedException {
        Conflatable object = null;
        Long next = null;
        next = this.getAndRemoveNextAvailableID();
        if (next != null) {
            object = (Conflatable)this.region.get(next);
            Assert.assertTrue(object != null);
            object = this.getAndRemoveFromHAContainer(object);
            Assert.assertTrue(object != null);
            EventID eventid = object.getEventId();
            long sequenceId = eventid.getSequenceID();
            ThreadIdentifier threadid = HARegionQueue.getThreadIdentifier(eventid);
            DispatchedAndCurrentEvents dace = (DispatchedAndCurrentEvents)this.eventsMap.get(threadid);
            Assert.assertTrue(dace != null);
            Object keyToConflate = null;
            if (this.shouldBeConflated(object)) {
                keyToConflate = object.getKeyToConflate();
            }
            dace.removeEventAndSetSequenceID(new RemovedEventInfo(next, object.getRegionToConflate(), keyToConflate), sequenceId);
            this.stats.incEventsTaken();
        }
        if (object == null && logger.isDebugEnabled()) {
            logger.debug("RegionQueue is EMPTY, returning null for take()");
        }
        return object;
    }

    @Override
    public List take(int batchSize) throws CacheException, InterruptedException {
        Object obj;
        ArrayList<Object> batch = new ArrayList<Object>(batchSize * 2);
        for (int i = 0; i < batchSize && (obj = this.take()) != null; ++i) {
            batch.add(obj);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("{}: Took a batch of {} entries", (Object)this, (Object)batch.size());
        }
        return batch;
    }

    protected boolean checkPrevAcks() {
        return true;
    }

    protected boolean checkEventForRemoval(Long counter, ThreadIdentifier threadid, long sequenceId) {
        return true;
    }

    protected void setPeekedEvents() {
        peekedEventsContext.set(null);
    }

    @Override
    public void remove() throws InterruptedException {
        List peekedIds = (List)peekedEventsContext.get();
        if (peekedIds == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Remove() called before peek(), nothing to remove.");
            }
            return;
        }
        if (!this.checkPrevAcks()) {
            return;
        }
        HashMap<ThreadIdentifier, ArrayList<RemovedEventInfo>> groupedThreadIDs = new HashMap<ThreadIdentifier, ArrayList<RemovedEventInfo>>();
        for (Long l : peekedIds) {
            Conflatable event = (Conflatable)this.region.get(l);
            if (event != null) {
                EventID eventid = event.getEventId();
                long sequenceId = eventid.getSequenceID();
                ThreadIdentifier threadid = HARegionQueue.getThreadIdentifier(eventid);
                if (!this.checkEventForRemoval(l, threadid, sequenceId)) continue;
                Object key = null;
                String r = null;
                if (this.shouldBeConflated(event)) {
                    key = event.getKeyToConflate();
                    r = event.getRegionToConflate();
                }
                RemovedEventInfo info = new RemovedEventInfo(l, r, key);
                ArrayList<RemovedEventInfo> countersList = (ArrayList<RemovedEventInfo>)groupedThreadIDs.get(threadid);
                if (countersList != null) {
                    countersList.add(info);
                    countersList.set(0, (RemovedEventInfo)((Object)Long.valueOf(sequenceId)));
                } else {
                    countersList = new ArrayList<RemovedEventInfo>();
                    countersList.add((RemovedEventInfo)((Object)Long.valueOf(sequenceId)));
                    countersList.add(info);
                    groupedThreadIDs.put(threadid, countersList);
                }
                event = null;
                info = null;
                continue;
            }
            this.stats.incNumVoidRemovals();
        }
        for (Map.Entry entry : groupedThreadIDs.entrySet()) {
            ThreadIdentifier tid = (ThreadIdentifier)entry.getKey();
            List removedEvents = (List)entry.getValue();
            long lastDispatchedId = (Long)removedEvents.remove(0);
            DispatchedAndCurrentEvents dace = (DispatchedAndCurrentEvents)this.eventsMap.get(tid);
            if (dace == null || dace.lastDispatchedSequenceId >= lastDispatchedId) continue;
            try {
                dace.setLastDispatchedIDAndRemoveEvents(removedEvents, lastDispatchedId);
            }
            catch (CacheException e) {
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.HARegionQueue_EXCEPTION_OCCURED_WHILE_TRYING_TO_SET_THE_LAST_DISPATCHED_ID), (Throwable)e);
            }
        }
        groupedThreadIDs = null;
        this.setPeekedEvents();
    }

    protected Object getNextAvailableIDFromList() throws InterruptedException {
        return this.getNextAvailableID();
    }

    protected void storePeekedID(Long id) {
    }

    @Override
    public Object peek() throws InterruptedException {
        Conflatable object;
        block7: {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            object = null;
            Long next = null;
            do {
                try {
                    next = (Long)this.getNextAvailableIDFromList();
                    if (next != null) continue;
                    break block7;
                }
                catch (TimeoutException te) {
                    throw new InterruptedException();
                }
            } while ((object = (Conflatable)this.region.get(next)) == null || (object = object instanceof HAEventWrapper ? (Conflatable)this.haContainer.get(object) : object) == null);
            LinkedList<Long> peekedEvents = (LinkedList<Long>)peekedEventsContext.get();
            if (peekedEvents != null) {
                peekedEvents.add(next);
            } else {
                peekedEvents = new LinkedList<Long>();
                peekedEvents.add(next);
                peekedEventsContext.set(peekedEvents);
            }
            this.storePeekedID(next);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("HARegionQueue::peek: Returning object from head = {}", (Object)object);
        }
        return object;
    }

    @Override
    public List peek(int batchSize) throws InterruptedException {
        return this.peek(batchSize, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List doReturn(int minSize, int maxSize) {
        this.acquireReadLock();
        try {
            int numToReturn = this.idsAvailable.size();
            if (numToReturn < minSize) {
                List list = null;
                return list;
            }
            if (numToReturn > maxSize) {
                numToReturn = maxSize;
            }
            List list = this.getBatchAndUpdateThreadContext(numToReturn);
            return list;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List peek(int batchSize, int timeToWait) throws InterruptedException {
        List result;
        long start = System.currentTimeMillis();
        long end = start + (long)timeToWait;
        if (logger.isTraceEnabled()) {
            logger.trace("{}: Peek start time={} end time={} time to wait={}", (Object)this, (Object)start, (Object)end, (Object)timeToWait);
        }
        if ((result = this.doReturn(batchSize, batchSize)) != null) {
            return result;
        }
        while (true) {
            this.region.getCache().getCancelCriterion().checkCancelInProgress(null);
            result = this.doReturn(batchSize, batchSize);
            if (result != null) {
                return result;
            }
            long currentTime = System.currentTimeMillis();
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Peek current time: {}", (Object)this, (Object)currentTime);
            }
            if (timeToWait == -1 || currentTime >= end) {
                if (logger.isTraceEnabled()) {
                    logger.trace("{}: Peek timed out", (Object)this);
                }
                Assert.assertTrue((result = this.doReturn(0, batchSize)) != null);
                return result;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Peek continuing", (Object)this);
            }
            boolean interrupted = Thread.interrupted();
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                interrupted = true;
                this.region.getCancelCriterion().checkCancelInProgress(null);
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private List getBatchAndUpdateThreadContext(int batchSize) {
        Iterator itr = this.idsAvailable.iterator();
        int currSize = this.idsAvailable.size();
        int limit = currSize >= batchSize ? batchSize : currSize;
        ArrayList<Object> batch = new ArrayList<Object>(limit);
        LinkedList<Long> peekedEventsThreadContext = (LinkedList<Long>)peekedEventsContext.get();
        if (peekedEventsThreadContext == null) {
            peekedEventsThreadContext = new LinkedList<Long>();
        }
        for (int i = 0; i < limit; ++i) {
            Object event;
            Long counter = (Long)itr.next();
            Object eventOrWrapper = this.region.get(counter);
            if (eventOrWrapper instanceof HAEventWrapper) {
                event = this.haContainer.get(eventOrWrapper);
                if (event == null) {
                    event = ((HAEventWrapper)eventOrWrapper).getClientUpdateMessage();
                }
            } else {
                event = eventOrWrapper;
            }
            if (event != null) {
                batch.add(event);
            }
            peekedEventsThreadContext.add(counter);
        }
        peekedEventsContext.set(peekedEventsThreadContext);
        return batch;
    }

    @Override
    public void addCacheListener(CacheListener listener) {
    }

    @Override
    public void removeCacheListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void addDispatchedMessage(ThreadIdentifier tid, long sequenceId) {
        Long lastSequenceNumber = sequenceId;
        boolean wasEmpty = false;
        Long oldvalue = null;
        Map internalMap = null;
        while (true) {
            Map map = internalMap = this.threadIdToSeqId.map;
            // MONITORENTER : map
            if (internalMap == this.threadIdToSeqId.map) break;
            // MONITOREXIT : map
        }
        wasEmpty = internalMap.isEmpty();
        oldvalue = internalMap.put(tid, lastSequenceNumber);
        if (this.ackedEvents != null) {
            this.ackedEvents.put(tid, lastSequenceNumber);
        }
        if (oldvalue != null && oldvalue.compareTo(lastSequenceNumber) > 0) {
            internalMap.put(tid, oldvalue);
            if (this.ackedEvents != null) {
                this.ackedEvents.put(tid, oldvalue);
            }
        }
        // MONITOREXIT : map
        if (!wasEmpty) return;
        ConcurrentMap tempDispatchedMessagesMap = dispatchedMessagesMap;
        if (tempDispatchedMessagesMap == null) return;
        MapWrapper old = tempDispatchedMessagesMap.putIfAbsent(this.regionName, this.threadIdToSeqId);
        if (isUsedByTest) {
            testMarkerMessageRecieved = true;
            if (logger.isDebugEnabled()) {
                logger.debug("testIsAckRecieved: {}", (Object)testMarkerMessageRecieved);
            }
        }
        Assert.assertTrue(old == null);
    }

    public void createAckedEventsMap() {
    }

    public void setAckedEvents() {
    }

    public static Map getDispatchedMessagesMapForTesting() {
        return Collections.unmodifiableMap(dispatchedMessagesMap);
    }

    Map getConflationMapForTesting() {
        return Collections.unmodifiableMap(this.indexes);
    }

    public HARegionQueueStats getStatistics() {
        return this.stats;
    }

    Map getEventsMapForTesting() {
        return Collections.unmodifiableMap(this.eventsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getCurrentCounterSet(EventID id) {
        Set<Object> counters = null;
        ThreadIdentifier tid = HARegionQueue.getThreadIdentifier(id);
        DispatchedAndCurrentEvents wrapper = (DispatchedAndCurrentEvents)this.eventsMap.get(tid);
        if (wrapper != null) {
            DispatchedAndCurrentEvents dispatchedAndCurrentEvents = wrapper;
            synchronized (dispatchedAndCurrentEvents) {
                counters = wrapper.isCountersEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(wrapper.counters.keySet());
            }
        }
        return counters;
    }

    long getLastDispatchedSequenceId(EventID id) {
        ThreadIdentifier tid = HARegionQueue.getThreadIdentifier(id);
        DispatchedAndCurrentEvents wrapper = (DispatchedAndCurrentEvents)this.eventsMap.get(tid);
        return wrapper.lastDispatchedSequenceId;
    }

    Set getAvalaibleIds() {
        this.acquireReadLock();
        try {
            Set set = Collections.unmodifiableSet(this.idsAvailable);
            return set;
        }
        finally {
            this.releaseReadLock();
        }
    }

    void removeDispatchedEvents(EventID lastDispatched) throws CacheException, InterruptedException {
        ThreadIdentifier ti = HARegionQueue.getThreadIdentifier(lastDispatched);
        long sequenceID = lastDispatched.getSequenceID();
        DispatchedAndCurrentEvents dace = (DispatchedAndCurrentEvents)this.eventsMap.get(ti);
        if (dace != null && dace.lastDispatchedSequenceId < sequenceID) {
            dace.setLastDispatchedIDAndRemoveEvents(sequenceID);
        } else if (dace == null) {
            dace = new DispatchedAndCurrentEvents(this);
            dace.lastDispatchedSequenceId = sequenceID;
            DispatchedAndCurrentEvents oldDace = this.eventsMap.putIfAbsent(ti, dace);
            if (oldDace != null) {
                dace = oldDace;
                if (dace.lastDispatchedSequenceId < sequenceID) {
                    dace.setLastDispatchedIDAndRemoveEvents(sequenceID);
                }
            } else {
                this.region.put(ti, (Object)dace.lastDispatchedSequenceId);
                this.stats.incThreadIdentifiers();
            }
        }
    }

    @Override
    public int size() {
        this.acquireReadLock();
        try {
            int n = this.idsAvailable.size();
            return n;
        }
        finally {
            this.releaseReadLock();
        }
    }

    void decrementTakeSidePutPermits() {
    }

    void incrementTakeSidePutPermits() {
    }

    void entryEnqueued(Conflatable event) {
        this.stats.incEventsEnqued();
        this.maintainCqStats(event, 1L);
    }

    private void maintainCqStats(Object event, long incrementAmount) {
        block5: {
            CqService cqService = this.region.getGemFireCache().getCqService();
            if (cqService != null) {
                try {
                    ClientUpdateMessageImpl.CqNameToOp cqNames;
                    HAEventWrapper hw;
                    if (event instanceof HAEventWrapper && (event = (hw = (HAEventWrapper)event).getClientUpdateMessage() != null ? hw.getClientUpdateMessage() : (Conflatable)this.haContainer.get(event)) instanceof ClientUpdateMessage && ((ClientUpdateMessage)event).hasCqs() && ((ClientUpdateMessage)event).hasCqs(this.clientProxyID) && (cqNames = ((ClientUpdateMessage)event).getClientCq(this.clientProxyID)) != null) {
                        for (String cqName : cqNames.getNames()) {
                            InternalCqQuery cq = (InternalCqQuery)cqService.getClientCqFromServer(this.clientProxyID, cqName);
                            CqQueryVsdStats cqStats = cq.getVsdStats();
                            if (cq == null || cqStats == null) continue;
                            cqStats.incNumHAQueuedEvents(incrementAmount);
                        }
                    }
                }
                catch (Exception e) {
                    if (!logger.isTraceEnabled()) break block5;
                    logger.trace("Exception while maintaining cq events stats.", (Throwable)e);
                }
            }
        }
    }

    boolean internalIsEmpty() {
        return this.idsAvailable.isEmpty();
    }

    public boolean isEmpty() {
        this.acquireReadLock();
        try {
            boolean bl = this.internalIsEmpty();
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    void acquireWriteLock() {
        this.writeLock.lock();
    }

    void acquireReadLock() {
        this.readLock.lock();
    }

    void releaseReadLock() {
        this.readLock.unlock();
    }

    void releaseWriteLock() {
        this.writeLock.unlock();
    }

    void notifyPeekAndTakeThreads() {
    }

    boolean waitForData() throws InterruptedException {
        return false;
    }

    protected static ThreadIdentifier getThreadIdentifier(EventID eventId) {
        return new ThreadIdentifier(eventId.getMembershipID(), eventId.getThreadID());
    }

    static void stopQRMThread() {
        qrmThread.shutdown();
    }

    static List createMessageListForTesting() {
        return qrmThread.createMessageList();
    }

    public static HARegionQueue getHARegionQueueInstance(String regionName, Cache cache, int haRgnQType, boolean isDurable) throws IOException, ClassNotFoundException, CacheException, InterruptedException {
        Map container = null;
        container = haRgnQType == 1 ? new HAContainerMap(new ConcurrentHashMap()) : new HashMap();
        return HARegionQueue.getHARegionQueueInstance(regionName, (GemFireCacheImpl)cache, HARegionQueueAttributes.DEFAULT_HARQ_ATTRIBUTES, haRgnQType, isDurable, container, null, (byte)0, false, Boolean.FALSE);
    }

    public static HARegionQueue getHARegionQueueInstance(String regionName, GemFireCacheImpl cache, HARegionQueueAttributes hrqa, int haRgnQType, boolean isDurable, Map haContainer, ClientProxyMembershipID clientProxyId, byte clientConflation, boolean isPrimary, boolean canHandleDelta) throws IOException, ClassNotFoundException, CacheException, InterruptedException {
        HARegionQueue hrq = null;
        switch (haRgnQType) {
            case 1: {
                if (!isDurable && !canHandleDelta) {
                    hrq = new BlockingHARegionQueue(regionName, cache, hrqa, haContainer, clientProxyId, clientConflation, isPrimary);
                    break;
                }
                hrq = new DurableHARegionQueue(regionName, cache, hrqa, haContainer, clientProxyId, clientConflation, isPrimary);
                break;
            }
            case 2: {
                hrq = new HARegionQueue(regionName, cache, hrqa, haContainer, clientProxyId, clientConflation, isPrimary);
                break;
            }
            default: {
                throw new IllegalArgumentException(LocalizedStrings.HARegionQueue_HARGNQTYPE_CAN_EITHER_BE_BLOCKING_0_OR_NON_BLOCKING_1.toLocalizedString(1, 2));
            }
        }
        if (!isDurable) {
            Integer expiryTime = Integer.getInteger(REGION_ENTRY_EXPIRY_TIME, hrqa.getExpiryTime());
            hrqa.setExpiryTime(expiryTime);
            ExpirationAttributes ea = new ExpirationAttributes(hrqa.getExpiryTime(), ExpirationAction.LOCAL_INVALIDATE);
            hrq.region.getAttributesMutator().setEntryTimeToLive(ea);
        }
        return hrq;
    }

    public static HARegionQueue getHARegionQueueInstance(String regionName, Cache cache, HARegionQueueAttributes hrqa, int haRgnQType, boolean isDurable) throws IOException, ClassNotFoundException, CacheException, InterruptedException {
        Map container = null;
        container = haRgnQType == 1 ? new HAContainerMap(new ConcurrentHashMap()) : new HashMap();
        return HARegionQueue.getHARegionQueueInstance(regionName, (GemFireCacheImpl)cache, hrqa, haRgnQType, isDurable, container, null, (byte)0, false, Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmptyAckList() {
        List list = this.threadIdToSeqId.list;
        synchronized (list) {
            return this.threadIdToSeqId.list.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeClientCq(ClientProxyMembershipID clientId, InternalCqQuery cqToClose) {
        this.acquireReadLock();
        try {
            Object[] availableIds = this.availableIDsArray();
            int currSize = availableIds.length;
            Object event = null;
            for (int i = 0; i < currSize; ++i) {
                Long counter = (Long)availableIds[i];
                event = this.region.get(counter);
                HAEventWrapper wrapper = null;
                if (event instanceof HAEventWrapper) {
                    wrapper = (HAEventWrapper)event;
                    event = this.haContainer.get(event);
                }
                if (event == null) {
                    Assert.assertTrue(this.destroyInProgress, "Got event null when queue was not being destroyed");
                }
                if (!(event instanceof ClientUpdateMessageImpl)) continue;
                ClientUpdateMessageImpl updateEvent = (ClientUpdateMessageImpl)event;
                updateEvent.removeClientCq(clientId, cqToClose);
                if (updateEvent.hasCqs(clientId) || updateEvent.isClientInterested(clientId) || wrapper == null) continue;
                try {
                    if (!this.destroyFromAvailableIDsAndRegion(counter)) continue;
                    this.stats.incEventsRemoved();
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void clearPeekedIDs() {
        peekedEventsContext.set(null);
    }

    @Override
    public void remove(int top) {
        throw new UnsupportedOperationException(LocalizedStrings.HARegionQueue_HAREGIONQUEUE_AND_ITS_DERIVED_CLASS_DO_NOT_SUPPORT_THIS_OPERATION.toLocalizedString());
    }

    public void destroy() throws CacheWriterException {
        this.destroyInProgress = true;
        ConcurrentMap tempDispatchedMessagesMap = dispatchedMessagesMap;
        if (tempDispatchedMessagesMap != null) {
            tempDispatchedMessagesMap.remove(this.regionName);
        }
        try {
            block10: {
                try {
                    this.updateHAContainer();
                }
                catch (RegionDestroyedException regionDestroyedException) {
                }
                catch (CancelException e) {
                    if (!logger.isDebugEnabled()) break block10;
                    logger.debug("HARegionQueue#destroy: ignored cancellation!!!!");
                }
            }
            try {
                this.region.destroyRegion();
            }
            catch (RegionDestroyedException regionDestroyedException) {
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
            ((HAContainerWrapper)this.haContainer).removeProxy(this.regionName);
        }
        finally {
            this.stats.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putEventInHARegion(Conflatable event, Long position) {
        if (event instanceof HAEventWrapper) {
            HAEventWrapper haEventWrapper = (HAEventWrapper)event;
            if (this.isQueueInitialized()) {
                if (haEventWrapper.getIsRefFromHAContainer()) {
                    this.putEntryConditionallyIntoHAContainer(haEventWrapper);
                } else {
                    HAEventWrapper original = null;
                    do {
                        HAEventWrapper hAEventWrapper;
                        ClientUpdateMessageImpl old;
                        if ((old = (ClientUpdateMessageImpl)((HAContainerWrapper)this.haContainer).putIfAbsent(haEventWrapper, haEventWrapper.getClientUpdateMessage())) != null) {
                            original = (HAEventWrapper)((HAContainerWrapper)this.haContainer).getKey(haEventWrapper);
                            if (original == null) continue;
                            hAEventWrapper = original;
                            synchronized (hAEventWrapper) {
                                if (((HAContainerWrapper)this.haContainer).getKey(original) != null) {
                                    original.incAndGetReferenceCount();
                                    HARegionQueue.addClientCQsAndInterestList(old, haEventWrapper, this.haContainer, this.regionName);
                                    haEventWrapper = original;
                                } else {
                                    original = null;
                                }
                            }
                        } else {
                            hAEventWrapper = haEventWrapper;
                            synchronized (hAEventWrapper) {
                                haEventWrapper.incAndGetReferenceCount();
                                haEventWrapper.setHAContainer(this.haContainer);
                                if (!haEventWrapper.getPutInProgress()) {
                                    haEventWrapper.setClientUpdateMessage(null);
                                }
                                haEventWrapper.setIsRefFromHAContainer(true);
                                break;
                            }
                        }
                    } while (original == null);
                }
            }
            this.region.put(position, haEventWrapper);
        } else {
            this.region.put(position, event);
        }
    }

    public static void addClientCQsAndInterestList(ClientUpdateMessageImpl msg, HAEventWrapper haEventWrapper, Map haContainer, String regionName) {
        ClientUpdateMessageImpl clientMsg;
        ClientUpdateMessageImpl.CqNameToOp clientCQ;
        ClientProxyMembershipID proxyID = ((HAContainerWrapper)haContainer).getProxyID(regionName);
        if (haEventWrapper.getClientCqs() != null && (clientCQ = (ClientUpdateMessageImpl.CqNameToOp)haEventWrapper.getClientCqs().get(proxyID)) != null) {
            msg.addClientCqs(proxyID, clientCQ);
        }
        if ((clientMsg = (ClientUpdateMessageImpl)haEventWrapper.getClientUpdateMessage()).isClientInterestedInUpdates(proxyID)) {
            msg.addClientInterestList(proxyID, true);
        } else if (clientMsg.isClientInterestedInInvalidates(proxyID)) {
            msg.addClientInterestList(proxyID, false);
        }
    }

    protected void putEntryConditionallyIntoHAContainer(HAEventWrapper haEventWrapper) {
        if (haEventWrapper.incAndGetReferenceCount() == 1L) {
            haEventWrapper.setHAContainer(this.haContainer);
            this.haContainer.put(haEventWrapper, haEventWrapper.getClientUpdateMessage());
        }
    }

    protected int availableIDsSize() {
        return this.idsAvailable.size();
    }

    protected Object[] availableIDsArray() {
        return this.idsAvailable.toArray();
    }

    public boolean noPrimaryOrHasRegisteredInterest() {
        return this.region.noPrimaryOrHasRegisteredInterest();
    }

    public void setHasRegisteredInterest(boolean flag) {
        boolean old = this.hasRegisteredInterest;
        this.hasRegisteredInterest = flag;
        if (old != flag) {
            this.region.sendProfileUpdate();
        }
    }

    public boolean getHasRegisteredInterest() {
        return this.hasRegisteredInterest;
    }

    private void updateHAContainer() {
        try {
            Object[] wrapperArray = null;
            this.acquireReadLock();
            try {
                if (this.availableIDsSize() != 0) {
                    wrapperArray = this.availableIDsArray();
                }
            }
            finally {
                this.releaseReadLock();
            }
            if (wrapperArray != null) {
                final HashSet<Object> wrapperSet = new HashSet<Object>();
                for (int i = 0; i < wrapperArray.length; ++i) {
                    wrapperSet.add(this.region.get(wrapperArray[i]));
                }
                Thread regionCleanupTask = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        block4: {
                            try {
                                for (Conflatable conflatable : wrapperSet) {
                                    if (!(conflatable instanceof HAEventWrapper)) continue;
                                    HARegionQueue.this.decAndRemoveFromHAContainer((HAEventWrapper)conflatable);
                                }
                            }
                            catch (CancelException e) {
                                return;
                            }
                            catch (Exception e) {
                                if (!logger.isDebugEnabled()) break block4;
                                logger.debug("Exception in regionCleanupTask thread of HARegionQueue.updateHAContainer$run()", (Throwable)e);
                            }
                        }
                    }
                });
                regionCleanupTask.start();
            }
        }
        catch (CancelException e) {
            throw e;
        }
        catch (RegionDestroyedException e) {
            this.getRegion().getCache().getCancelCriterion().checkCancelInProgress(e);
            logger.warn("HARegionQueue.updateHAContainer: underlying region has been destroyed", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.HARegionQueue_TASK_TO_DECREMENT_THE_REF_COUNT_MAY_NOT_HAVE_BEEN_STARTED), (Throwable)e);
        }
    }

    public Conflatable getAndRemoveFromHAContainer(Conflatable conflatable) {
        Conflatable msg = null;
        if (conflatable instanceof HAEventWrapper) {
            HAEventWrapper wrapper = (HAEventWrapper)conflatable;
            msg = (Conflatable)this.haContainer.get(wrapper);
            if (msg != null) {
                this.decAndRemoveFromHAContainer(wrapper);
            }
        } else {
            msg = conflatable;
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decAndRemoveFromHAContainer(HAEventWrapper wrapper) {
        if (wrapper.decAndGetReferenceCount() == 0L && !wrapper.getPutInProgress()) {
            HAEventWrapper hAEventWrapper = wrapper;
            synchronized (hAEventWrapper) {
                if (wrapper.getReferenceCount() == 0L) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Removing event from {}: {}", (Object)this.region.getFullPath(), (Object)wrapper.getEventId());
                    }
                    this.haContainer.remove(wrapper);
                }
            }
        }
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public boolean isQueueInitialized() {
        return this.initialized.get();
    }

    public void setPrimary(boolean flag) {
        boolean old = this.isPrimary;
        this.isPrimary = flag;
        if (flag) {
            this.disableEntryExpiryTasks();
        }
        if (old != this.isPrimary) {
            this.region.sendProfileUpdate();
        }
    }

    private void disableEntryExpiryTasks() {
        int oldTimeToLive = this.region.getEntryTimeToLive().getTimeout();
        if (oldTimeToLive > 0) {
            ExpirationAttributes ea = new ExpirationAttributes(0, ExpirationAction.LOCAL_INVALIDATE);
            this.region.setEntryTimeToLive(ea);
            this.region.setCustomEntryTimeToLive((CustomExpiry)new ThreadIdentifierCustomExpiry());
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.HARegionQueue_ENYTRY_EXPIRY_TASKS_DISABLED_BECAUSE_QUEUE_BECAME_PRIMARY_OLD_MSG_TTL_0, new Object[]{oldTimeToLive}));
        }
    }

    public void setClientConflation(byte value) {
        if (value != 2 && value != 1 && value != 0) {
            throw new IllegalArgumentException("illegal conflation value");
        }
        this.clientConflation = value;
    }

    public void initializeTransients() {
    }

    public static boolean isTestMarkerMessageRecieved() {
        return testMarkerMessageRecieved;
    }

    public static void setUsedByTest(boolean isUsedByTest) {
        HARegionQueue.isUsedByTest = isUsedByTest;
        if (!isUsedByTest) {
            testMarkerMessageRecieved = isUsedByTest;
        }
    }

    public boolean isClientSlowReciever() {
        return this.isClientSlowReciever;
    }

    @Override
    public void close() {
        HARegion r = this.getRegion();
        if (r != null && !r.isDestroyed()) {
            try {
                r.close();
            }
            catch (RegionDestroyedException regionDestroyedException) {
                // empty catch block
            }
        }
    }

    public boolean isPeekInitialized() {
        return peekedEventsContext.get() != null;
    }

    static {
        peekedEventsContext = new ThreadLocal();
        messageSyncInterval = 1;
        testMarkerMessageRecieved = false;
        isUsedByTest = false;
        threadIdExpiryTime = 300;
    }

    public static class DispatchedAndCurrentEvents
    implements DataSerializableFixedID,
    Serializable {
        protected volatile transient long lastDispatchedSequenceId = -1L;
        private static final int TOKEN_DESTROYED = -2;
        protected transient LinkedHashMap<Long, Object> counters;
        private volatile transient Object QRM_LOCK = new Object();
        transient HARegionQueue owningQueue;
        transient boolean isGIIDace;
        protected volatile long lastSequenceIDPut = -1L;

        public DispatchedAndCurrentEvents(HARegionQueue owner) {
            this.owningQueue = owner;
        }

        public DispatchedAndCurrentEvents() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean putObject(Conflatable event, long sequenceID) throws CacheException, InterruptedException {
            ThreadIdentifier oldTi;
            DispatchedAndCurrentEvents oldDace;
            Conflatable old;
            Long oldPosition = null;
            boolean isDebugEnabled_BS = logger.isTraceEnabled(LogMarker.BRIDGE_SERVER);
            if (isDebugEnabled_BS && this.lastSequenceIDPut >= sequenceID && !this.owningQueue.puttingGIIDataInQueue) {
                logger.trace(LogMarker.BRIDGE_SERVER, "HARegionQueue::DACE:putObject: Given sequence ID is already present ({}).\nThis may be a recovered operation via P2P or a GetInitialImage.\nlastSequenceIDPut = {} ; event = {};\n", (Object)sequenceID, (Object)this.lastSequenceIDPut, (Object)event);
            }
            boolean rejected = false;
            DispatchedAndCurrentEvents dispatchedAndCurrentEvents = this;
            synchronized (dispatchedAndCurrentEvents) {
                if (sequenceID > this.lastSequenceIDPut) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("HARegionQueue.putObject: adding {}", (Object)event);
                    }
                    this.lastSequenceIDPut = sequenceID;
                } else if (!this.owningQueue.puttingGIIDataInQueue) {
                    if (isDebugEnabled_BS) {
                        logger.trace(LogMarker.BRIDGE_SERVER, "{} eliding event with ID {}, because it is not greater than the last sequence ID ({}). The rejected event has key <{}> and value <{}>", (Object)this, (Object)event.getEventId(), (Object)this.lastSequenceIDPut, event.getKeyToConflate(), event.getValueToConflate());
                    }
                    this.owningQueue.stats.incNumSequenceViolated();
                    this.owningQueue.incrementTakeSidePutPermits();
                    CacheClientNotifier ccn = CacheClientNotifier.getInstance();
                    if (ccn != null) {
                        ccn.getClientProxy(this.owningQueue.clientProxyID).getStatistics().incMessagesFailedQueued();
                    }
                    return true;
                }
                if (this.lastDispatchedSequenceId == -2L) {
                    return false;
                }
                if (sequenceID > this.lastDispatchedSequenceId || this.owningQueue.puttingGIIDataInQueue) {
                    Long position = this.owningQueue.tailKey.incrementAndGet();
                    this.owningQueue.putEventInHARegion(event, position);
                    if (this.counters == null) {
                        this.counters = new LinkedHashMap();
                    }
                    this.counters.put(position, null);
                    if (this.owningQueue.shouldBeConflated(event)) {
                        oldPosition = this.owningQueue.addToConflationMap(event, position);
                    }
                    this.owningQueue.publish(position);
                } else {
                    rejected = true;
                }
            }
            if (rejected) {
                this.owningQueue.incrementTakeSidePutPermits();
                CacheClientNotifier ccn = CacheClientNotifier.getInstance();
                if (ccn != null) {
                    ccn.getClientProxy(this.owningQueue.clientProxyID).getStatistics().incMessagesFailedQueued();
                }
            } else {
                this.owningQueue.entryEnqueued(event);
            }
            if (oldPosition != null && (old = (Conflatable)this.owningQueue.region.get(oldPosition)) != null && (oldDace = (DispatchedAndCurrentEvents)this.owningQueue.eventsMap.get(oldTi = HARegionQueue.getThreadIdentifier(old.getEventId()))) != null) {
                oldDace.removeOldConflatedEntry(oldPosition);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeOldConflatedEntry(Long oldPosition) throws CacheException, InterruptedException {
            DispatchedAndCurrentEvents dispatchedAndCurrentEvents = this;
            synchronized (dispatchedAndCurrentEvents) {
                Conflatable conflatable = (Conflatable)this.owningQueue.region.get(oldPosition);
                if (this.owningQueue.destroyFromAvailableIDsAndRegion(oldPosition)) {
                    if (this.counters != null) {
                        this.counters.remove(oldPosition);
                    }
                    if (conflatable instanceof HAEventWrapper) {
                        this.owningQueue.decAndRemoveFromHAContainer((HAEventWrapper)conflatable);
                    }
                    if (!(conflatable instanceof ClientMarkerMessageImpl)) {
                        this.owningQueue.stats.incEventsConflated();
                    } else {
                        this.owningQueue.stats.incMarkerEventsConflated();
                    }
                }
            }
        }

        protected void destroy(Long position, Object key, String rName) {
            this.destroy(position);
            ConcurrentMap conflationMap = (ConcurrentMap)this.owningQueue.indexes.get(rName);
            Assert.assertTrue(conflationMap != null);
            conflationMap.remove(key, position);
        }

        protected synchronized void destroy(Long position) {
            if (this.counters != null) {
                this.counters.remove(position);
            }
        }

        private synchronized boolean isCountersEmpty() {
            return this.counters == null || this.counters.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean expireOrUpdate(long expVal, ThreadIdentifier ti) {
            boolean expired;
            block13: {
                expired = false;
                DispatchedAndCurrentEvents dispatchedAndCurrentEvents = this;
                synchronized (dispatchedAndCurrentEvents) {
                    block12: {
                        if (expVal == this.lastDispatchedSequenceId && this.isCountersEmpty()) {
                            try {
                                this.owningQueue.destroyFromQueue(ti);
                                this.lastDispatchedSequenceId = -2L;
                                this.owningQueue.eventsMap.remove(ti);
                                expired = true;
                                this.owningQueue.getStatistics().decThreadIdentifiers();
                            }
                            catch (RegionDestroyedException ignore) {
                                if (!this.owningQueue.destroyInProgress && logger.isDebugEnabled()) {
                                    logger.debug("DispatchedAndCurrentEvents::expireOrUpdate: Queue found destroyed while removing expiry entry for ThreadIdentifier={} and expiry value={}", (Object)ti, (Object)expVal, (Object)ignore);
                                }
                            }
                            catch (EntryNotFoundException enfe) {
                                if (this.owningQueue.destroyInProgress) break block12;
                                logger.error((Message)LocalizedMessage.create(LocalizedStrings.HARegionQueue_DISPATCHEDANDCURRENTEVENTSEXPIREORUPDATE_UNEXPECTEDLY_ENCOUNTERED_EXCEPTION_WHILE_REMOVING_EXPIRY_ENTRY_FOR_THREADIDENTIFIER_0_AND_EXPIRY_VALUE_1, new Object[]{ti, expVal, enfe}));
                            }
                        }
                    }
                }
                if (!expired) {
                    try {
                        this.owningQueue.region.put(ti, (Object)this.lastDispatchedSequenceId);
                    }
                    catch (CancelException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        if (this.owningQueue.destroyInProgress) break block13;
                        logger.error((Message)LocalizedMessage.create(LocalizedStrings.HARegionQueue_DISPATCHEDANDCURRENTEVENTSEXPIREORUPDATE_UNEXPECTEDLY_ENCOUNTERED_EXCEPTION_WHILE_UPDATING_EXPIRY_ID_FOR_THREADIDENTIFIER_0, ti), (Throwable)e);
                    }
                }
            }
            return expired;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setLastDispatchedIDAndRemoveEvents(long lastDispatchedSeqId) throws CacheException, InterruptedException {
            Long[] countersCopy = null;
            Object object = this.QRM_LOCK;
            synchronized (object) {
                DispatchedAndCurrentEvents dispatchedAndCurrentEvents = this;
                synchronized (dispatchedAndCurrentEvents) {
                    if (this.lastDispatchedSequenceId > lastDispatchedSeqId) {
                        return;
                    }
                    this.lastDispatchedSequenceId = lastDispatchedSeqId;
                    if (this.counters != null) {
                        countersCopy = new Long[this.counters.size()];
                        countersCopy = this.counters.keySet().toArray(countersCopy);
                    }
                }
                if (countersCopy != null) {
                    for (int i = 0; i < countersCopy.length; ++i) {
                        Long counter = countersCopy[i];
                        Conflatable event = (Conflatable)this.owningQueue.region.get(counter);
                        if (event == null) continue;
                        long seqId = event.getEventId().getSequenceID();
                        if (seqId > this.lastDispatchedSequenceId) break;
                        if (!this.owningQueue.destroyFromAvailableIDsAndRegion(counter)) continue;
                        if (event instanceof HAEventWrapper) {
                            if (((HAEventWrapper)event).getReferenceCount() == 0L && logger.isDebugEnabled()) {
                                logger.debug("Reference count is already zero for event {}", (Object)event.getEventId());
                            }
                            this.owningQueue.decAndRemoveFromHAContainer((HAEventWrapper)event);
                        }
                        this.owningQueue.stats.incEventsRemovedByQrm();
                        if (!this.owningQueue.shouldBeConflated(event)) {
                            this.destroy(counter);
                            continue;
                        }
                        Object key = event.getKeyToConflate();
                        String r = event.getRegionToConflate();
                        this.destroy(counter, key, r);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setLastDispatchedIDAndRemoveEvents(List removedEventInfoList, long lastDispatchedSeqId) throws CacheException, InterruptedException {
            DispatchedAndCurrentEvents dispatchedAndCurrentEvents = this;
            synchronized (dispatchedAndCurrentEvents) {
                if (this.lastDispatchedSequenceId > lastDispatchedSeqId) {
                    return;
                }
                this.lastDispatchedSequenceId = lastDispatchedSeqId;
            }
            for (RemovedEventInfo info : removedEventInfoList) {
                Long counter = info.counter;
                Object key = info.key;
                String r = info.regionName;
                Conflatable wrapper = (Conflatable)this.owningQueue.region.get(counter);
                if (this.owningQueue.destroyFromAvailableIDsAndRegion(counter)) {
                    if (key != null) {
                        this.destroy(counter, key, r);
                    } else {
                        this.destroy(counter);
                    }
                    if (wrapper instanceof HAEventWrapper) {
                        this.owningQueue.decAndRemoveFromHAContainer((HAEventWrapper)wrapper);
                    }
                    this.owningQueue.stats.incEventsRemoved();
                    continue;
                }
                this.owningQueue.stats.incNumVoidRemovals();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeEventAndSetSequenceID(RemovedEventInfo info, long sequenceID) {
            String r;
            Object key;
            Long counter;
            block8: {
                DispatchedAndCurrentEvents dispatchedAndCurrentEvents = this;
                synchronized (dispatchedAndCurrentEvents) {
                    if (this.lastDispatchedSequenceId < sequenceID) {
                        this.lastDispatchedSequenceId = sequenceID;
                    }
                }
                counter = info.counter;
                key = info.key;
                r = info.regionName;
                try {
                    this.owningQueue.destroyFromQueue(counter);
                }
                catch (EntryNotFoundException enfe) {
                    if (this.owningQueue.destroyInProgress) break block8;
                    logger.error((Message)LocalizedMessage.create(LocalizedStrings.HARegionQueue_DACEREMOVEEVENTANDSETSEQUENCEID_SINCE_THE_EVENT_WAS_SUCCESSULY_REMOVED_BY_TAKE_OPERATION_IT_SHOULD_HAVE_EXISTED_IN_THE_REGION), (Throwable)enfe);
                }
            }
            if (key == null) {
                this.destroy(counter);
            } else {
                this.destroy(counter, key, r);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            DispatchedAndCurrentEvents dispatchedAndCurrentEvents = this;
            synchronized (dispatchedAndCurrentEvents) {
                this.lastDispatchedSequenceId = in.readLong();
                this.lastSequenceIDPut = in.readLong();
            }
        }

        @Override
        public int getDSFID() {
            return -129;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void toData(DataOutput out) throws IOException {
            DispatchedAndCurrentEvents dispatchedAndCurrentEvents = this;
            synchronized (dispatchedAndCurrentEvents) {
                out.writeLong(this.lastDispatchedSequenceId);
                out.writeLong(this.lastSequenceIDPut);
            }
        }

        public String toString() {
            return "DACE(put=" + this.lastSequenceIDPut + "sent=" + this.lastDispatchedSequenceId + ")";
        }

        @Override
        public Version[] getSerializationVersions() {
            return null;
        }
    }

    private static class QueueRemovalThread
    extends Thread {
        private volatile boolean shutdown = false;
        private final GemFireCacheImpl cache;

        public QueueRemovalThread(GemFireCacheImpl c) {
            this.setDaemon(true);
            this.cache = c;
        }

        private boolean checkCancelled() {
            if (this.shutdown) {
                return true;
            }
            return this.cache.getCancelCriterion().isCancelInProgress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block28: {
                InternalDistributedSystem ids = this.cache.getDistributedSystem();
                DM dm = ids.getDistributionManager();
                try {
                    while (true) {
                        try {
                            while (true) {
                                List queueRemovalMessageList;
                                if (this.checkCancelled()) {
                                    break block28;
                                }
                                boolean interrupted = Thread.interrupted();
                                try {
                                    QueueRemovalThread queueRemovalThread = this;
                                    synchronized (queueRemovalThread) {
                                        this.wait(messageSyncInterval * 1000);
                                    }
                                }
                                catch (InterruptedException e) {
                                    interrupted = true;
                                    if (!this.checkCancelled()) {
                                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.HARegionQueue_INTERRUPTEDEXCEPTION_OCCURED_IN_QUEUEREMOVALTHREAD_WHILE_WAITING), (Throwable)e);
                                    }
                                    break block28;
                                }
                                finally {
                                    if (interrupted) {
                                        Thread.currentThread().interrupt();
                                    }
                                }
                                if (logger.isTraceEnabled()) {
                                    logger.trace("QueueRemovalThread about to query the message list");
                                }
                                if ((queueRemovalMessageList = this.createMessageList()) == null || queueRemovalMessageList.isEmpty()) continue;
                                QueueRemovalMessage qrm = new QueueRemovalMessage();
                                qrm.resetRecipients();
                                List servers = this.cache.getCacheServers();
                                LinkedList recipients = new LinkedList();
                                for (CacheServerImpl server : servers) {
                                    recipients.addAll(server.getCacheServerAdvisor().adviseBridgeServers());
                                }
                                qrm.setRecipients(recipients);
                                qrm.setMessagesList(queueRemovalMessageList);
                                dm.putOutgoing(qrm);
                            }
                        }
                        catch (CancelException e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("QueueRemovalThread is exiting due to cancellation");
                            }
                        }
                        catch (VirtualMachineError err) {
                            SystemFailure.initiateFailure(err);
                            throw err;
                        }
                        catch (Throwable t) {
                            SystemFailure.checkFailure();
                            if (this.checkCancelled()) {
                                break;
                            }
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("QueueRemovalThread: ignoring exception", t);
                            continue;
                        }
                        break;
                    }
                }
                catch (CancelException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("QueueRemovalThread exiting due to cancellation: ", (Throwable)e);
                    }
                }
                finally {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.HARegionQueue_THE_QUEUEREMOVALTHREAD_IS_DONE));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List createMessageList() {
            Map.Entry entry = null;
            Map.Entry internalEntry2 = null;
            MapWrapper threadIdToSequenceIdMap = null;
            String regionName = null;
            ThreadIdentifier tid = null;
            Long sequenceId = null;
            EventID eventId = null;
            LinkedList<Object> queueRemovalMessageList = new LinkedList<Object>();
            Iterator internalIterator = null;
            Iterator iterator = dispatchedMessagesMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map internalMap;
                entry = iterator.next();
                regionName = (String)entry.getKey();
                queueRemovalMessageList.add(regionName);
                threadIdToSequenceIdMap = (MapWrapper)entry.getValue();
                Map map = internalMap = threadIdToSequenceIdMap.map;
                synchronized (map) {
                    iterator.remove();
                    threadIdToSequenceIdMap.map = new HashMap();
                }
                queueRemovalMessageList.add(internalMap.size());
                for (Map.Entry internalEntry2 : internalMap.entrySet()) {
                    tid = (ThreadIdentifier)internalEntry2.getKey();
                    sequenceId = (Long)internalEntry2.getValue();
                    eventId = new EventID(tid.getMembershipID(), tid.getThreadID(), sequenceId);
                    queueRemovalMessageList.add(eventId);
                }
            }
            return queueRemovalMessageList;
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
            boolean interrupted = Thread.interrupted();
            try {
                this.join(15000L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.isAlive()) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.HARegionQueue_QUEUEREMOVALTHREAD_IGNORED_CANCELLATION));
            }
        }
    }

    static class TestOnlyHARegionQueue
    extends HARegionQueue {
        TestOnlyHARegionQueue(String regionName, Cache cache, Map haContainer) throws IOException, ClassNotFoundException, CacheException, InterruptedException {
            this(regionName, (GemFireCacheImpl)cache, HARegionQueueAttributes.DEFAULT_HARQ_ATTRIBUTES, haContainer, 0, false);
            this.initialized.set(true);
        }

        TestOnlyHARegionQueue(String regionName, Cache cache) throws IOException, ClassNotFoundException, CacheException, InterruptedException {
            this(regionName, (GemFireCacheImpl)cache, HARegionQueueAttributes.DEFAULT_HARQ_ATTRIBUTES, new HashMap(), 0, false);
        }

        TestOnlyHARegionQueue(String regionName, GemFireCacheImpl cache, HARegionQueueAttributes hrqa, Map haContainer, byte clientConflation, boolean isPrimary) throws IOException, ClassNotFoundException, CacheException, InterruptedException {
            super(regionName, cache, hrqa, haContainer, null, clientConflation, isPrimary);
            ExpirationAttributes ea = new ExpirationAttributes(hrqa.getExpiryTime(), ExpirationAction.LOCAL_INVALIDATE);
            this.region.setOwner(this);
            this.region.getAttributesMutator().setEntryTimeToLive(ea);
            this.initialized.set(true);
        }

        TestOnlyHARegionQueue(String regionName, Cache cache, HARegionQueueAttributes hrqa) throws IOException, ClassNotFoundException, CacheException, InterruptedException {
            this(regionName, (GemFireCacheImpl)cache, hrqa, new HashMap(), 0, false);
        }
    }

    private static class DurableHARegionQueue
    extends BlockingHARegionQueue {
        private LinkedHashSet durableIDsList = null;
        LinkedList unremovedElements = null;
        HashMap currDurableMap = null;

        protected DurableHARegionQueue(String regionName, GemFireCacheImpl cache, HARegionQueueAttributes hrqa, Map haContainer, ClientProxyMembershipID clientProxyId, byte clientConflation, boolean isPrimary) throws IOException, ClassNotFoundException, CacheException, InterruptedException {
            super(regionName, cache, hrqa, haContainer, clientProxyId, clientConflation, isPrimary);
            this.threadIdToSeqId.keepPrevAcks = true;
            this.durableIDsList = new LinkedHashSet();
            this.ackedEvents = new HashMap();
            this.initialized.set(true);
        }

        @Override
        protected Object getNextAvailableIDFromList() throws InterruptedException {
            return this.getAndRemoveNextAvailableID();
        }

        @Override
        protected Long getAndRemoveNextAvailableID() throws InterruptedException {
            Long next = null;
            this.acquireWriteLock();
            try {
                if (this.idsAvailable.isEmpty()) {
                    if (this.waitForData()) {
                        Iterator itr = this.idsAvailable.iterator();
                        next = (Long)itr.next();
                        itr.remove();
                    }
                } else {
                    Iterator itr = this.idsAvailable.iterator();
                    next = (Long)itr.next();
                    itr.remove();
                }
            }
            finally {
                this.releaseWriteLock();
            }
            return next;
        }

        @Override
        protected void storePeekedID(Long id) {
            this.acquireWriteLock();
            try {
                this.durableIDsList.add(id);
            }
            finally {
                this.releaseWriteLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean checkPrevAcks() {
            this.unremovedElements = new LinkedList();
            this.currDurableMap = new HashMap();
            List list = this.threadIdToSeqId.list;
            synchronized (list) {
                while (!this.threadIdToSeqId.list.isEmpty()) {
                    this.currDurableMap.putAll((Map)this.threadIdToSeqId.list.remove(0));
                }
            }
            return !this.currDurableMap.isEmpty();
        }

        @Override
        protected boolean checkEventForRemoval(Long counter, ThreadIdentifier threadid, long sequenceId) {
            if (this.currDurableMap.isEmpty()) {
                this.unremovedElements.add(counter);
                return false;
            }
            Long seqId = (Long)this.currDurableMap.get(threadid);
            if (seqId != null) {
                if (Long.valueOf(sequenceId).compareTo(seqId) > 0) {
                    this.unremovedElements.add(counter);
                    return false;
                }
            } else {
                this.unremovedElements.add(counter);
                return false;
            }
            return true;
        }

        @Override
        protected void setPeekedEvents() {
            peekedEventsContext.set(this.unremovedElements.isEmpty() ? null : this.unremovedElements);
            this.unremovedElements = null;
            this.currDurableMap = null;
        }

        @Override
        protected boolean removeFromOtherLists(Long position) {
            return this.durableIDsList.remove(position);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void initializeTransients() {
            if (!this.durableIDsList.isEmpty()) {
                this.acquireWriteLock();
                try {
                    long start = System.currentTimeMillis();
                    this.durableIDsList.addAll(this.idsAvailable);
                    this.idsAvailable = this.durableIDsList;
                    this.durableIDsList = new LinkedHashSet();
                    long end = System.currentTimeMillis();
                    if (end - start > 3000L) {
                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.HARegionQueue_DURABLE_CLIENT_QUEUE_INITIALIZATION_TOOK_0_MS, Long.toString(end - start)));
                    }
                }
                finally {
                    this.releaseWriteLock();
                }
            }
            peekedEventsContext.set(null);
            this.threadIdToSeqId.list.clear();
        }

        @Override
        protected int availableIDsSize() {
            return this.idsAvailable.size() + this.durableIDsList.size();
        }

        @Override
        protected Object[] availableIDsArray() {
            LinkedList retVal = new LinkedList();
            retVal.addAll(this.durableIDsList);
            retVal.addAll(this.idsAvailable);
            return retVal.toArray();
        }

        @Override
        public int size() {
            this.acquireReadLock();
            try {
                int n = this.idsAvailable.size() + this.durableIDsList.size();
                return n;
            }
            finally {
                this.releaseReadLock();
            }
        }

        @Override
        public void createAckedEventsMap() {
            this.ackedEvents = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAckedEvents() {
            if (this.threadIdToSeqId.keepPrevAcks) {
                List list = this.threadIdToSeqId.list;
                synchronized (list) {
                    this.threadIdToSeqId.list.add(this.ackedEvents);
                }
            }
        }
    }

    private static class BlockingHARegionQueue
    extends HARegionQueue {
        private final Object putGuard = new Object();
        private final int capacity;
        private int putPermits;
        private int takeSidePutPermits = 0;
        private final Object permitMon = new Object();
        private final StoppableReentrantLock lock;
        private final StoppableCondition blockCond;

        protected BlockingHARegionQueue(String regionName, GemFireCacheImpl cache, HARegionQueueAttributes hrqa, Map haContainer, ClientProxyMembershipID clientProxyId, byte clientConflation, boolean isPrimary) throws IOException, ClassNotFoundException, CacheException, InterruptedException {
            super(regionName, cache, hrqa, haContainer, clientProxyId, clientConflation, isPrimary);
            this.putPermits = this.capacity = hrqa.getBlockingQueueCapacity();
            this.lock = new StoppableReentrantLock(this.region.getCancelCriterion());
            this.blockCond = this.lock.newCondition();
            super.putGIIDataInRegion();
            if (this.getClass() == BlockingHARegionQueue.class) {
                this.initialized.set(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy() throws CacheWriterException {
            try {
                super.destroy();
            }
            finally {
                Object object = this.permitMon;
                synchronized (object) {
                    this.permitMon.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressWarnings(value={"TLW_TWO_LOCK_WAIT"})
        void checkQueueSizeConstraint() throws InterruptedException {
            if (this.haContainer instanceof HAContainerMap && this.isPrimary()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                Object object = this.putGuard;
                synchronized (object) {
                    if (this.putPermits <= 0) {
                        Object object2 = this.permitMon;
                        synchronized (object2) {
                            if (this.reconcilePutPermits() <= 0) {
                                if (this.region.getSystem().getConfig().getRemoveUnresponsiveClient()) {
                                    this.isClientSlowReciever = true;
                                } else {
                                    try {
                                        long logFrequency = 1000L;
                                        CacheClientNotifier ccn = CacheClientNotifier.getInstance();
                                        if (ccn != null) {
                                            logFrequency = ccn.getLogFrequency();
                                        }
                                        if (this.maxQueueSizeHitCount % logFrequency == 0L) {
                                            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.HARegionQueue_CLIENT_QUEUE_FOR_0_IS_FULL, new Object[]{this.region.getName()}));
                                            this.maxQueueSizeHitCount = 0L;
                                        }
                                        ++this.maxQueueSizeHitCount;
                                        this.region.checkReadiness();
                                        this.permitMon.wait(CacheClientNotifier.eventEnqueueWaitTime);
                                        this.region.checkReadiness();
                                        this.reconcilePutPermits();
                                        if (this.maxQueueSizeHitCount % logFrequency == 1L) {
                                            logger.info((Message)LocalizedMessage.create(LocalizedStrings.HARegionQueue_RESUMING_WITH_PROCESSING_PUTS));
                                        }
                                    }
                                    catch (InterruptedException ex) {
                                        this.permitMon.notify();
                                        throw ex;
                                    }
                                }
                            }
                        }
                    }
                    --this.putPermits;
                }
            }
        }

        private int reconcilePutPermits() {
            this.putPermits += this.takeSidePutPermits;
            this.takeSidePutPermits = 0;
            return this.putPermits;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void incrementTakeSidePutPermitsWithoutNotify() {
            Object object = this.permitMon;
            synchronized (object) {
                ++this.takeSidePutPermits;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void incrementTakeSidePutPermits() {
            if (this.haContainer instanceof HAContainerMap && this.isPrimary()) {
                Object object = this.permitMon;
                synchronized (object) {
                    ++this.takeSidePutPermits;
                    this.permitMon.notify();
                }
            }
        }

        @Override
        void acquireWriteLock() {
            this.lock.lock();
        }

        @Override
        void acquireReadLock() {
            this.lock.lock();
        }

        @Override
        void notifyPeekAndTakeThreads() {
            this.blockCond.signalAll();
        }

        @Override
        boolean waitForData() throws InterruptedException {
            while (this.internalIsEmpty()) {
                this.region.getCache().getCancelCriterion().checkCancelInProgress(null);
                boolean interrupted = Thread.currentThread().isInterrupted();
                try {
                    this.blockCond.await(15000L);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                    this.region.getCache().getCancelCriterion().checkCancelInProgress(ie);
                    throw new TimeoutException(ie);
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                }
            }
            return true;
        }

        @Override
        void putGIIDataInRegion() {
        }

        @Override
        void releaseReadLock() {
            this.lock.unlock();
        }

        @Override
        void releaseWriteLock() {
            this.lock.unlock();
        }
    }
}

