/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.OffHeapRegionEntry;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.VMThinLRURegionEntry;
import org.apache.geode.internal.cache.VMThinLRURegionEntryHeap;
import org.apache.geode.internal.cache.VMThinLRURegionEntryOffHeapIntKey;
import org.apache.geode.internal.cache.VMThinLRURegionEntryOffHeapLongKey;
import org.apache.geode.internal.cache.VMThinLRURegionEntryOffHeapObjectKey;
import org.apache.geode.internal.cache.VMThinLRURegionEntryOffHeapStringKey1;
import org.apache.geode.internal.cache.VMThinLRURegionEntryOffHeapStringKey2;
import org.apache.geode.internal.cache.VMThinLRURegionEntryOffHeapUUIDKey;
import org.apache.geode.internal.cache.VersionedThinLRURegionEntryOffHeap;

public abstract class VMThinLRURegionEntryOffHeap
extends VMThinLRURegionEntry
implements OffHeapRegionEntry {
    private static final VMThinLRURegionEntryOffHeapFactory factory = new VMThinLRURegionEntryOffHeapFactory();

    public VMThinLRURegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinLRURegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VMThinLRURegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinLRURegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMThinLRURegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinLRURegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMThinLRURegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinLRURegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMThinLRURegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VMThinLRURegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinLRURegionEntryOffHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VMThinLRURegionEntryHeap.getEntryFactory();
        }
    }
}

