/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.locks.TXLockId;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class TXFarSideCMTracker {
    private static final Logger logger = LogService.getLogger();
    private final Map txInProgress;
    private final Object[] txHistory;
    private int lastHistoryItem;
    private Map<TXId, TXCommitMessage> failoverMap = Collections.synchronizedMap(new LinkedHashMap<TXId, TXCommitMessage>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > TXManagerImpl.FAILOVER_TX_MAP_SIZE;
        }
    });

    public TXFarSideCMTracker(int historySize) {
        this.txInProgress = new HashMap();
        this.txHistory = new Object[historySize];
        this.lastHistoryItem = 0;
    }

    public final int getHistorySize() {
        return this.txHistory.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean commitProcessReceived(Object key, DM dm) {
        TXCommitMessage mess;
        if (key instanceof TXLockId) {
            TXLockId lk = (TXLockId)key;
            this.waitForMemberToDepart(lk.getMemberId(), dm);
        } else if (key instanceof TXId) {
            TXId id = (TXId)key;
            this.waitForMemberToDepart(id.getMemberId(), dm);
        } else {
            Assert.assertTrue(false, "TXTracker received an unknown key class: " + key.getClass());
        }
        Object object = this.txInProgress;
        synchronized (object) {
            mess = (TXCommitMessage)this.txInProgress.get(key);
            if (null != mess && mess.isProcessing()) {
                return true;
            }
            for (int i = this.txHistory.length - 1; i >= 0; --i) {
                if (!key.equals(this.txHistory[i])) continue;
                return true;
            }
        }
        if (mess != null) {
            object = mess;
            synchronized (object) {
                if (!mess.isProcessing()) {
                    mess.setDontProcess();
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForAllToProcess() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Map map = this.txInProgress;
        synchronized (map) {
            while (!this.txInProgress.isEmpty()) {
                this.txInProgress.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitToProcess(TXLockId lk, DM dm) {
        TXCommitMessage mess;
        this.waitForMemberToDepart(lk.getMemberId(), dm);
        Object object = this.txInProgress;
        synchronized (object) {
            mess = (TXCommitMessage)this.txInProgress.get(lk);
        }
        if (mess != null) {
            object = mess;
            synchronized (object) {
                while (!mess.wasProcessed()) {
                    try {
                        mess.wait();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        logger.error((Message)LocalizedMessage.create(LocalizedStrings.TxFarSideTracker_WAITING_TO_COMPLETE_ON_MESSAGE_0_CAUGHT_AN_INTERRUPTED_EXCEPTION, mess), (Throwable)ie);
                        break;
                    }
                }
            }
        } else {
            for (int i = this.txHistory.length - 1; i >= 0; --i) {
                if (!lk.equals(this.txHistory[i])) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void waitForMemberToDepart(final InternalDistributedMember memberId, DM dm) {
        if (!dm.getDistributionManagerIds().contains(memberId)) {
            return;
        }
        final Object lock = new Object();
        MembershipListener memEar = new MembershipListener(){

            @Override
            public void memberJoined(InternalDistributedMember id) {
            }

            @Override
            public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void memberDeparted(InternalDistributedMember id, boolean crashed) {
                if (memberId.equals(id)) {
                    Object object = lock;
                    synchronized (object) {
                        lock.notifyAll();
                    }
                }
            }

            @Override
            public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
            }
        };
        try {
            Set memberSet = dm.addMembershipListenerAndGetDistributionManagerIds(memEar);
            Object object = lock;
            synchronized (object) {
                while (memberSet.contains(memberId)) {
                    try {
                        lock.wait();
                        memberSet = dm.getDistributionManagerIds();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        // MONITOREXIT @DISABLED, blocks:[0, 5, 6, 9] lbl16 : MonitorExitStatement: MONITOREXIT : var6_6
                        dm.removeMembershipListener(memEar);
                        return;
                    }
                }
                return;
            }
        }
        finally {
            dm.removeMembershipListener(memEar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TXCommitMessage processed(TXCommitMessage processedMess) {
        TXCommitMessage mess;
        Object key = processedMess.getTrackerKey();
        Object object = this.txInProgress;
        synchronized (object) {
            mess = (TXCommitMessage)this.txInProgress.remove(key);
            if (mess != null) {
                this.txHistory[this.lastHistoryItem++] = key;
                if (this.lastHistoryItem >= this.txHistory.length) {
                    this.lastHistoryItem = 0;
                }
                if (this.txInProgress.isEmpty()) {
                    this.txInProgress.notifyAll();
                }
            }
        }
        if (mess != null) {
            object = mess;
            synchronized (object) {
                mess.setProcessed(true);
                mess.notifyAll();
            }
        }
        return mess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeMessage(TXCommitMessage deadMess) {
        Map map = this.txInProgress;
        synchronized (map) {
            this.txInProgress.remove(deadMess.getTrackerKey());
            if (this.txInProgress.isEmpty()) {
                this.txInProgress.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TXCommitMessage get(Object key) {
        TXCommitMessage mess;
        Map map = this.txInProgress;
        synchronized (map) {
            mess = (TXCommitMessage)this.txInProgress.get(key);
        }
        return mess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TXCommitMessage waitForMessage(Object key, DM dm) {
        TXCommitMessage msg = null;
        Map map = this.txInProgress;
        synchronized (map) {
            msg = (TXCommitMessage)this.txInProgress.get(key);
            while (msg == null) {
                try {
                    dm.getSystem().getCancelCriterion().checkCancelInProgress(null);
                    this.txInProgress.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                msg = (TXCommitMessage)this.txInProgress.get(key);
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(TXCommitMessage msg) {
        Map map = this.txInProgress;
        synchronized (map) {
            Object key = msg.getTrackerKey();
            if (key == null) {
                Assert.assertTrue(false, "TXFarSideCMTracker must have a non-null key for message " + msg);
            }
            this.txInProgress.put(key, msg);
            this.txInProgress.notifyAll();
        }
    }

    public void saveTXForClientFailover(TXId txId, TXCommitMessage msg) {
        this.failoverMap.put(txId, msg);
    }

    public TXCommitMessage getTXCommitMessage(TXId txId) {
        return this.failoverMap.get(txId);
    }

    public void clearForCacheClose() {
        this.failoverMap.clear();
        this.lastHistoryItem = 0;
        Arrays.fill(this.txHistory, null);
    }
}

