/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.CancelException;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.cache.TransactionDataRebalancedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.TransactionInDoubtException;
import org.apache.geode.cache.client.internal.ServerRegionDataAccess;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ReliableReplyException;
import org.apache.geode.distributed.internal.ReliableReplyProcessor21;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.JtaAfterCompletionMessage;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXRemoteCommitMessage;
import org.apache.geode.internal.cache.TXRemoteRollbackMessage;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.TXStateStub;
import org.apache.geode.internal.cache.tx.AbstractPeerTXRegionStub;
import org.apache.geode.internal.cache.tx.DistributedTXRegionStub;
import org.apache.geode.internal.cache.tx.PartitionedTXRegionStub;
import org.apache.geode.internal.cache.tx.TXRegionStub;
import org.apache.geode.internal.cache.tx.TransactionalOperation;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class PeerTXStateStub
extends TXStateStub {
    protected static final Logger logger = LogService.getLogger();
    private InternalDistributedMember originatingMember = null;
    protected TXCommitMessage commitMessage = null;

    public PeerTXStateStub(TXStateProxy stateProxy, DistributedMember target, InternalDistributedMember onBehalfOfClient) {
        super(stateProxy, target);
        this.originatingMember = onBehalfOfClient;
    }

    @Override
    public void rollback() {
        block11: {
            ReliableReplyProcessor21 response = TXRemoteRollbackMessage.send(this.proxy.getCache(), this.proxy.getTxId().getUniqId(), this.getOriginatingMember(), this.target);
            if (this.internalAfterSendRollback != null) {
                this.internalAfterSendRollback.run();
            }
            try {
                response.waitForReplies();
            }
            catch (PrimaryBucketException primaryBucketException) {
            }
            catch (ReplyException e) {
                this.proxy.getCache().getCancelCriterion().checkCancelInProgress(e);
                if (e.getCause() != null && e.getCause() instanceof CancelException) {
                    if (this.internalAfterSendRollback != null) {
                        this.internalAfterSendRollback.run();
                    }
                    break block11;
                }
                throw new TransactionException(LocalizedStrings.TXStateStub_ROLLBACK_ON_NODE_0_FAILED.toLocalizedString(this.target), e);
            }
            catch (Exception e) {
                this.getCache().getCancelCriterion().checkCancelInProgress(e);
                throw new TransactionException(LocalizedStrings.TXStateStub_ROLLBACK_ON_NODE_0_FAILED.toLocalizedString(this.target), e);
            }
            finally {
                this.cleanup();
            }
        }
    }

    @Override
    public void commit() throws CommitConflictException {
        assert (this.target != null);
        TXRemoteCommitMessage.RemoteCommitResponse message = TXRemoteCommitMessage.send(this.proxy.getCache(), this.proxy.getTxId().getUniqId(), this.getOriginatingMember(), this.target);
        if (this.internalAfterSendCommit != null) {
            this.internalAfterSendCommit.run();
        }
        try {
            this.commitMessage = message.waitForResponse();
        }
        catch (CommitConflictException e) {
            throw e;
        }
        catch (TransactionException te) {
            throw te;
        }
        catch (ReliableReplyException e) {
            if (e.getCause() != null) {
                throw new TransactionInDoubtException(e.getCause());
            }
            throw new TransactionInDoubtException(e);
        }
        catch (ReplyException e) {
            if (e.getCause() instanceof CommitConflictException) {
                throw (CommitConflictException)e.getCause();
            }
            if (e.getCause() instanceof TransactionException) {
                throw (TransactionException)e.getCause();
            }
            if (e.getCause() != null) {
                throw new TransactionInDoubtException(e.getCause());
            }
            throw new TransactionInDoubtException(e);
        }
        catch (Exception e) {
            this.getCache().getCancelCriterion().checkCancelInProgress(e);
            if (e.getCause() != null) {
                if (e.getCause() instanceof ForceReattemptException) {
                    Throwable e2 = e.getCause();
                    if (e2.getCause() != null && e2.getCause() instanceof PrimaryBucketException) {
                        TransactionDataRebalancedException tdnce = new TransactionDataRebalancedException(e2.getCause().getMessage());
                        tdnce.initCause(e2.getCause());
                        throw tdnce;
                    }
                    TransactionInDoubtException tdnce = new TransactionInDoubtException(e.getCause().getMessage());
                    tdnce.initCause(e.getCause());
                    throw tdnce;
                }
                throw new TransactionInDoubtException(e.getCause());
            }
            throw new TransactionInDoubtException(e);
        }
        finally {
            this.cleanup();
        }
    }

    protected void cleanup() {
        for (TXRegionStub regionStub : this.regionStubs.values()) {
            regionStub.cleanup();
        }
    }

    @Override
    protected TXRegionStub generateRegionStub(LocalRegion region) {
        AbstractPeerTXRegionStub stub = null;
        stub = region.getPartitionAttributes() == null ? new DistributedTXRegionStub(this, region) : new PartitionedTXRegionStub(this, region);
        return stub;
    }

    @Override
    protected void validateRegionCanJoinTransaction(LocalRegion region) throws TransactionException {
        if (region.hasServerProxy()) {
            throw new TransactionException("Can't involve c/s region in peer tx");
        }
    }

    @Override
    public void afterCompletion(int status) {
        TXRemoteCommitMessage.RemoteCommitResponse response = JtaAfterCompletionMessage.send(this.proxy.getCache(), this.proxy.getTxId().getUniqId(), this.getOriginatingMember(), status, this.target);
        try {
            this.proxy.getTxMgr().setTXState(null);
            this.commitMessage = response.waitForResponse();
            if (logger.isDebugEnabled()) {
                logger.debug("afterCompletion received commit response of {}", (Object)this.commitMessage);
            }
        }
        catch (Exception e) {
            throw new TransactionException(e);
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public InternalDistributedMember getOriginatingMember() {
        return this.originatingMember;
    }

    public void setOriginatingMember(InternalDistributedMember clientMemberId) {
        this.originatingMember = clientMemberId;
    }

    @Override
    public boolean isMemberIdForwardingRequired() {
        return this.getOriginatingMember() != null;
    }

    @Override
    public TXCommitMessage getCommitMessage() {
        return this.commitMessage;
    }

    @Override
    public void suspend() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void recordTXOperation(ServerRegionDataAccess region, TransactionalOperation.ServerRegionOperation op, Object key, Object[] arguments) {
    }
}

