/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.admin.remote.AdminMultipleReplyProcessor;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.CliLegacyMessage;
import org.apache.geode.internal.admin.remote.RevokePersistentIDResponse;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.persistence.PersistentMemberManager;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;

public class RevokePersistentIDRequest
extends CliLegacyMessage {
    PersistentMemberPattern pattern;

    public RevokePersistentIDRequest() {
    }

    public RevokePersistentIDRequest(PersistentMemberPattern pattern) {
        this.pattern = pattern;
    }

    public static void send(DM dm, PersistentMemberPattern pattern) {
        Set recipients = dm.getOtherDistributionManagerIds();
        RevokePersistentIDRequest request = new RevokePersistentIDRequest(pattern);
        request.setRecipients(recipients);
        AdminMultipleReplyProcessor replyProcessor = new AdminMultipleReplyProcessor(dm, (Collection)recipients);
        request.msgId = replyProcessor.getProcessorId();
        dm.putOutgoing(request);
        try {
            replyProcessor.waitForReplies();
        }
        catch (ReplyException e) {
            if (e.getCause() instanceof CancelException) {
                return;
            }
            throw e;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        request.createResponse((DistributionManager)dm);
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && !cache.isClosed()) {
            PersistentMemberManager mm = cache.getPersistentMemberManager();
            mm.revokeMember(this.pattern);
        }
        return new RevokePersistentIDResponse(this.getSender());
    }

    @Override
    public int getDSFID() {
        return 2107;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.pattern = new PersistentMemberPattern();
        InternalDataSerializer.invokeFromData(this.pattern, in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        InternalDataSerializer.invokeToData(this.pattern, out);
    }
}

