/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.admin.Alert;
import org.apache.geode.internal.admin.GemFireVM;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.DateFormatter;
import org.apache.geode.internal.logging.LogWriterImpl;

public class RemoteAlert
implements Alert {
    private final GemFireVM manager;
    private final String connectionName;
    private final String sourceId;
    private final int level;
    private final Date date;
    private final String message;
    private final InternalDistributedMember sender;

    public RemoteAlert(GemFireVM manager, int level, Date date, String connectionName, String threadName, long tid, String msg, String exceptionText, InternalDistributedMember sender) {
        this.manager = manager;
        this.level = level;
        this.date = date;
        this.connectionName = connectionName;
        StringBuffer tmpSourceId = new StringBuffer();
        tmpSourceId.append(threadName);
        if (tmpSourceId.length() > 0) {
            tmpSourceId.append(' ');
        }
        tmpSourceId.append("tid=0x");
        tmpSourceId.append(Long.toHexString(tid));
        this.sourceId = tmpSourceId.toString();
        StringBuffer tmpMessage = new StringBuffer();
        tmpMessage.append(msg);
        if (tmpMessage.length() > 0) {
            tmpMessage.append('\n');
        }
        tmpMessage.append(exceptionText);
        this.message = tmpMessage.toString();
        this.sender = sender;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public GemFireVM getGemFireVM() {
        return this.manager;
    }

    @Override
    public String getConnectionName() {
        return this.connectionName;
    }

    @Override
    public String getSourceId() {
        return this.sourceId;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public InternalDistributedMember getSender() {
        return this.sender;
    }

    public static Alert fromString(String s) {
        Date date;
        int firstBracket = s.indexOf(91);
        int lastBracket = s.indexOf(93);
        final String message = s.substring(lastBracket + 1).trim();
        String stamp = s.substring(firstBracket, lastBracket);
        StringTokenizer st = new StringTokenizer(stamp, "[ ");
        final int level = LogWriterImpl.levelNameToCode(st.nextToken());
        StringBuffer sb = new StringBuffer();
        sb.append(st.nextToken());
        sb.append(" ");
        sb.append(st.nextToken());
        sb.append(" ");
        sb.append(st.nextToken());
        DateFormat timeFormatter = DateFormatter.createDateFormat();
        try {
            date = timeFormatter.parse(sb.toString());
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(LocalizedStrings.RemoteAlert_INVALIDATE_TIMESTAMP_0.toLocalizedString(sb.toString()));
        }
        final String connectionName = st.nextToken();
        sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            sb.append(" ");
        }
        final String sourceId = sb.toString().trim();
        Assert.assertTrue(!st.hasMoreTokens());
        return new Alert(){

            @Override
            public int getLevel() {
                return level;
            }

            @Override
            public GemFireVM getGemFireVM() {
                return null;
            }

            @Override
            public String getConnectionName() {
                return connectionName;
            }

            @Override
            public String getSourceId() {
                return sourceId;
            }

            @Override
            public String getMessage() {
                return message;
            }

            @Override
            public Date getDate() {
                return date;
            }

            @Override
            public InternalDistributedMember getSender() {
                return null;
            }
        };
    }

    public String toString() {
        DateFormat timeFormatter = DateFormatter.createDateFormat();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print('[');
        pw.print(LogWriterImpl.levelToString(this.level));
        pw.print(' ');
        pw.print(timeFormatter.format(this.date));
        pw.print(' ');
        pw.print(this.connectionName);
        pw.print(' ');
        pw.print(this.sourceId);
        pw.print("] ");
        pw.print(this.message);
        pw.close();
        try {
            sw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }
}

