/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.BridgeServerRequest;
import org.apache.geode.internal.admin.remote.RemoteBridgeServer;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;

public final class BridgeServerResponse
extends AdminResponse {
    private RemoteBridgeServer bridgeInfo;
    private Exception exception;

    static BridgeServerResponse create(DistributionManager dm, BridgeServerRequest request) {
        BridgeServerResponse m;
        block16: {
            m = new BridgeServerResponse();
            m.setRecipient(request.getSender());
            try {
                GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.getInstanceCloseOk(dm.getSystem());
                if (request.getCacheId() != System.identityHashCode(cache)) {
                    m.bridgeInfo = null;
                    break block16;
                }
                int operation = request.getOperation();
                block1 : switch (operation) {
                    case 10: {
                        CacheServerImpl bridge = (CacheServerImpl)cache.addCacheServer();
                        m.bridgeInfo = new RemoteBridgeServer(bridge);
                        break;
                    }
                    case 11: {
                        int id = request.getBridgeId();
                        for (CacheServerImpl bridge : cache.getCacheServers()) {
                            if (System.identityHashCode(bridge) == id) {
                                m.bridgeInfo = new RemoteBridgeServer(bridge);
                                break block1;
                            }
                            m.bridgeInfo = null;
                        }
                        break;
                    }
                    case 12: {
                        RemoteBridgeServer config = request.getBridgeInfo();
                        for (CacheServerImpl bridge : cache.getCacheServers()) {
                            if (System.identityHashCode(bridge) == config.getId()) {
                                bridge.configureFrom(config);
                                bridge.start();
                                m.bridgeInfo = new RemoteBridgeServer(bridge);
                                break block1;
                            }
                            m.bridgeInfo = null;
                        }
                        break;
                    }
                    case 13: {
                        RemoteBridgeServer config = request.getBridgeInfo();
                        for (CacheServerImpl bridge : cache.getCacheServers()) {
                            if (System.identityHashCode(bridge) == config.getId()) {
                                bridge.stop();
                                m.bridgeInfo = new RemoteBridgeServer(bridge);
                                break block1;
                            }
                            m.bridgeInfo = null;
                        }
                        break;
                    }
                    default: {
                        Assert.assertTrue(false, "Unknown bridge server operation: " + operation);
                    }
                }
            }
            catch (CancelException ex) {
                m.bridgeInfo = null;
            }
            catch (Exception ex) {
                m.exception = ex;
                m.bridgeInfo = null;
            }
        }
        return m;
    }

    public RemoteBridgeServer getBridgeInfo() {
        return this.bridgeInfo;
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public int getDSFID() {
        return 1011;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.bridgeInfo, out);
        DataSerializer.writeObject(this.exception, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bridgeInfo = (RemoteBridgeServer)DataSerializer.readObject(in);
        this.exception = (Exception)DataSerializer.readObject(in);
    }
}

