/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.ServerRegionProxy;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.admin.ClientHealthMonitoringRegion;
import org.apache.geode.internal.admin.remote.ClientHealthStats;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.management.internal.cli.CliUtil;

public class ClientStatsManager {
    static GemFireCacheImpl lastInitializedCache = null;
    private static Statistics cachePerfStats = null;
    private static Statistics vmStats = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void publishClientStats(PoolImpl pool) {
        GemFireCacheImpl currentCache = GemFireCacheImpl.getInstance();
        if (!ClientStatsManager.initializeStatistics(currentCache)) {
            return;
        }
        LogWriterI18n logger = currentCache.getLoggerI18n();
        if (logger.fineEnabled()) {
            logger.fine("Entering ClientStatsManager#publishClientStats...");
        }
        ClientHealthStats stats = ClientStatsManager.getClientHealthStats(currentCache, pool);
        try {
            InternalDistributedSystem ds = currentCache.getDistributedSystem();
            ServerRegionProxy regionProxy = new ServerRegionProxy("__ADMIN_CLIENT_HEALTH_MONITORING__", pool);
            EventID eventId = new EventID(ds);
            EntryEventImpl event = new EntryEventImpl((Object)null);
            try {
                event.setEventId(eventId);
                regionProxy.putForMetaRegion(ds.getMemberId(), stats, null, event, null, true);
            }
            finally {
                event.release();
            }
        }
        catch (DistributedSystemDisconnectedException e) {
            throw e;
        }
        catch (CacheWriterException cwx) {
            pool.getCancelCriterion().checkCancelInProgress(cwx);
            currentCache.getCancelCriterion().checkCancelInProgress(cwx);
            logger.warning(LocalizedStrings.ClientStatsManager_FAILED_TO_SEND_CLIENT_HEALTH_STATS_TO_CACHESERVER, cwx);
        }
        catch (Exception e) {
            pool.getCancelCriterion().checkCancelInProgress(e);
            currentCache.getCancelCriterion().checkCancelInProgress(e);
            logger.info(LocalizedStrings.ClientStatsManager_FAILED_TO_PUBLISH_CLIENT_STATISTICS, e);
        }
        if (logger.fineEnabled()) {
            logger.fine("Exiting ClientStatsManager#publishClientStats.");
        }
    }

    public static void cleanupForTests() {
        lastInitializedCache = null;
    }

    private static boolean initializeStatistics(GemFireCacheImpl currentCache) {
        Statistics[] statistics;
        StatisticsType type;
        if (currentCache == null) {
            return false;
        }
        LogWriterI18n logger = currentCache.getLoggerI18n();
        InternalDistributedSystem ds = currentCache.getDistributedSystem();
        if (currentCache.isClosed()) {
            return false;
        }
        boolean restart = lastInitializedCache != currentCache;
        lastInitializedCache = currentCache;
        if (restart) {
            if (logger.infoEnabled()) {
                logger.info(LocalizedStrings.ClientStatsManager_CLIENTSTATSMANAGER_INTIALIZING_THE_STATISTICS);
            }
            cachePerfStats = null;
            vmStats = null;
        }
        if (cachePerfStats == null && (type = ds.findType("CachePerfStats")) != null && (statistics = ds.findStatisticsByType(type)) != null && statistics.length > 0) {
            cachePerfStats = statistics[0];
        }
        if (vmStats == null && (type = ds.findType("VMStats")) != null && (statistics = ds.findStatisticsByType(type)) != null && statistics.length > 0) {
            vmStats = statistics[0];
        }
        if (cachePerfStats == null && restart) {
            logger.warning(LocalizedStrings.ClientStatsManager_CLIENTSTATSMANAGER_0_ARE_NOT_AVAILABLE, "CachePerfStats");
        }
        if (vmStats == null && restart) {
            logger.warning(LocalizedStrings.ClientStatsManager_CLIENTSTATSMANAGER_0_ARE_NOT_AVAILABLE, "VMStats");
        }
        return true;
    }

    private static ClientHealthStats getClientHealthStats(GemFireCacheImpl currentCache, PoolImpl pool) {
        if (currentCache == null) {
            return null;
        }
        ClientHealthStats stats = new ClientHealthStats();
        LogWriterI18n logger = currentCache.getLoggerI18n();
        int gets = -1;
        int puts = -1;
        int misses = -1;
        long processCpuTime = -1L;
        int threads = -1;
        int cacheListenerCalls = -1;
        int cpus = -1;
        String poolName = "";
        if (cachePerfStats != null) {
            gets = cachePerfStats.getInt("gets");
            puts = cachePerfStats.getInt("puts");
            misses = cachePerfStats.getInt("misses");
            cacheListenerCalls = cachePerfStats.getInt("cacheListenerCallsCompleted");
        }
        if (vmStats != null) {
            processCpuTime = vmStats.getLong("processCpuTime");
            threads = vmStats.getInt("threads");
            cpus = vmStats.getInt("cpus");
        }
        stats.setNumOfGets(gets);
        stats.setNumOfPuts(puts);
        stats.setNumOfMisses(misses);
        stats.setNumOfCacheListenerCalls(cacheListenerCalls);
        stats.setProcessCpuTime(processCpuTime);
        stats.setNumOfThreads(threads);
        stats.setCpus(cpus);
        poolName = pool.getName();
        try {
            HashMap<String, String> newPoolStats = stats.getPoolStats();
            String poolStatsStr = "MinConnections=" + pool.getMinConnections() + ";MaxConnections=" + pool.getMaxConnections() + ";Redudancy=" + pool.getSubscriptionRedundancy() + ";CQS=" + pool.getQueryService().getCqs().length;
            logger.info(LocalizedStrings.DEBUG, "ClientHealthStats for poolname " + poolName + " poolStatsStr=" + poolStatsStr);
            newPoolStats.put(poolName, poolStatsStr);
            Region clientHealthMonitoringRegion = ClientHealthMonitoringRegion.getInstance(currentCache);
            if (clientHealthMonitoringRegion != null) {
                InternalDistributedSystem ds = currentCache.getDistributedSystem();
                ClientHealthStats oldStats = (ClientHealthStats)clientHealthMonitoringRegion.get(ds.getMemberId());
                logger.info(LocalizedStrings.DEBUG, "getClientHealthStats got oldStats  " + oldStats);
                if (oldStats != null) {
                    HashMap<String, String> oldPoolStats = oldStats.getPoolStats();
                    logger.info(LocalizedStrings.DEBUG, "getClientHealthStats got oldPoolStats  " + oldPoolStats);
                    if (oldPoolStats != null) {
                        for (Map.Entry entry : oldPoolStats.entrySet()) {
                            if (poolName.equals(entry.getKey())) continue;
                            stats.getPoolStats().put((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.fine("Exception in getting pool stats in  getClientHealthStats " + CliUtil.stackTraceAsString(e));
        }
        stats.setUpdateTime(new Date());
        return stats;
    }
}

