/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.direct;

import java.io.IOException;
import java.io.NotSerializableException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.ToDataException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.direct.DirectChannelListener;
import org.apache.geode.distributed.internal.direct.ShunnedMemberException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.MembershipManager;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.cache.DirectReplyMessage;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.AlertAppender;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.tcp.BaseMsgStreamer;
import org.apache.geode.internal.tcp.ConnectExceptions;
import org.apache.geode.internal.tcp.Connection;
import org.apache.geode.internal.tcp.ConnectionException;
import org.apache.geode.internal.tcp.MemberShunnedException;
import org.apache.geode.internal.tcp.MsgStreamer;
import org.apache.geode.internal.tcp.TCPConduit;
import org.apache.geode.internal.util.Breadcrumbs;
import org.apache.geode.internal.util.concurrent.ReentrantSemaphore;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class DirectChannel {
    private static final Logger logger = LogService.getLogger();
    private final transient TCPConduit conduit;
    private volatile boolean disconnected = true;
    private volatile boolean disconnectCompleted = true;
    private final DirectChannelListener receiver;
    private final InetAddress address;
    InternalDistributedMember localAddr;
    public static final int DEFAULT_CONCURRENCY_LEVEL = Integer.getInteger("p2p.defaultConcurrencyLevel", 0x3FFFFFFF);
    private static final int MAX_GROUP_SENDERS = Integer.getInteger("p2p.maxGroupSenders", DEFAULT_CONCURRENCY_LEVEL);
    private Semaphore groupUnorderedSenderSem;
    private Semaphore groupOrderedSenderSem;

    public void setLocalAddr(InternalDistributedMember localAddr) {
        this.localAddr = localAddr;
        this.conduit.setLocalAddr(localAddr);
        if (this.disconnected) {
            this.disconnected = false;
            this.disconnectCompleted = false;
            this.groupOrderedSenderSem = new ReentrantSemaphore(MAX_GROUP_SENDERS);
            this.groupUnorderedSenderSem = new ReentrantSemaphore(MAX_GROUP_SENDERS);
        }
    }

    public void setMembershipSize(int numberOfMembers) {
        this.conduit.setMaximumHandshakePoolSize(numberOfMembers);
    }

    public CancelCriterion getCancelCriterion() {
        return this.conduit.getCancelCriterion();
    }

    public DirectChannel(MembershipManager mgr, DirectChannelListener listener, DistributionConfig dc) throws ConnectionException {
        this.receiver = listener;
        this.address = this.initAddress(dc);
        boolean isBindAddress = dc.getBindAddress() != null;
        try {
            Properties props;
            int port = Integer.getInteger("tcpServerPort", 0);
            if (port == 0) {
                port = dc.getTcpPort();
            }
            if ((props = System.getProperties()).getProperty("p2p.shareSockets") == null) {
                props.setProperty("p2p.shareSockets", String.valueOf(dc.getConserveSockets()));
            }
            if (dc.getSocketBufferSize() != 32768) {
                props.setProperty("p2p.tcpBufferSize", String.valueOf(dc.getSocketBufferSize()));
            }
            if (props.getProperty("p2p.idleConnectionTimeout") == null) {
                props.setProperty("p2p.idleConnectionTimeout", String.valueOf(dc.getSocketLeaseTime()));
            }
            int[] range = dc.getMembershipPortRange();
            props.setProperty("membership_port_range_start", "" + range[0]);
            props.setProperty("membership_port_range_end", "" + range[1]);
            this.conduit = new TCPConduit(mgr, port, this.address, isBindAddress, this, props);
            this.disconnected = false;
            this.disconnectCompleted = false;
            this.groupOrderedSenderSem = new ReentrantSemaphore(MAX_GROUP_SENDERS);
            this.groupUnorderedSenderSem = new ReentrantSemaphore(MAX_GROUP_SENDERS);
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DirectChannel_GEMFIRE_P2P_LISTENER_STARTED_ON__0, this.conduit.getLocalAddr()));
        }
        catch (ConnectionException ce) {
            logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.DirectChannel_UNABLE_TO_INITIALIZE_DIRECT_CHANNEL_BECAUSE__0, new Object[]{ce.getMessage()}), (Throwable)ce);
            throw ce;
        }
    }

    private Semaphore getGroupSem(boolean ordered) {
        if (ordered) {
            return this.groupOrderedSenderSem;
        }
        return this.groupUnorderedSenderSem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireGroupSendPermission(boolean ordered) {
        if (this.disconnected) {
            throw new DistributedSystemDisconnectedException(LocalizedStrings.DirectChannel_DIRECT_CHANNEL_HAS_BEEN_STOPPED.toLocalizedString());
        }
        Semaphore s = this.getGroupSem(ordered);
        while (true) {
            this.conduit.getCancelCriterion().checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                s.acquire();
            }
            catch (InterruptedException ex) {
                interrupted = true;
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
        if (this.disconnected) {
            s.release();
            throw new DistributedSystemDisconnectedException(LocalizedStrings.DirectChannel_COMMUNICATIONS_DISCONNECTED.toLocalizedString());
        }
    }

    private void releaseGroupSendPermission(boolean ordered) {
        Semaphore s = this.getGroupSem(ordered);
        s.release();
    }

    boolean threadOwnsResources() {
        DM d = this.getDM();
        if (d != null) {
            return d.getSystem().threadOwnsResources() && !AlertAppender.isThreadAlerting();
        }
        return false;
    }

    private final int sendToOne(MembershipManager mgr, InternalDistributedMember[] p_destinations, DistributionMessage msg, long ackWaitThreshold, long ackSAThreshold) throws ConnectExceptions, NotSerializableException {
        return this.sendToMany(mgr, p_destinations, msg, ackWaitThreshold, ackSAThreshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendToMany(MembershipManager mgr, InternalDistributedMember[] p_destinations, DistributionMessage msg, long ackWaitThreshold, long ackSAThreshold) throws ConnectExceptions, NotSerializableException {
        InternalDistributedMember[] destinations = p_destinations;
        ConnectExceptions failedCe = null;
        ConnectExceptions retryInfo = null;
        int bytesWritten = 0;
        boolean retry = false;
        boolean orderedMsg = msg.orderedDelivery() || Connection.isDominoThread();
        ArrayList totalSentCons = new ArrayList(destinations.length);
        boolean interrupted = false;
        long ackTimeout = 0L;
        long ackSDTimeout = 0L;
        long startTime = 0L;
        DirectReplyMessage directMsg = msg instanceof DirectReplyMessage ? (DirectReplyMessage)((Object)msg) : null;
        if (directMsg != null || msg.getProcessorId() > 0) {
            ackTimeout = (int)(ackWaitThreshold * 1000L);
            if (msg.isSevereAlertCompatible() || ReplyProcessor21.isSevereAlertProcessingForced()) {
                ackSDTimeout = (int)(ackSAThreshold * 1000L);
                if (ReplyProcessor21.getShortSevereAlertProcessing()) {
                    ackSDTimeout = (int)(ReplyProcessor21.PR_SEVERE_ALERT_RATIO * (double)ackSDTimeout);
                }
            }
        }
        boolean directReply = false;
        if (directMsg != null && directMsg.supportsDirectAck() && this.threadOwnsResources()) {
            directReply = true;
        }
        if (!directReply && directMsg != null) {
            directMsg.registerProcessor();
        }
        try {
            do {
                ConnectExceptions ce;
                block55: {
                    boolean bl = interrupted = interrupted || Thread.interrupted();
                    if (retryInfo != null) {
                        List retryMembers = retryInfo.getMembers();
                        InternalDistributedMember[] retryDest = new InternalDistributedMember[retryMembers.size()];
                        retryDest = retryMembers.toArray(retryDest);
                        destinations = retryDest;
                        retryInfo = null;
                        retry = true;
                    }
                    ArrayList cons = new ArrayList(destinations.length);
                    ce = this.getConnections(mgr, msg, destinations, orderedMsg, retry, ackTimeout, ackSDTimeout, cons);
                    if (directReply && msg.getProcessorId() > 0) {
                        directReply = false;
                    }
                    if (ce != null) {
                        if (failedCe != null) {
                            failedCe.getMembers().addAll(ce.getMembers());
                            failedCe.getCauses().addAll(ce.getCauses());
                        } else {
                            failedCe = ce;
                        }
                        ce = null;
                    }
                    if (cons.isEmpty()) {
                        if (failedCe != null) {
                            throw failedCe;
                        }
                        int n = bytesWritten;
                        return n;
                    }
                    boolean sendingToGroup = cons.size() > 1;
                    Connection permissionCon = null;
                    if (sendingToGroup) {
                        this.acquireGroupSendPermission(orderedMsg);
                    } else {
                        permissionCon = (Connection)cons.get(0);
                        if (permissionCon != null) {
                            try {
                                permissionCon.acquireSendPermission();
                            }
                            catch (ConnectionException conEx) {
                                retryInfo = new ConnectExceptions();
                                retryInfo.addFailure(permissionCon.getRemoteAddress(), conEx);
                                continue;
                            }
                        }
                    }
                    try {
                        List<?> sentCons;
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}{}) to {} peers ({}) via tcp/ip", (Object)(retry ? "Retrying send (" : "Sending ("), (Object)msg, (Object)cons.size(), cons);
                        }
                        DMStats stats = this.getDMStats();
                        BaseMsgStreamer ms = MsgStreamer.create(cons, msg, directReply, stats);
                        try {
                            startTime = 0L;
                            if (ackTimeout > 0L) {
                                startTime = System.currentTimeMillis();
                            }
                            ms.reserveConnections(startTime, ackTimeout, ackSDTimeout);
                            int result = ms.writeMessage();
                            if (bytesWritten == 0) {
                                bytesWritten = result;
                            }
                            ce = ms.getConnectExceptions();
                            sentCons = ms.getSentConnections();
                            totalSentCons.addAll(sentCons);
                        }
                        catch (NotSerializableException e) {
                            throw e;
                        }
                        catch (ToDataException e) {
                            throw e;
                        }
                        catch (IOException ex) {
                            throw new InternalGemFireException(LocalizedStrings.DirectChannel_UNKNOWN_ERROR_SERIALIZING_MESSAGE.toLocalizedString(), ex);
                        }
                        finally {
                            try {
                                ms.close();
                            }
                            catch (IOException e) {
                                throw new InternalGemFireException("Unknown error serializing message", e);
                            }
                        }
                        if (ce != null) {
                            retryInfo = ce;
                            ce = null;
                        }
                        if (!directReply || sentCons.isEmpty()) break block55;
                        long readAckStart = 0L;
                        if (stats != null) {
                            readAckStart = stats.startReplyWait();
                        }
                        try {
                            ce = this.readAcks(sentCons, startTime, ackTimeout, ackSDTimeout, ce, directMsg.getDirectReplyProcessor());
                        }
                        finally {
                            if (stats != null) {
                                stats.endReplyWait(readAckStart, startTime);
                            }
                        }
                    }
                    finally {
                        if (sendingToGroup) {
                            this.releaseGroupSendPermission(orderedMsg);
                        } else if (permissionCon != null) {
                            permissionCon.releaseSendPermission();
                        }
                    }
                }
                if (ce != null) {
                    if (retryInfo != null) {
                        retryInfo.getMembers().addAll(ce.getMembers());
                        retryInfo.getCauses().addAll(ce.getCauses());
                    } else {
                        retryInfo = ce;
                    }
                    ce = null;
                }
                if (retryInfo == null) continue;
                this.conduit.getCancelCriterion().checkCancelInProgress(null);
            } while (retryInfo != null);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            for (Connection con : totalSentCons) {
                con.setInUse(false, 0L, 0L, 0L, null);
            }
        }
        if (failedCe != null) {
            throw failedCe;
        }
        return bytesWritten;
    }

    private ConnectExceptions readAcks(List sentCons, long startTime, long ackTimeout, long ackSDTimeout, ConnectExceptions cumulativeExceptions, DirectReplyProcessor processor) {
        ConnectExceptions ce = cumulativeExceptions;
        for (Connection con : sentCons) {
            long msInterval;
            if (con.isSharedResource()) continue;
            int msToWait = (int)(ackTimeout - (System.currentTimeMillis() - startTime));
            if (msToWait <= 0) {
                msToWait = 10;
            }
            if ((msInterval = ackSDTimeout) <= 0L) {
                msInterval = Math.max(ackTimeout, 1000L);
            }
            try {
                try {
                    con.readAck(msToWait, msInterval, processor);
                }
                catch (SocketTimeoutException ex) {
                    this.handleAckTimeout(ackTimeout, ackSDTimeout, con, processor);
                }
            }
            catch (ConnectionException conEx) {
                if (ce == null) {
                    ce = new ConnectExceptions();
                }
                ce.addFailure(con.getRemoteAddress(), conEx);
            }
        }
        return ce;
    }

    private ConnectExceptions getConnections(MembershipManager mgr, DistributionMessage msg, InternalDistributedMember[] destinations, boolean preserveOrder, boolean retry, long ackTimeout, long ackSDTimeout, List cons) {
        ConnectExceptions ce = null;
        for (int i = 0; i < destinations.length; ++i) {
            InternalDistributedMember destination = destinations[i];
            if (destination == null || this.localAddr.equals(destination)) continue;
            if (!mgr.memberExists(destination) || mgr.shutdownInProgress() || mgr.isShunned(destination)) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "Not a member: {}", (Object)destination);
                }
                if (ce == null) {
                    ce = new ConnectExceptions();
                }
                ce.addFailure(destination, new ShunnedMemberException(LocalizedStrings.DirectChannel_SHUNNING_0.toLocalizedString(destination)));
                continue;
            }
            try {
                long startTime = 0L;
                if (ackTimeout > 0L) {
                    startTime = System.currentTimeMillis();
                }
                Connection con = this.conduit.getConnection(destination, preserveOrder, retry, startTime, ackTimeout, ackSDTimeout);
                con.setInUse(true, startTime, 0L, 0L, null);
                cons.add(con);
                if (!con.isSharedResource() || !(msg instanceof DirectReplyMessage)) continue;
                DirectReplyMessage directMessage = (DirectReplyMessage)((Object)msg);
                directMessage.registerProcessor();
                continue;
            }
            catch (IOException ex) {
                if (ce == null) {
                    ce = new ConnectExceptions();
                }
                ce.addFailure(destination, ex);
            }
        }
        return ce;
    }

    public int send(MembershipManager mgr, InternalDistributedMember[] destinations, DistributionMessage msg, long ackWaitThreshold, long ackSAThreshold) throws ConnectExceptions, NotSerializableException {
        if (this.disconnected) {
            if (logger.isDebugEnabled()) {
                logger.debug("Returning from DirectChannel send because channel is disconnected: {}", (Object)msg);
            }
            return 0;
        }
        if (destinations == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Returning from DirectChannel send because null set passed in: {}", (Object)msg);
            }
            return 0;
        }
        if (destinations.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Returning from DirectChannel send because empty destinations passed in {}", (Object)msg);
            }
            return 0;
        }
        msg.setSender(this.localAddr);
        if (destinations.length == 1) {
            return this.sendToOne(mgr, destinations, msg, ackWaitThreshold, ackSAThreshold);
        }
        return this.sendToMany(mgr, destinations, msg, ackWaitThreshold, ackSAThreshold);
    }

    public DMStats getDMStats() {
        DM dm = this.getDM();
        if (dm != null) {
            return dm.getStats();
        }
        return null;
    }

    public DistributionConfig getDMConfig() {
        DM dm = this.getDM();
        if (dm != null) {
            return dm.getConfig();
        }
        return null;
    }

    public DM getDM() {
        return this.receiver.getDM();
    }

    private void handleAckTimeout(long ackTimeout, long ackSATimeout, Connection c, DirectReplyProcessor processor) throws ConnectionException {
        DM dm = this.getDM();
        Set activeMembers = dm.getDistributionManagerIds();
        dm.getStats().incReplyTimeouts();
        StringId msg = LocalizedStrings.DirectChannel_0_SECONDS_HAVE_ELAPSED_WHILE_WAITING_FOR_REPLY_FROM_1_ON_2_WHOSE_CURRENT_MEMBERSHIP_LIST_IS_3;
        Object[] msgArgs = new Object[]{ackTimeout / 1000L, c.getRemoteAddress(), dm.getId(), activeMembers};
        logger.warn((Message)LocalizedMessage.create(msg, msgArgs));
        msgArgs[3] = "(omitted)";
        Breadcrumbs.setProblem(msg, msgArgs);
        if (ReplyProcessor21.THROW_EXCEPTION_ON_TIMEOUT) {
            TimeoutException cause = new TimeoutException(LocalizedStrings.TIMED_OUT_WAITING_FOR_ACKS.toLocalizedString());
            throw new InternalGemFireException(msg.toLocalizedString(msgArgs), cause);
        }
        if (activeMembers.contains(c.getRemoteAddress())) {
            if (ackSATimeout > 0L) {
                try {
                    c.readAck((int)ackSATimeout, ackSATimeout, processor);
                    return;
                }
                catch (SocketTimeoutException e) {
                    Object[] args = new Object[]{(ackSATimeout + ackTimeout) / 1000L, c.getRemoteAddress(), dm.getId(), activeMembers};
                    logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.DirectChannel_0_SECONDS_HAVE_ELAPSED_WHILE_WAITING_FOR_REPLY_FROM_1_ON_2_WHOSE_CURRENT_MEMBERSHIP_LIST_IS_3, args));
                }
            }
            try {
                c.readAck(0, 0L, processor);
            }
            catch (SocketTimeoutException ex) {
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.DirectChannel_UNEXPECTED_TIMEOUT_WHILE_WAITING_FOR_ACK_FROM__0, c.getRemoteAddress()), (Throwable)ex);
            }
        } else {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DirectChannel_VIEW_NO_LONGER_HAS_0_AS_AN_ACTIVE_MEMBER_SO_WE_WILL_NO_LONGER_WAIT_FOR_IT, c.getRemoteAddress()));
            processor.memberDeparted(c.getRemoteAddress(), true);
        }
    }

    public void receive(DistributionMessage msg, int bytesRead) {
        block5: {
            if (this.disconnected) {
                return;
            }
            try {
                this.receiver.messageReceived(msg);
            }
            catch (MemberShunnedException e) {
                throw e;
            }
            catch (CancelException e) {
            }
            catch (Exception ex) {
                if (this.conduit.getCancelCriterion().isCancelInProgress()) break block5;
                logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.DirectChannel_WHILE_PULLING_A_MESSAGE), (Throwable)ex);
            }
        }
    }

    public InternalDistributedMember getLocalAddress() {
        return this.localAddr;
    }

    public static void loadEmergencyClasses() {
        TCPConduit.loadEmergencyClasses();
    }

    public void emergencyClose() {
        this.conduit.emergencyClose();
    }

    public synchronized void disconnect(Exception cause) {
        this.disconnected = true;
        this.disconnectCompleted = false;
        try {
            this.groupOrderedSenderSem.release();
        }
        catch (Error error) {
            // empty catch block
        }
        try {
            this.groupUnorderedSenderSem.release();
        }
        catch (Error error) {
            // empty catch block
        }
        this.conduit.stop(cause);
        this.disconnectCompleted = true;
    }

    public boolean isOpen() {
        return !this.disconnectCompleted;
    }

    protected DirectChannelListener getReceiver() {
        return this.receiver;
    }

    public int getPort() {
        return this.conduit.getPort();
    }

    public TCPConduit getConduit() {
        return this.conduit;
    }

    private InetAddress initAddress(DistributionConfig dc) {
        String bindAddress = dc.getBindAddress();
        try {
            if (bindAddress != null && bindAddress.length() > 0) {
                return InetAddress.getByName(bindAddress);
            }
            return SocketCreator.getLocalHost();
        }
        catch (UnknownHostException unhe) {
            throw new RuntimeException(unhe);
        }
    }

    public void closeEndpoint(InternalDistributedMember member, String reason) {
        this.closeEndpoint(member, reason, true);
    }

    public void closeEndpoint(InternalDistributedMember member, String reason, boolean notifyDisconnect) {
        TCPConduit tc = this.conduit;
        if (tc != null) {
            tc.removeEndpoint(member, reason, notifyDisconnect);
        }
    }

    public void getChannelStates(DistributedMember member, Map result) {
        TCPConduit tc = this.conduit;
        if (tc != null) {
            tc.getThreadOwnedOrderedConnectionState(member, result);
        }
    }

    public void waitForChannelState(DistributedMember member, Map channelState) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        TCPConduit tc = this.conduit;
        if (tc != null) {
            tc.waitForThreadOwnedOrderedConnectionState(member, channelState);
        }
    }

    public boolean hasReceiversFor(DistributedMember mbr) {
        return this.conduit.hasReceiversFor(mbr);
    }

    public void beSick() {
        TCPConduit tc = this.conduit;
        if (tc != null) {
            tc.beSick();
        }
    }

    public void beHealthy() {
        TCPConduit tc = this.conduit;
        if (tc != null) {
            tc.beHealthy();
        }
    }
}

