/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.NotSerializableException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.MembershipManager;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class DistributionChannel {
    private static final Logger logger = LogService.getLogger();
    private MembershipManager membershipManager;

    public DistributionChannel(MembershipManager channel) {
        this.membershipManager = channel;
    }

    public InternalDistributedMember getLocalAddress() {
        return this.membershipManager.getLocalMember();
    }

    public MembershipManager getMembershipManager() {
        return this.membershipManager;
    }

    public Set send(InternalDistributedMember[] destinations, DistributionMessage content, DistributionManager dm, DistributionStats stats) throws NotSerializableException {
        if (this.membershipManager == null) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DistributionChannel_ATTEMPTING_A_SEND_TO_A_DISCONNECTED_DISTRIBUTIONMANAGER));
            if (destinations.length == 1 && destinations[0] == DistributionMessage.ALL_RECIPIENTS) {
                return null;
            }
            HashSet<InternalDistributedMember> result = new HashSet<InternalDistributedMember>();
            for (int i = 0; i < destinations.length; ++i) {
                result.add(destinations[i]);
            }
            return result;
        }
        return this.membershipManager.send(destinations, content, stats);
    }

    public void disconnect(boolean duringStartup) {
        StringBuffer sb = new StringBuffer();
        sb.append("Disconnected from distribution channel ");
        long start = System.currentTimeMillis();
        logger.debug("DistributionChannel disconnecting with " + this.membershipManager + "; duringStartup=" + duringStartup);
        if (this.membershipManager != null) {
            sb.append(this.membershipManager.getLocalMember());
            sb.append(" (took ");
            long begin = System.currentTimeMillis();
            if (duringStartup) {
                this.membershipManager.uncleanShutdown("Failed to start distribution", null);
            } else {
                this.membershipManager.shutdown();
            }
            long delta = System.currentTimeMillis() - begin;
            sb.append(delta);
            sb.append("/");
        }
        this.membershipManager = null;
        if (logger.isTraceEnabled(LogMarker.DM)) {
            long delta = System.currentTimeMillis() - start;
            sb.append(delta);
            sb.append(" ms)");
            logger.trace(LogMarker.DM, (CharSequence)sb);
        }
    }

    public long getId() {
        MembershipManager mgr = this.membershipManager;
        if (mgr == null) {
            throw new DistributedSystemDisconnectedException(LocalizedStrings.DistributionChannel_I_NO_LONGER_HAVE_A_MEMBERSHIP_ID.toLocalizedString());
        }
        InternalDistributedMember moi = mgr.getLocalMember();
        if (moi == null) {
            throw new DistributedSystemDisconnectedException(LocalizedStrings.DistributionChannel_I_NO_LONGER_HAVE_A_MEMBERSHIP_ID.toLocalizedString(), this.membershipManager.getShutdownCause());
        }
        return moi.getPort();
    }

    public void setShutDown() {
        if (this.membershipManager != null) {
            this.membershipManager.setShutdown();
        }
    }
}

