/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.utils;

import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.internal.cache.VMCachedDeserializable;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.internal.PdxString;

public class PDXUtils {
    public static Object convertPDX(Object obj, boolean isStruct, boolean getDomainObjectForPdx, boolean getDeserializedObject, boolean localResults, boolean[] objectChangedMarker, boolean isDistinct) {
        objectChangedMarker[0] = false;
        if (isStruct) {
            StructImpl simpl = (StructImpl)obj;
            if (getDomainObjectForPdx) {
                try {
                    if (simpl.isHasPdx()) {
                        obj = simpl.getPdxFieldValues();
                        objectChangedMarker[0] = true;
                    }
                    obj = simpl.getFieldValues();
                }
                catch (Exception ex) {
                    throw new CacheException("Unable to retrieve domain object from PdxInstance while building the ResultSet. " + ex.getMessage()){};
                }
            } else {
                int i;
                Object[] values = simpl.getFieldValues();
                if (getDeserializedObject) {
                    for (i = 0; i < values.length; ++i) {
                        if (!(values[i] instanceof VMCachedDeserializable)) continue;
                        values[i] = ((VMCachedDeserializable)values[i]).getDeserializedForReading();
                    }
                }
                if (simpl.isHasPdx() && isDistinct && localResults) {
                    for (i = 0; i < values.length; ++i) {
                        if (!(values[i] instanceof PdxString)) continue;
                        values[i] = ((PdxString)values[i]).toString();
                    }
                }
                obj = values;
            }
        } else {
            if (getDomainObjectForPdx) {
                if (obj instanceof PdxInstance) {
                    try {
                        obj = ((PdxInstance)obj).getObject();
                        objectChangedMarker[0] = true;
                    }
                    catch (Exception ex) {
                        throw new CacheException("Unable to retrieve domain object from PdxInstance while building the ResultSet. " + ex.getMessage()){};
                    }
                } else if (obj instanceof PdxString) {
                    obj = ((PdxString)obj).toString();
                }
            } else if (isDistinct && localResults && obj instanceof PdxString) {
                obj = ((PdxString)obj).toString();
            }
            if (getDeserializedObject && obj instanceof VMCachedDeserializable) {
                obj = ((VMCachedDeserializable)obj).getDeserializedForReading();
                objectChangedMarker[0] = true;
            }
        }
        return obj;
    }
}

