/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.cache.query.internal.types.ObjectTypeImpl;
import org.apache.geode.cache.query.internal.types.TypeUtils;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;
import org.apache.geode.internal.i18n.LocalizedStrings;

public final class StructTypeImpl
extends ObjectTypeImpl
implements StructType {
    private static final long serialVersionUID = -6368710865627039204L;
    private String[] fieldNames;
    private ObjectType[] fieldTypes;
    private String[] indexAlternativeFieldNames;

    public StructTypeImpl() {
    }

    public StructTypeImpl(String[] fieldNames) {
        this(fieldNames, null);
    }

    public StructTypeImpl(String[] fieldNames, ObjectType[] fieldTypes) {
        this(Struct.class, fieldNames, fieldTypes);
    }

    public StructTypeImpl(String[] fieldNames, String[] indexAlternativeFieldNames, ObjectType[] fieldTypes) {
        this(Struct.class, fieldNames, fieldTypes);
        this.indexAlternativeFieldNames = indexAlternativeFieldNames;
    }

    public StructTypeImpl(Class clazz, String[] fieldNames, ObjectType[] fieldTypes) {
        super(clazz);
        if (fieldNames == null) {
            throw new IllegalArgumentException(LocalizedStrings.StructTypeImpl_FIELDNAMES_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.fieldNames = fieldNames;
        this.fieldTypes = fieldTypes == null ? new ObjectType[this.fieldNames.length] : fieldTypes;
        for (int i = 0; i < this.fieldTypes.length; ++i) {
            if (this.fieldTypes[i] != null) continue;
            this.fieldTypes[i] = TypeUtils.getObjectType(Object.class);
        }
    }

    @Override
    public ObjectType[] getFieldTypes() {
        return this.fieldTypes;
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public int getFieldIndex(String fieldName) {
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (!this.fieldNames[i].equals(fieldName)) continue;
            return i;
        }
        throw new IllegalArgumentException(LocalizedStrings.StructTypeImpl_FIELDNAME_0_NOT_FOUND.toLocalizedString(fieldName));
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof StructTypeImpl)) {
            return false;
        }
        StructTypeImpl t = (StructTypeImpl)obj;
        return (Arrays.equals(this.fieldNames, t.getFieldNames()) || Arrays.equals(this.indexAlternativeFieldNames, t.getFieldNames())) && Arrays.equals(this.getFieldTypes(), t.getFieldTypes());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.fieldNames) ^ Arrays.hashCode(this.fieldTypes);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("struct<");
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.fieldNames[i] + ":" + this.fieldTypes[i]);
        }
        sb.append('>');
        return sb.toString();
    }

    @Override
    public boolean isCollectionType() {
        return false;
    }

    @Override
    public boolean isMapType() {
        return false;
    }

    @Override
    public boolean isStructType() {
        return true;
    }

    public static StructTypeImpl typeFromStruct(Struct s) {
        if (s instanceof StructImpl) {
            return (StructTypeImpl)s.getStructType();
        }
        return new StructTypeImpl(s.getStructType().getFieldNames(), s.getStructType().getFieldTypes());
    }

    @Override
    public int getDSFID() {
        return -60;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.fieldNames = DataSerializer.readStringArray(in);
        this.fieldTypes = (ObjectType[])DataSerializer.readObjectArray(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeStringArray(this.fieldNames, out);
        DataSerializer.writeObjectArray(this.fieldTypes, out);
    }
}

