/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import java.util.List;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.IndexInvalidException;
import org.apache.geode.cache.query.internal.CompiledIteratorDef;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.index.IndexCreationHelper;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class PrimaryKeyIndexCreationHelper
extends IndexCreationHelper {
    ExecutionContext context = null;
    final Region region;

    public PrimaryKeyIndexCreationHelper(String fromClause, String indexedExpression, String projectionAttributes, Cache cache, ExecutionContext externalContext, IndexManager imgr) throws IndexInvalidException {
        super(fromClause, projectionAttributes, cache);
        this.context = externalContext == null ? new ExecutionContext(null, cache) : externalContext;
        this.context.newScope(1);
        this.region = imgr.region;
        this.prepareFromClause(imgr);
        this.prepareIndexExpression(indexedExpression);
        this.prepareProjectionAttributes(projectionAttributes);
    }

    private void prepareFromClause(IndexManager imgr) throws IndexInvalidException {
        List list = this.compiler.compileFromClause(this.fromClause);
        if (list.size() > 1) {
            throw new IndexInvalidException(LocalizedStrings.PrimaryKeyIndexCreationHelper_THE_FROMCLAUSE_FOR_A_PRIMARY_KEY_INDEX_SHOULD_ONLY_HAVE_ONE_ITERATOR_AND_THE_COLLECTION_MUST_BE_A_REGION_PATH_ONLY.toLocalizedString());
        }
        try {
            CompiledIteratorDef iterDef = (CompiledIteratorDef)list.get(0);
            if (iterDef.getCollectionExpr().getType() != 35) {
                throw new IndexInvalidException(LocalizedStrings.PrimaryKeyIndexCreationHelper_THE_FROMCLAUSE_FOR_A_PRIMARY_KEY_INDEX_SHOULD_BE_A_REGION_PATH_ONLY.toLocalizedString());
            }
            iterDef.computeDependencies(this.context);
            RuntimeIterator rIter = iterDef.getRuntimeIterator(this.context);
            String definition = rIter.getDefinition();
            this.canonicalizedIteratorDefinitions = new String[1];
            this.canonicalizedIteratorDefinitions[0] = definition;
            PartitionedRegion pr = this.context.getPartitionedRegion();
            this.canonicalizedIteratorNames = new String[1];
            String name = null;
            name = pr != null ? pr.getIndexManager().putCanonicalizedIteratorNameIfAbsent(definition) : imgr.putCanonicalizedIteratorNameIfAbsent(definition);
            rIter.setIndexInternalID(name);
            this.canonicalizedIteratorNames = new String[1];
            this.canonicalizedIteratorNames[0] = name;
            this.fromClause = new StringBuffer(definition).append(' ').append(name).toString();
            this.context.bindIterator(rIter);
        }
        catch (IndexInvalidException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IndexInvalidException(e);
        }
    }

    private void prepareIndexExpression(String indexedExpression) throws IndexInvalidException {
        List indexedExprs = this.compiler.compileProjectionAttributes(indexedExpression);
        if (indexedExprs == null || indexedExprs.size() != 1) {
            throw new IndexInvalidException(LocalizedStrings.PrimaryKeyIndexCreationHelper_INVALID_INDEXED_EXPRESSOION_0.toLocalizedString(indexedExpression));
        }
        CompiledValue expr = (CompiledValue)((Object[])indexedExprs.get(0))[1];
        if (expr.getType() == -4) {
            throw new IndexInvalidException(LocalizedStrings.PrimaryKeyIndexCreationHelper_INVALID_INDEXED_EXPRESSOION_0.toLocalizedString(indexedExpression));
        }
        try {
            StringBuffer sb = new StringBuffer();
            expr.generateCanonicalizedExpression(sb, this.context);
            this.indexedExpression = sb.toString();
        }
        catch (Exception e) {
            throw new IndexInvalidException(LocalizedStrings.PrimaryKeyIndexCreationHelper_INVALID_INDEXED_EXPRESSOION_0_N_1.toLocalizedString(indexedExpression, e.getMessage()));
        }
    }

    private void prepareProjectionAttributes(String projectionAttributes) throws IndexInvalidException {
        if (projectionAttributes != null && !projectionAttributes.equals("*")) {
            throw new IndexInvalidException(LocalizedStrings.PrimaryKeyIndexCreationHelper_INVALID_PROJECTION_ATTRIBUTES_0.toLocalizedString(projectionAttributes));
        }
        this.projectionAttributes = projectionAttributes;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public List getIterators() {
        return null;
    }

    @Override
    public CompiledValue getCompiledIndexedExpression() {
        return null;
    }
}

