/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.CancelCriterion;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexExistsException;
import org.apache.geode.cache.query.IndexInvalidException;
import org.apache.geode.cache.query.IndexMaintenanceException;
import org.apache.geode.cache.query.IndexNameConflictException;
import org.apache.geode.cache.query.IndexStatistics;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.MultiIndexCreationException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledPath;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.MapIndexable;
import org.apache.geode.cache.query.internal.NullToken;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.internal.index.AbstractIndex;
import org.apache.geode.cache.query.internal.index.CompactMapRangeIndex;
import org.apache.geode.cache.query.internal.index.CompactRangeIndex;
import org.apache.geode.cache.query.internal.index.FunctionalIndexCreationHelper;
import org.apache.geode.cache.query.internal.index.HashIndex;
import org.apache.geode.cache.query.internal.index.IMQException;
import org.apache.geode.cache.query.internal.index.IndexCreationHelper;
import org.apache.geode.cache.query.internal.index.IndexData;
import org.apache.geode.cache.query.internal.index.IndexProtocol;
import org.apache.geode.cache.query.internal.index.MapRangeIndex;
import org.apache.geode.cache.query.internal.index.PartitionedIndex;
import org.apache.geode.cache.query.internal.index.PrimaryKeyIndex;
import org.apache.geode.cache.query.internal.index.PrimaryKeyIndexCreationHelper;
import org.apache.geode.cache.query.internal.index.RangeIndex;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.logging.log4j.Logger;

public class IndexManager {
    private static final Logger logger = LogService.getLogger();
    public static final int ADD_ENTRY = 1;
    public static final int UPDATE_ENTRY = 2;
    public static final int REMOVE_ENTRY = 3;
    public static final int RECREATE_INDEX = 4;
    protected final Region region;
    private final boolean isOverFlowToDisk;
    private final boolean offHeap;
    private final boolean indexMaintenanceSynchronous;
    private int numCreators = 0;
    private int numUpdatersInProgress = 0;
    private int numUpdatersInWaiting = 0;
    private int iternameCounter = 0;
    private final ConcurrentMap indexes = new ConcurrentHashMap();
    private ConcurrentMap canonicalizedIteratorNameMap = new ConcurrentHashMap();
    private IndexUpdaterThread updater;
    private final int INDEX_MAINTENANCE_BUFFER = Integer.getInteger("gemfire.AsynchIndexMaintenanceThreshold", -1);
    public static boolean JOIN_OPTIMIZATION = !Boolean.getBoolean("gemfire.index.DisableJoinOptimization");
    public static boolean INPLACE_OBJECT_MODIFICATION_FOR_TEST = false;
    public static boolean IS_TEST_LDM = false;
    public static boolean IS_TEST_EXPANSION = false;
    public static final boolean INPLACE_OBJECT_MODIFICATION = Boolean.valueOf(System.getProperty("gemfire.index.INPLACE_OBJECT_MODIFICATION", "false"));
    public static final boolean RANGEINDEX_ONLY = Boolean.valueOf(System.getProperty("gemfire.index.RANGEINDEX_ONLY", "false"));
    public static boolean TEST_RANGEINDEX_ONLY = false;
    public static final String INDEX_ELEMARRAY_THRESHOLD_PROP = "index_elemarray_threshold";
    public static final String INDEX_ELEMARRAY_SIZE_PROP = "index_elemarray_size";
    public static final int INDEX_ELEMARRAY_THRESHOLD = Integer.parseInt(System.getProperty("index_elemarray_threshold", "100"));
    public static final int INDEX_ELEMARRAY_SIZE = Integer.parseInt(System.getProperty("index_elemarray_size", "5"));
    public static final AtomicLong SAFE_QUERY_TIME = new AtomicLong(0L);
    public static boolean ENABLE_UPDATE_IN_PROGRESS_INDEX_CALCULATION = true;
    public static final Object NULL = new NullToken();
    public static TestHook testHook;

    public IndexManager(Region region) {
        this.region = region;
        this.indexMaintenanceSynchronous = region.getAttributes().getIndexMaintenanceSynchronous();
        this.isOverFlowToDisk = region.getAttributes().getEvictionAttributes().getAction().isOverflowToDisk();
        this.offHeap = region.getAttributes().getOffHeap();
        if (!this.indexMaintenanceSynchronous) {
            LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup("QueryMonitor Thread Group", logger);
            this.updater = new IndexUpdaterThread(group, this.INDEX_MAINTENANCE_BUFFER, "OqlIndexUpdater:" + region.getFullPath());
            this.updater.start();
        }
    }

    public static boolean setIndexBufferTime(long operationTime, long currentCacheTime) {
        long timeDifference = currentCacheTime - operationTime;
        return IndexManager.setNewLargestValue(SAFE_QUERY_TIME, currentCacheTime + timeDifference);
    }

    public static void resetIndexBufferTime() {
        SAFE_QUERY_TIME.set(0L);
    }

    public static boolean needsRecalculation(long queryStartTime, long lastModifiedTime) {
        return ENABLE_UPDATE_IN_PROGRESS_INDEX_CALCULATION && queryStartTime <= SAFE_QUERY_TIME.get() - queryStartTime + lastModifiedTime;
    }

    private static boolean setNewLargestValue(AtomicLong value, long newValue) {
        boolean done = false;
        while (!done) {
            long oldValue = value.get();
            if (oldValue < newValue) {
                return value.compareAndSet(oldValue, newValue);
            }
            done = true;
        }
        return false;
    }

    public Region getRegion() {
        return this.region;
    }

    public IndexUpdaterThread getUpdaterThread() {
        return this.updater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index createIndex(String indexName, IndexType indexType, String origIndexedExpression, String origFromClause, String imports, ExecutionContext externalContext, PartitionedIndex prIndex, boolean loadEntries) throws IndexNameConflictException, IndexExistsException, IndexInvalidException {
        if (QueryMonitor.isLowMemory()) {
            throw new IndexInvalidException(LocalizedStrings.IndexCreationMsg_CANCELED_DUE_TO_LOW_MEMORY.toLocalizedString());
        }
        boolean oldReadSerialized = DefaultQuery.getPdxReadSerialized();
        DefaultQuery.setPdxReadSerialized(this.region.getCache(), true);
        TXStateProxy tx = null;
        if (!((GemFireCacheImpl)this.region.getCache()).isClient()) {
            tx = ((TXManagerImpl)this.region.getCache().getCacheTransactionManager()).internalSuspend();
        }
        try {
            Index index;
            block40: {
                String projectionAttributes = "*";
                if (this.getIndex(indexName) != null) {
                    throw new IndexNameConflictException(LocalizedStrings.IndexManager_INDEX_NAMED_0_ALREADY_EXISTS.toLocalizedString(indexName));
                }
                IndexCreationHelper helper = null;
                boolean isCompactOrHash = false;
                if (indexType == IndexType.HASH && this.isOverFlowRegion()) {
                    indexType = IndexType.FUNCTIONAL;
                }
                if (indexType != IndexType.PRIMARY_KEY) {
                    helper = new FunctionalIndexCreationHelper(origFromClause, origIndexedExpression, projectionAttributes, imports, this.region.getCache(), externalContext, this);
                    isCompactOrHash = this.shouldCreateCompactIndex((FunctionalIndexCreationHelper)helper);
                } else if (indexType == IndexType.PRIMARY_KEY) {
                    helper = new PrimaryKeyIndexCreationHelper(origFromClause, origIndexedExpression, projectionAttributes, this.region.getCache(), externalContext, this);
                } else {
                    throw new AssertionError((Object)("Don't know how to set helper for " + indexType));
                }
                if (!isCompactOrHash && indexType != IndexType.PRIMARY_KEY) {
                    if (indexType == IndexType.HASH) {
                        if (!this.isIndexMaintenanceTypeSynchronous()) {
                            throw new UnsupportedOperationException(LocalizedStrings.DefaultQueryService_HASH_INDEX_CREATION_IS_NOT_SUPPORTED_FOR_ASYNC_MAINTENANCE.toLocalizedString());
                        }
                        throw new UnsupportedOperationException(LocalizedStrings.DefaultQueryService_HASH_INDEX_CREATION_IS_NOT_SUPPORTED_FOR_MULTIPLE_ITERATORS.toLocalizedString());
                    }
                    if (this.isOverFlowRegion()) {
                        throw new UnsupportedOperationException(LocalizedStrings.DefaultQueryService_INDEX_CREATION_IS_NOT_SUPPORTED_FOR_REGIONS_WHICH_OVERFLOW_TO_DISK_THE_REGION_INVOLVED_IS_0.toLocalizedString(this.region.getFullPath()));
                    }
                    if (this.isOffHeap()) {
                        if (!this.isIndexMaintenanceTypeSynchronous()) {
                            throw new UnsupportedOperationException(LocalizedStrings.DefaultQueryService_OFF_HEAP_INDEX_CREATION_IS_NOT_SUPPORTED_FOR_ASYNC_MAINTENANCE_THE_REGION_IS_0.toLocalizedString(this.region.getFullPath()));
                        }
                        throw new UnsupportedOperationException(LocalizedStrings.DefaultQueryService_OFF_HEAP_INDEX_CREATION_IS_NOT_SUPPORTED_FOR_MULTIPLE_ITERATORS_THE_REGION_IS_0.toLocalizedString(this.region.getFullPath()));
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Started creating index with indexName: {} On region: {}", (Object)indexName, (Object)this.region.getFullPath());
                }
                if (testHook != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("IndexManager TestHook is set.");
                    }
                    if (((LocalRegion)this.region).isInitialized()) {
                        testHook.hook(1);
                    } else {
                        testHook.hook(0);
                    }
                }
                IndexTask indexTask = new IndexTask(indexName, indexType, origFromClause, origIndexedExpression, helper, isCompactOrHash, prIndex, loadEntries);
                FutureTask<Index> indexFutureTask = new FutureTask<Index>(indexTask);
                FutureTask<Index> oldIndex = this.indexes.putIfAbsent(indexTask, indexFutureTask);
                index = null;
                boolean interrupted = false;
                try {
                    if (oldIndex == null) {
                        indexFutureTask.run();
                        index = indexFutureTask.get();
                        break block40;
                    }
                    if (!(oldIndex instanceof Index)) {
                        oldIndex.get();
                    }
                    if (this.getIndex(indexName) != null) {
                        throw new IndexNameConflictException(LocalizedStrings.IndexManager_INDEX_NAMED_0_ALREADY_EXISTS.toLocalizedString(indexName));
                    }
                    throw new IndexExistsException(LocalizedStrings.IndexManager_SIMILAR_INDEX_EXISTS.toLocalizedString());
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
                catch (ExecutionException ee) {
                    Throwable c = ee.getCause();
                    if (c instanceof IndexNameConflictException) {
                        throw (IndexNameConflictException)c;
                    }
                    if (c instanceof IndexExistsException) {
                        throw (IndexExistsException)c;
                    }
                    if (c instanceof IMQException) {
                        throw new IndexInvalidException(c.getMessage());
                    }
                    throw new IndexInvalidException(ee);
                }
                finally {
                    Object ind;
                    if (oldIndex == null && index == null && (ind = this.indexes.get(indexTask)) != null && !(ind instanceof Index)) {
                        this.indexes.remove(indexTask);
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            assert (index != null);
            if (logger.isDebugEnabled()) {
                logger.debug("Completed creating index with indexName: {} On region: {}", (Object)indexName, (Object)this.region.getFullPath());
            }
            Index index2 = index;
            return index2;
        }
        finally {
            DefaultQuery.setPdxReadSerialized(this.region.getCache(), oldReadSerialized);
            if (tx != null) {
                ((TXManagerImpl)this.region.getCache().getCacheTransactionManager()).resume(tx);
            }
        }
    }

    private boolean shouldCreateCompactIndex(FunctionalIndexCreationHelper helper) {
        List iterators;
        int nodeType;
        if (RANGEINDEX_ONLY || TEST_RANGEINDEX_ONLY) {
            return false;
        }
        if (!this.getRegion().getAttributes().getIndexMaintenanceSynchronous()) {
            return false;
        }
        CompiledValue cv = helper.getCompiledIndexedExpression();
        do {
            if ((nodeType = cv.getType()) != -5) continue;
            cv = ((CompiledPath)cv).getReceiver();
        } while (nodeType == -5);
        if (nodeType != 34 && nodeType != 53) {
            if (nodeType == 24 && !helper.isMapTypeIndex() && helper.modifiedIndexExpr instanceof MapIndexable) {
                if (((MapIndexable)((Object)helper.modifiedIndexExpr)).getIndexingKeys().size() != 1) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if ((iterators = helper.getIterators()).size() != 1) {
            return false;
        }
        CompiledValue missingLink = helper.missingLink;
        if (helper.isFirstIteratorRegionEntry) {
            return true;
        }
        if (!(missingLink instanceof CompiledPath)) {
            return false;
        }
        String tailId = ((CompiledPath)missingLink).getTailID();
        return tailId.equals("value") || tailId.equals("key");
    }

    public Index getIndex(String indexName) {
        IndexTask indexTask = new IndexTask(indexName);
        Object ind = this.indexes.get(indexTask);
        if (ind instanceof Index) {
            return (Index)ind;
        }
        return null;
    }

    public void addIndex(String indexName, Index index) {
        IndexTask indexTask = new IndexTask(indexName);
        this.indexes.put(indexTask, index);
    }

    public IndexData getIndex(IndexType indexType, String[] definitions, CompiledValue indexedExpression, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        IndexData indxData = null;
        int qItrSize = definitions.length;
        Iterator it = this.indexes.values().iterator();
        StringBuffer sb = new StringBuffer();
        indexedExpression.generateCanonicalizedExpression(sb, context);
        String indexExprStr = sb.toString();
        while (it.hasNext()) {
            int matchLevel;
            int[] mapping = new int[qItrSize];
            Object ind = it.next();
            if (!(ind instanceof Index)) continue;
            Index index = (Index)ind;
            if (!((IndexProtocol)ind).isMatchingWithIndexExpression(indexedExpression, indexExprStr, context) || index.getType() != indexType || (matchLevel = IndexManager.getMatchLevel(definitions, ((IndexProtocol)index).getCanonicalizedIteratorDefinitions(), mapping)) != 0) continue;
            indxData = new IndexData((IndexProtocol)index, 0, mapping);
            break;
        }
        return indxData;
    }

    public int compareIndexData(IndexType indexType, String[] indexDefinitions, String indexExpression, IndexType otherType, String[] otherDefinitions, String otherExpression, int[] mapping) {
        int matchLevel = -2;
        if (indexExpression.equals(otherExpression) && indexType == otherType) {
            matchLevel = IndexManager.getMatchLevel(otherDefinitions, indexDefinitions, mapping);
        }
        return matchLevel;
    }

    public IndexData getBestMatchIndex(IndexType indexType, String[] definitions, CompiledValue indexedExpression, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        int qItrSize;
        Index bestIndex = null;
        PartitionedIndex bestPRIndex = null;
        int[] bestMapping = null;
        int bestIndexMatchLevel = qItrSize = definitions.length;
        Iterator iter = this.indexes.values().iterator();
        StringBuffer sb = new StringBuffer();
        indexedExpression.generateCanonicalizedExpression(sb, context);
        String indexExprStr = sb.toString();
        PartitionedIndex prIndex = null;
        PartitionedIndex prevBestPRIndex = null;
        Index prevBestIndex = null;
        while (iter.hasNext()) {
            Index index;
            block12: {
                Object ind = iter.next();
                if (ind instanceof FutureTask || !((AbstractIndex)ind).isPopulated() || (index = (Index)ind) instanceof PartitionedIndex && (index = (prIndex = (PartitionedIndex)index).getBucketIndex()) == null || !((IndexProtocol)index).isMatchingWithIndexExpression(indexedExpression, indexExprStr, context) || index.getType() != indexType) continue;
                if (prIndex != null) {
                    try {
                        if (!prIndex.acquireIndexReadLockForRemove()) continue;
                        prIndex.verifyAndCreateMissingIndex(context.getBucketList());
                        break block12;
                    }
                    catch (Exception ex) {
                        prIndex.releaseIndexReadLockForRemove();
                        prIndex = null;
                        continue;
                    }
                }
                if (!((AbstractIndex)index).acquireIndexReadLockForRemove()) continue;
            }
            String[] indexDefinitions = ((IndexProtocol)index).getCanonicalizedIteratorDefinitions();
            int[] mapping = new int[qItrSize];
            int matchLevel = IndexManager.getMatchLevel(definitions, indexDefinitions, mapping);
            if (matchLevel == 0) {
                prevBestPRIndex = bestPRIndex;
                bestPRIndex = prIndex;
                prevBestIndex = bestIndex;
                bestIndex = index;
                bestIndexMatchLevel = matchLevel;
                bestMapping = mapping;
                if (prIndex != null && prevBestPRIndex != null && prevBestPRIndex instanceof PartitionedIndex) {
                    prevBestPRIndex.releaseIndexReadLockForRemove();
                    prevBestPRIndex = null;
                    break;
                }
                if (prevBestIndex == null) break;
                ((AbstractIndex)prevBestIndex).releaseIndexReadLockForRemove();
                prevBestIndex = null;
                break;
            }
            if (bestIndexMatchLevel > 0 && matchLevel < bestIndexMatchLevel || bestIndexMatchLevel < 0 && matchLevel < 0 && matchLevel > bestIndexMatchLevel) {
                prevBestPRIndex = bestPRIndex;
                bestPRIndex = prIndex;
                prevBestIndex = bestIndex;
                bestIndex = index;
                bestIndexMatchLevel = matchLevel;
                bestMapping = mapping;
            }
            if (prIndex != null && bestPRIndex != prIndex) {
                prIndex.releaseIndexReadLockForRemove();
                prIndex = null;
            } else if (bestIndex != index) {
                ((AbstractIndex)index).releaseIndexReadLockForRemove();
                index = null;
            }
            if (prevBestPRIndex != null && prevBestPRIndex instanceof PartitionedIndex) {
                prevBestPRIndex.releaseIndexReadLockForRemove();
                prevBestPRIndex = null;
                continue;
            }
            if (prevBestIndex == null) continue;
            ((AbstractIndex)prevBestIndex).releaseIndexReadLockForRemove();
            prevBestIndex = null;
        }
        if (bestIndex != null && logger.isDebugEnabled()) {
            logger.debug("The best index found for index expression: {} is: {} with Match-level: {} and mapping: {}", (Object)indexExprStr, bestIndex, (Object)bestIndexMatchLevel, (Object)Arrays.toString(bestMapping));
        }
        return bestIndex != null ? new IndexData((IndexProtocol)bestIndex, bestIndexMatchLevel, bestMapping) : null;
    }

    private static int getMatchLevel(String[] queryDefintions, String[] indexDefinitions, int[] mapping) {
        int qItrLen = queryDefintions.length;
        int indxItrLen = indexDefinitions.length;
        mapping[0] = 1;
        int matchLevel = qItrLen - 1;
        block0: for (int i = 1; i < qItrLen; ++i) {
            for (int j = 1; j < indxItrLen; ++j) {
                if (!queryDefintions[i].equals(indexDefinitions[j])) continue;
                mapping[i] = ++j;
                --matchLevel;
                continue block0;
            }
        }
        if (matchLevel == 0 && indxItrLen > qItrLen) {
            matchLevel = qItrLen - indxItrLen;
        }
        return matchLevel;
    }

    public Collection getIndexes(IndexType indexType) {
        ArrayList<Index> list = new ArrayList<Index>();
        for (Object ind : this.indexes.values()) {
            if (ind instanceof FutureTask) continue;
            Index index = (Index)ind;
            if (indexType == null) {
                list.add(index);
                continue;
            }
            if (index.getType() != indexType) continue;
            list.add(index);
        }
        return list;
    }

    public Collection getIndexes() {
        return this.getIndexes(null);
    }

    public void removeIndex(Index index) {
        if (index.getRegion() != this.region) {
            throw new IllegalArgumentException(LocalizedStrings.IndexManager_INDEX_DOES_NOT_BELONG_TO_THIS_INDEXMANAGER.toLocalizedString());
        }
        IndexTask indexTask = new IndexTask(index.getName());
        if (this.indexes.remove(indexTask) != null) {
            AbstractIndex indexHandle = (AbstractIndex)index;
            indexHandle.destroy();
        }
    }

    public int removeIndexes() {
        int numIndexes = 0;
        for (Map.Entry entry : this.indexes.entrySet()) {
            Object ind = entry.getValue();
            if (!(ind instanceof Index)) continue;
            ++numIndexes;
            IndexTask indexTask = (IndexTask)entry.getKey();
            this.indexes.remove(indexTask);
        }
        return numIndexes;
    }

    public void rerunIndexCreationQuery() throws QueryException {
        block4: {
            try {
                QueryObserver observer = QueryObserverHolder.getInstance();
                observer.beforeRerunningIndexCreationQuery();
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("IndexMananger::rerunIndexCreationQuery: Exception in callback beforeRerunningIndexcreationQuery", (Throwable)e);
            }
        }
        if (this.isIndexMaintenanceTypeSynchronous()) {
            this.recreateAllIndexesForRegion();
        } else {
            this.updater.addTask(4, null, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateIndexes(Collection<Index> indexSet) throws MultiIndexCreationException {
        this.waitBeforeUpdate();
        if (this.region.getCache().getLogger().infoEnabled()) {
            this.region.getCache().getLogger().info("Populating indexes for region " + this.region.getName());
        }
        boolean throwException = false;
        HashMap<String, Exception> exceptionsMap = new HashMap<String, Exception>();
        try {
            Iterator<RegionEntry> entryIter = ((LocalRegion)this.region).getBestIterator(true);
            while (entryIter.hasNext()) {
                RegionEntry entry = entryIter.next();
                if (entry == null || entry.isInvalidOrRemoved()) continue;
                entry.getValue((LocalRegion)this.region);
                Iterator<Index> indexSetIterator = indexSet.iterator();
                while (indexSetIterator.hasNext()) {
                    AbstractIndex index = (AbstractIndex)indexSetIterator.next();
                    if (index.isPopulated() || index.getType() == IndexType.PRIMARY_KEY) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Adding to index :{}{} value :{}", (Object)index.getName(), (Object)this.region.getFullPath(), entry.getKey());
                    }
                    long start = index.updateIndexUpdateStats();
                    try {
                        index.addIndexMapping(entry);
                    }
                    catch (IMQException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Adding to index failed for: {}, {}", (Object)index.getName(), (Object)e.getMessage(), (Object)e);
                        }
                        exceptionsMap.put(index.indexName, e);
                        indexSetIterator.remove();
                        throwException = true;
                    }
                    index.updateIndexUpdateStats(start);
                }
            }
            this.setPopulateFlagForIndexes(indexSet);
            if (throwException) {
                throw new MultiIndexCreationException(exceptionsMap);
            }
        }
        finally {
            this.notifyAfterUpdate();
        }
    }

    public void setPopulateFlagForIndexes(Collection<Index> indexSet) {
        for (Index ind : indexSet) {
            AbstractIndex index = (AbstractIndex)ind;
            if (index.isPopulated()) continue;
            index.setPopulated(true);
        }
    }

    public void updateIndexes(RegionEntry entry, int action, int opCode) throws QueryException {
        this.updateIndexes(entry, action, opCode, false);
    }

    public void updateIndexes(RegionEntry entry, int action, int opCode, boolean isDiskRecoveryInProgress) throws QueryException {
        if (isDiskRecoveryInProgress ? !$assertionsDisabled && ((LocalRegion)this.region).isInitialized() : !$assertionsDisabled && !Assert.assertHoldsLock(entry, true)) {
            throw new AssertionError();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("IndexManager.updateIndexes {} + action: {}", entry.getKey(), (Object)action);
        }
        if (entry == null) {
            return;
        }
        if (this.isIndexMaintenanceTypeSynchronous()) {
            this.processAction(entry, action, opCode);
        } else {
            this.updater.addTask(action, entry, opCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAction(RegionEntry entry, int action, int opCode) throws QueryException {
        long startPA = this.getCachePerfStats().startIndexUpdate();
        DefaultQuery.setPdxReadSerialized(this.region.getCache(), true);
        TXStateProxy tx = null;
        if (!((GemFireCacheImpl)this.region.getCache()).isClient()) {
            tx = ((TXManagerImpl)this.region.getCache().getCacheTransactionManager()).internalSuspend();
        }
        try {
            if (testHook != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("IndexManager TestHook is set.");
                }
                testHook.hook(6);
            }
            long start = 0L;
            boolean indexLockAcquired = false;
            switch (action) {
                case 1: {
                    if (testHook != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("IndexManager TestHook in ADD_ENTRY.");
                        }
                        testHook.hook(5);
                    }
                    assert (opCode == 0);
                    for (Object ind : this.indexes.values()) {
                        IndexProtocol index;
                        if (ind instanceof FutureTask || !((AbstractIndex)(index = (IndexProtocol)ind)).isPopulated() || index.getType() == IndexType.PRIMARY_KEY || index.containsEntry(entry)) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Adding to index: {}{} value: {}", (Object)index.getName(), (Object)this.region.getFullPath(), entry.getKey());
                        }
                        start = ((AbstractIndex)index).updateIndexUpdateStats();
                        index.addIndexMapping(entry);
                        ((AbstractIndex)index).updateIndexUpdateStats(start);
                    }
                    break;
                }
                case 2: {
                    if (testHook != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("IndexManager TestHook in UPDATE_ENTRY.");
                        }
                        testHook.hook(5);
                        testHook.hook(9);
                    }
                    assert (opCode == 2);
                    for (Object ind : this.indexes.values()) {
                        IndexProtocol index;
                        if (ind instanceof FutureTask || !((AbstractIndex)(index = (IndexProtocol)ind)).isPopulated() || index.getType() == IndexType.PRIMARY_KEY) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Updating index: {}{} value: ", (Object)index.getName(), (Object)this.region.getFullPath(), entry.getKey());
                        }
                        start = ((AbstractIndex)index).updateIndexUpdateStats();
                        index.addIndexMapping(entry);
                        ((AbstractIndex)index).updateIndexUpdateStats(start);
                    }
                    break;
                }
                case 3: {
                    if (testHook != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("IndexManager TestHook in REMOVE_ENTRY.");
                        }
                        testHook.hook(5);
                        testHook.hook(10);
                    }
                    for (Object ind : this.indexes.values()) {
                        IndexProtocol index;
                        if (ind instanceof FutureTask || !((AbstractIndex)(index = (IndexProtocol)ind)).isPopulated() || index.getType() == IndexType.PRIMARY_KEY) continue;
                        AbstractIndex abstractIndex = (AbstractIndex)index;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Removing from index: {}{} value: {}", (Object)index.getName(), (Object)this.region.getFullPath(), entry.getKey());
                        }
                        start = ((AbstractIndex)index).updateIndexUpdateStats();
                        index.removeIndexMapping(entry, opCode);
                        ((AbstractIndex)index).updateIndexUpdateStats(start);
                    }
                    break;
                }
                default: {
                    throw new IndexMaintenanceException(LocalizedStrings.IndexManager_INVALID_ACTION.toLocalizedString());
                }
            }
        }
        finally {
            DefaultQuery.setPdxReadSerialized(this.region.getCache(), false);
            if (tx != null) {
                ((TXManagerImpl)this.region.getCache().getCacheTransactionManager()).resume(tx);
            }
            this.getCachePerfStats().endIndexUpdate(startPA);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitBeforeUpdate() {
        ConcurrentMap concurrentMap = this.indexes;
        synchronized (concurrentMap) {
            ++this.numCreators;
            while (this.numUpdatersInProgress > 0) {
                ((LocalRegion)this.getRegion()).getCancelCriterion().checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    this.indexes.wait();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAfterUpdate() {
        ConcurrentMap concurrentMap = this.indexes;
        synchronized (concurrentMap) {
            --this.numCreators;
            if (this.numCreators == 0 && this.numUpdatersInWaiting > 0) {
                this.indexes.notifyAll();
            }
        }
    }

    private void recreateAllIndexesForRegion() {
        long start = 0L;
        this.waitBeforeUpdate();
        try {
            for (Object ind : this.indexes.values()) {
                IndexProtocol index;
                if (ind instanceof FutureTask || (index = (IndexProtocol)ind).getType() != IndexType.FUNCTIONAL && index.getType() != IndexType.HASH) continue;
                AbstractIndex aIndex = (AbstractIndex)index;
                start = ((AbstractIndex)index).updateIndexUpdateStats();
                ((AbstractIndex)index).recreateIndexData();
                ((AbstractIndex)index).updateIndexUpdateStats(start);
            }
        }
        catch (Exception e) {
            throw new IndexInvalidException(e);
        }
        finally {
            this.notifyAfterUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForIndexInit() {
        ConcurrentMap concurrentMap = this.indexes;
        synchronized (concurrentMap) {
            ++this.numUpdatersInWaiting;
            while (this.numCreators > 0) {
                ((LocalRegion)this.getRegion()).getCancelCriterion().checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    this.indexes.wait();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                }
            }
            --this.numUpdatersInWaiting;
            ++this.numUpdatersInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countDownIndexUpdaters() {
        ConcurrentMap concurrentMap = this.indexes;
        synchronized (concurrentMap) {
            --this.numUpdatersInProgress;
            if (this.numUpdatersInProgress == 0 && this.numCreators > 0) {
                this.indexes.notifyAll();
            }
        }
    }

    private CachePerfStats getCachePerfStats() {
        return ((LocalRegion)this.region).getCachePerfStats();
    }

    public void destroy() throws QueryException {
        this.indexes.clear();
        if (!this.isIndexMaintenanceTypeSynchronous()) {
            this.updater.shutdown();
        }
    }

    public void removeBucketIndexes(PartitionedRegion prRegion) throws QueryException {
        IndexManager parentManager = prRegion.getIndexManager();
        if (parentManager != null) {
            for (Index bucketIndex : this.indexes.values()) {
                Index prIndex = parentManager.getIndex(bucketIndex.getName());
                if (!(prIndex instanceof PartitionedIndex)) continue;
                ((PartitionedIndex)prIndex).removeFromBucketIndexes(this.region, bucketIndex);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Object ind : this.indexes.values()) {
            if (ind instanceof FutureTask) continue;
            sb.append(((Index)ind).toString()).append('\n');
        }
        return sb.toString();
    }

    public boolean isIndexMaintenanceTypeSynchronous() {
        return this.indexMaintenanceSynchronous;
    }

    public boolean isOverFlowRegion() {
        return this.isOverFlowToDisk;
    }

    public boolean isOffHeap() {
        return this.offHeap;
    }

    public static boolean isObjectModificationInplace() {
        return INPLACE_OBJECT_MODIFICATION || INPLACE_OBJECT_MODIFICATION_FOR_TEST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putCanonicalizedIteratorNameIfAbsent(String definition) {
        String str = null;
        ConcurrentMap concurrentMap = this.canonicalizedIteratorNameMap;
        synchronized (concurrentMap) {
            String temp;
            str = (String)this.canonicalizedIteratorNameMap.get(definition);
            if (str == null && (temp = this.canonicalizedIteratorNameMap.putIfAbsent(definition, str = new StringBuffer("index_iter").append(this.getIncrementedCounter()).toString())) != null) {
                str = temp;
            }
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCanonicalizedIteratorName(String definition, String name) {
        ConcurrentMap concurrentMap = this.canonicalizedIteratorNameMap;
        synchronized (concurrentMap) {
            this.canonicalizedIteratorNameMap.put(definition, name);
        }
    }

    private synchronized int getIncrementedCounter() {
        return ++this.iternameCounter;
    }

    public String getCanonicalizedIteratorName(String definition) {
        return (String)this.canonicalizedIteratorNameMap.get(definition);
    }

    public class IndexTask
    implements Callable<Index> {
        public String indexName;
        public IndexType indexType;
        public IndexCreationHelper helper;
        public String origFromClause;
        public String origIndexedExpression;
        public boolean isCompactOrHash = false;
        public boolean isLDM = false;
        public PartitionedIndex prIndex;
        public boolean loadEntries;

        IndexTask(String indexName, IndexType type, String origFromClause, String origIndexedExpression, IndexCreationHelper helper, boolean isCompactOrHash, PartitionedIndex prIndex, boolean loadEntries) {
            this.indexName = indexName;
            this.indexType = type;
            this.origFromClause = origFromClause;
            this.origIndexedExpression = origIndexedExpression;
            this.helper = helper;
            this.isCompactOrHash = isCompactOrHash;
            this.prIndex = prIndex;
            this.loadEntries = loadEntries;
        }

        IndexTask(String indexName) {
            this.indexName = indexName;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            IndexTask otherIndexTask = (IndexTask)other;
            if (this.indexName.equals(otherIndexTask.indexName)) {
                return true;
            }
            if (otherIndexTask.helper == null || this.helper == null) {
                return false;
            }
            String[] indexDefinitions = this.helper.getCanonicalizedIteratorDefinitions();
            int[] mapping = new int[indexDefinitions.length];
            return IndexManager.this.compareIndexData(this.indexType, indexDefinitions, this.helper.getCanonicalizedIndexedExpression(), otherIndexTask.indexType, otherIndexTask.helper.getCanonicalizedIteratorDefinitions(), otherIndexTask.helper.getCanonicalizedIndexedExpression(), mapping) == 0;
        }

        public int hashCode() {
            return 99;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Index call() {
            FunctionalIndexCreationHelper fich;
            AbstractIndex index = null;
            String indexedExpression = this.helper.getCanonicalizedIndexedExpression();
            String fromClause = this.helper.getCanonicalizedFromClause();
            String projectionAttributes = this.helper.getCanonicalizedProjectionAttributes();
            String[] definitions = this.helper.getCanonicalizedIteratorDefinitions();
            IndexStatistics stats = null;
            this.isLDM = IS_TEST_LDM;
            if (this.prIndex != null) {
                stats = this.prIndex.getStatistics();
            }
            if (this.indexType == IndexType.PRIMARY_KEY) {
                index = new PrimaryKeyIndex(this.indexName, IndexManager.this.region, fromClause, indexedExpression, projectionAttributes, this.origFromClause, this.origIndexedExpression, definitions, stats);
                logger.info("Using Primary Key index implementation for '{}' on region {}", (Object)this.indexName, (Object)IndexManager.this.region.getFullPath());
            } else if (this.indexType == IndexType.HASH) {
                index = new HashIndex(this.indexName, IndexManager.this.region, fromClause, indexedExpression, projectionAttributes, this.origFromClause, this.origIndexedExpression, definitions, stats);
                logger.info("Using Hash index implementation for '{}' on region {}", (Object)this.indexName, (Object)IndexManager.this.region.getFullPath());
            } else if (this.isCompactOrHash || this.isLDM) {
                if (this.indexType == IndexType.FUNCTIONAL && !this.helper.isMapTypeIndex()) {
                    index = new CompactRangeIndex(this.indexName, IndexManager.this.region, fromClause, indexedExpression, projectionAttributes, this.origFromClause, this.origIndexedExpression, definitions, stats);
                    logger.info("Using Compact Range index implementation for '{}' on region {}", (Object)this.indexName, (Object)IndexManager.this.region.getFullPath());
                } else {
                    fich = (FunctionalIndexCreationHelper)this.helper;
                    index = new CompactMapRangeIndex(this.indexName, IndexManager.this.region, fromClause, indexedExpression, projectionAttributes, this.origFromClause, this.origIndexedExpression, definitions, fich.isAllKeys(), fich.multiIndexKeysPattern, fich.mapKeys, stats);
                    logger.info("Using Compact Map Range index implementation for '{}' on region {}", (Object)this.indexName, (Object)IndexManager.this.region.getFullPath());
                }
            } else {
                assert (this.indexType == IndexType.FUNCTIONAL);
                if (!this.helper.isMapTypeIndex()) {
                    index = new RangeIndex(this.indexName, IndexManager.this.region, fromClause, indexedExpression, projectionAttributes, this.origFromClause, this.origIndexedExpression, definitions, stats);
                    logger.info("Using Non-Compact index implementation for '{}' on region {}", (Object)this.indexName, (Object)IndexManager.this.region.getFullPath());
                } else {
                    fich = (FunctionalIndexCreationHelper)this.helper;
                    index = new MapRangeIndex(this.indexName, IndexManager.this.region, fromClause, indexedExpression, projectionAttributes, this.origFromClause, this.origIndexedExpression, definitions, fich.isAllKeys(), fich.multiIndexKeysPattern, fich.mapKeys, stats);
                    logger.info("Using Non-Compact Map index implementation for '{}' on region {}", (Object)this.indexName, (Object)IndexManager.this.region.getFullPath());
                }
            }
            ((AbstractIndex)index).setPRIndex(this.prIndex);
            if (index.getType() != IndexType.PRIMARY_KEY) {
                AbstractIndex aIndex = index;
                aIndex.instantiateEvaluator(this.helper);
                IndexManager.this.waitBeforeUpdate();
                boolean indexCreatedSuccessfully = false;
                try {
                    ((LocalRegion)IndexManager.this.region).setFlagForIndexCreationThread(true);
                    aIndex.initializeIndex(this.loadEntries);
                    logger.info(this.loadEntries ? "Initialized and loaded entries into the index " : "Initialized but entries not yet loaded into the index " + this.indexName + " on region: " + IndexManager.this.region.getFullPath());
                    aIndex.markValid(true);
                    indexCreatedSuccessfully = true;
                    if (this.loadEntries) {
                        aIndex.setPopulated(true);
                        if (this.prIndex != null) {
                            this.prIndex.setPopulated(true);
                        }
                    }
                    IndexManager.this.indexes.put(this, index);
                    if (!(IndexManager.this.region instanceof BucketRegion) || this.prIndex == null) return index;
                    this.prIndex.addToBucketIndexes(IndexManager.this.region, index);
                    this.prIndex.incNumBucketIndexes();
                    return index;
                }
                catch (Exception e) {
                    throw new IndexInvalidException(e);
                }
                finally {
                    IndexManager.this.notifyAfterUpdate();
                    ((LocalRegion)IndexManager.this.region).setFlagForIndexCreationThread(false);
                    if (!indexCreatedSuccessfully) {
                        ((AbstractIndex.InternalIndexStatistics)index.getStatistics()).close();
                    }
                }
            } else {
                ((AbstractIndex)index).setPopulated(true);
                IndexManager.this.indexes.put(this, index);
                if (IndexManager.this.region instanceof BucketRegion && this.prIndex != null) {
                    this.prIndex.addToBucketIndexes(IndexManager.this.region, index);
                }
                if (this.prIndex == null) return index;
                this.prIndex.setPopulated(true);
            }
            return index;
        }
    }

    public class IndexUpdaterThread
    extends Thread {
        private volatile boolean running;
        private volatile boolean shutdownRequested;
        private volatile BlockingQueue pendingTasks;

        IndexUpdaterThread(ThreadGroup group, int updateThreshold, String threadName) {
            super(group, threadName);
            this.running = true;
            this.shutdownRequested = false;
            this.pendingTasks = updateThreshold > 0 ? new ArrayBlockingQueue(updateThreshold) : new LinkedBlockingQueue();
            this.setDaemon(true);
        }

        public void addTask(int action, RegionEntry entry, int opCode) {
            Object[] task = new Object[]{action, entry, opCode};
            this.pendingTasks.add(task);
        }

        public void shutdown() {
            if (!this.running) {
                return;
            }
            this.shutdownRequested = true;
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            CancelCriterion stopper = ((LocalRegion)IndexManager.this.region).getCancelCriterion();
            try {
                while (!this.shutdownRequested) {
                    SystemFailure.checkFailure();
                    if (stopper.isCancelInProgress()) {
                        return;
                    }
                    try {
                        Object[] task = (Object[])this.pendingTasks.take();
                        if (this.shutdownRequested) {
                            return;
                        }
                        this.updateIndexes(task);
                    }
                    catch (InterruptedException ignore) {
                        this.running = false;
                        return;
                    }
                }
            }
            finally {
                this.running = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateIndexes(Object[] task) {
            int action = (Integer)task[0];
            RegionEntry entry = (RegionEntry)task[1];
            int opCode = (Integer)task[2];
            if (entry != null || action == 4) {
                try {
                    if (action == 4) {
                        IndexManager.this.recreateAllIndexesForRegion();
                    } else {
                        if (entry != null) {
                            entry.setUpdateInProgress(true);
                        }
                        IndexManager.this.processAction(entry, action, opCode);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (entry != null && action != 4) {
                        entry.setUpdateInProgress(false);
                    }
                }
            }
        }

        public synchronized boolean isDone() {
            return this.pendingTasks.size() == 0;
        }
    }

    public static interface TestHook {
        public void hook(int var1) throws RuntimeException;
    }
}

