/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.internal.types.ObjectTypeImpl;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.i18n.LocalizedStrings;

public final class ResultsSet
extends HashSet
implements SelectResults,
DataSerializableFixedID {
    private static final long serialVersionUID = -5423281031630216824L;
    private ObjectType elementType;

    public ResultsSet() {
    }

    ResultsSet(Collection c) {
        super(c);
    }

    public ResultsSet(SelectResults sr) {
        super(sr);
        this.setElementType(sr.getCollectionType().getElementType());
    }

    public ResultsSet(ObjectType elementType) {
        this.setElementType(elementType);
    }

    ResultsSet(ObjectType elementType, int initialCapacity) {
        super(initialCapacity);
        this.setElementType(elementType);
    }

    ResultsSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    ResultsSet(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public void setElementType(ObjectType elementType) {
        if (elementType instanceof StructType) {
            throw new IllegalArgumentException(LocalizedStrings.ResultsSet_THIS_COLLECTION_DOES_NOT_SUPPORT_STRUCT_ELEMENTS.toLocalizedString());
        }
        this.elementType = elementType;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ResultsSet)) {
            return false;
        }
        if (!this.elementType.equals(((ResultsSet)other).elementType)) {
            return false;
        }
        return super.equals(other);
    }

    public List asList() {
        return new ArrayList(this);
    }

    public Set asSet() {
        return this;
    }

    @Override
    public CollectionType getCollectionType() {
        return new CollectionTypeImpl(Set.class, this.elementType);
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    public int occurrences(Object element) {
        return this.contains(element) ? 1 : 0;
    }

    @Override
    public int getDSFID() {
        return 28;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        ObjectTypeImpl clt = new ObjectTypeImpl();
        InternalDataSerializer.invokeFromData(clt, in);
        this.setElementType(clt);
        for (int k = size; k > 0; --k) {
            this.add(DataSerializer.readObject(in));
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.size());
        ObjectTypeImpl ctImpl = (ObjectTypeImpl)this.getCollectionType().getElementType();
        Assert.assertTrue(ctImpl != null, "ctImpl can not be null");
        InternalDataSerializer.invokeToData(ctImpl, out);
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            DataSerializer.writeObject(itr.next(), out);
        }
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

