/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheRuntimeException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.client.internal.ProxyCache;
import org.apache.geode.cache.client.internal.ServerProxy;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryStatistics;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledIteratorDef;
import org.apache.geode.cache.query.internal.CompiledSelect;
import org.apache.geode.cache.query.internal.CompiledSortCriterion;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.IndexTrackingQueryObserver;
import org.apache.geode.cache.query.internal.QCompiler;
import org.apache.geode.cache.query.internal.QueryExecutionCanceledException;
import org.apache.geode.cache.query.internal.QueryExecutionContext;
import org.apache.geode.cache.query.internal.QueryExecutor;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.internal.ResultsCollectionCopyOnReadWrapper;
import org.apache.geode.cache.query.internal.ResultsCollectionPdxDeserializerWrapper;
import org.apache.geode.cache.query.internal.cq.InternalCqQuery;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalDataSet;
import org.apache.geode.internal.cache.PRQueryProcessor;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class DefaultQuery
implements Query {
    private final CompiledValue compiledQuery;
    private final String queryString;
    private final Cache cache;
    private ServerProxy serverProxy;
    protected AtomicLong numExecutions = new AtomicLong(0L);
    protected AtomicLong totalExecutionTime = new AtomicLong(0L);
    private QueryStatistics stats;
    private boolean isCompiled = false;
    private boolean traceOn = false;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    public static boolean QUERY_VERBOSE = Boolean.getBoolean("gemfire.Query.VERBOSE");
    public static final int COMPILED_QUERY_CLEAR_TIME = Integer.getInteger("gemfire.Query.COMPILED_QUERY_CLEAR_TIME", 600000);
    public static int TEST_COMPILED_QUERY_CLEAR_TIME = -1;
    public static final Object NULL_RESULT = new Object();
    private volatile boolean isCanceled = false;
    private CacheRuntimeException canceledException;
    private final boolean[] queryCompletedForMonitoring = new boolean[]{false};
    private ProxyCache proxyCache;
    private boolean isCqQuery = false;
    private boolean isQueryWithFunctionContext = false;
    private InternalCqQuery cqQuery = null;
    private volatile boolean lastUsed = true;
    public static TestHook testHook;
    private static final ThreadLocal<Boolean> pdxReadSerialized;
    private boolean isRemoteQuery = false;
    private boolean keepSerialized = false;
    public static final Set<String> reservedKeywords;
    private static final ThreadLocal<Map<String, Set<String>>> pdxClassToFieldsMap;
    private static final ThreadLocal<Map<String, Set<String>>> pdxClassToMethodsMap;

    public static void setPdxClasstofieldsmap(Map<String, Set<String>> map) {
        pdxClassToFieldsMap.set(map);
    }

    public static Map<String, Set<String>> getPdxClasstofieldsmap() {
        return pdxClassToFieldsMap.get();
    }

    public static void setPdxClasstoMethodsmap(Map<String, Set<String>> map) {
        pdxClassToMethodsMap.set(map);
    }

    public static Map<String, Set<String>> getPdxClasstoMethodsmap() {
        return pdxClassToMethodsMap.get();
    }

    public DefaultQuery(String queryString, Cache cache, boolean isForRemote) {
        this.queryString = queryString;
        QCompiler compiler = new QCompiler();
        this.compiledQuery = compiler.compileQuery(queryString);
        CompiledSelect cs = this.getSimpleSelect();
        if (cs != null && !isForRemote && (cs.isGroupBy() || cs.isOrderBy())) {
            QueryExecutionContext ctx = new QueryExecutionContext(null, cache);
            try {
                cs.computeDependencies(ctx);
            }
            catch (QueryException qe) {
                throw new QueryInvalidException("", qe);
            }
        }
        this.traceOn = compiler.isTraceRequested() || QUERY_VERBOSE;
        this.cache = cache;
        this.stats = new DefaultQueryStatistics();
    }

    public static boolean getPdxReadSerialized() {
        return pdxReadSerialized.get();
    }

    public static void setPdxReadSerialized(boolean readSerialized) {
        pdxReadSerialized.set(readSerialized);
    }

    public static void setPdxReadSerialized(Cache cache, boolean readSerialized) {
        if (cache != null && !cache.getPdxReadSerialized()) {
            DefaultQuery.setPdxReadSerialized(readSerialized);
        }
    }

    @Override
    public QueryStatistics getStatistics() {
        return this.stats;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public Object execute() throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.execute(EMPTY_ARRAY);
    }

    @Override
    public Object execute(Object[] parameters) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Object object;
        QueryExecutionContext context;
        QueryMonitor queryMonitor;
        QueryObserver indexObserver;
        Object result;
        long startTime;
        block19: {
            if (parameters == null) {
                throw new IllegalArgumentException(LocalizedStrings.DefaultQuery_PARAMETERS_CANNOT_BE_NULL.toLocalizedString());
            }
            if (this.serverProxy != null) {
                return this.executeOnServer(parameters);
            }
            startTime = 0L;
            result = null;
            if (this.traceOn && this.cache != null) {
                startTime = NanoTimer.getTime();
            }
            indexObserver = null;
            queryMonitor = null;
            QueryExecutor qe = this.checkQueryOnPR(parameters);
            DefaultQuery.setPdxReadSerialized(this.cache, true);
            context = new QueryExecutionContext(parameters, this.cache, this);
            indexObserver = this.startTrace();
            if (qe == null) break block19;
            if (testHook != null) {
                testHook.doTestHook(1);
            }
            result = qe.executeQuery(this, parameters, null);
            if (this.needsPDXDeserializationWrapper(true) && result instanceof SelectResults) {
                result = new ResultsCollectionPdxDeserializerWrapper((SelectResults)result, false);
            }
            Object object2 = result;
            DefaultQuery.setPdxReadSerialized(this.cache, false);
            if (queryMonitor != null) {
                queryMonitor.stopMonitoringQueryThread(Thread.currentThread(), this);
            }
            this.endTrace(indexObserver, startTime, result);
            return object2;
        }
        try {
            boolean needsCopyOnReadWrapper;
            if (GemFireCacheImpl.getInstance() != null) {
                queryMonitor = GemFireCacheImpl.getInstance().getQueryMonitor();
            }
            if (queryMonitor != null) {
                queryMonitor.monitorQueryThread(Thread.currentThread(), this);
            }
            ((ExecutionContext)context).setCqQueryContext(this.isCqQuery);
            result = this.executeUsingContext(context);
            boolean bl = needsCopyOnReadWrapper = this.cache.getCopyOnRead() && !DefaultQueryService.COPY_ON_READ_AT_ENTRY_LEVEL || context.isIndexUsed() && DefaultQueryService.COPY_ON_READ_AT_ENTRY_LEVEL;
            if (this.needsPDXDeserializationWrapper(false) && result instanceof SelectResults) {
                result = new ResultsCollectionPdxDeserializerWrapper((SelectResults)result, needsCopyOnReadWrapper);
            } else if (!this.isRemoteQuery() && this.cache.getCopyOnRead() && result instanceof SelectResults && needsCopyOnReadWrapper) {
                result = new ResultsCollectionCopyOnReadWrapper((SelectResults)result);
            }
            object = result;
        }
        catch (QueryExecutionCanceledException e) {
            try {
                if (this.canceledException != null) {
                    throw this.canceledException;
                }
                throw new QueryExecutionCanceledException("Query was canceled. It may be due to low memory or the query was running longer than the MAX_QUERY_EXECUTION_TIME.");
            }
            catch (Throwable throwable) {
                DefaultQuery.setPdxReadSerialized(this.cache, false);
                if (queryMonitor != null) {
                    queryMonitor.stopMonitoringQueryThread(Thread.currentThread(), this);
                }
                this.endTrace(indexObserver, startTime, result);
                throw throwable;
            }
        }
        DefaultQuery.setPdxReadSerialized(this.cache, false);
        if (queryMonitor != null) {
            queryMonitor.stopMonitoringQueryThread(Thread.currentThread(), this);
        }
        this.endTrace(indexObserver, startTime, result);
        return object;
    }

    public boolean needsPDXDeserializationWrapper(boolean isQueryOnPR) {
        return !this.isRemoteQuery() && !this.cache.getPdxReadSerialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeOnServer(Object[] parameters) {
        long startTime = CachePerfStats.getStatTime();
        SelectResults result = null;
        try {
            if (this.proxyCache != null) {
                if (this.proxyCache.isClosed()) {
                    throw new CacheClosedException("Cache is closed for this user.");
                }
                UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
            }
            result = this.serverProxy.query(this.queryString, parameters);
        }
        finally {
            UserAttributes.userAttributes.set(null);
            long endTime = CachePerfStats.getStatTime();
            this.updateStatistics(endTime - startTime);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object prExecuteOnBucket(Object[] parameters, PartitionedRegion pr, BucketRegion bukRgn) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (parameters == null) {
            parameters = EMPTY_ARRAY;
        }
        long startTime = 0L;
        Object result = null;
        if (this.traceOn && this.cache != null) {
            startTime = NanoTimer.getTime();
        }
        IndexTrackingQueryObserver indexObserver = null;
        String otherObserver = null;
        if (this.traceOn) {
            QueryObserver qo = QueryObserverHolder.getInstance();
            if (qo instanceof IndexTrackingQueryObserver) {
                indexObserver = (IndexTrackingQueryObserver)qo;
            } else if (!QueryObserverHolder.hasObserver()) {
                indexObserver = new IndexTrackingQueryObserver();
                QueryObserverHolder.setInstance(indexObserver);
            } else {
                otherObserver = qo.getClass().getName();
            }
        }
        QueryExecutionContext context = new QueryExecutionContext(parameters, this.cache, this);
        context.setBucketRegion(pr, bukRgn);
        ((ExecutionContext)context).setCqQueryContext(this.isCqQuery);
        QueryMonitor queryMonitor = null;
        if (GemFireCacheImpl.getInstance() != null) {
            queryMonitor = GemFireCacheImpl.getInstance().getQueryMonitor();
        }
        if (queryMonitor != null && PRQueryProcessor.NUM_THREADS > 1) {
            queryMonitor.monitorQueryThread(Thread.currentThread(), this);
        }
        try {
            result = this.executeUsingContext(context);
        }
        finally {
            if (queryMonitor != null && PRQueryProcessor.NUM_THREADS > 1) {
                queryMonitor.stopMonitoringQueryThread(Thread.currentThread(), this);
            }
            int resultSize = 0;
            if (this.traceOn && result instanceof Collection) {
                resultSize = ((Collection)result).size();
            }
            String queryVerboseMsg = DefaultQuery.getLogMessage(indexObserver, startTime, otherObserver, resultSize, this.queryString, bukRgn);
            if (this.traceOn && this.cache != null && this.cache.getLogger().fineEnabled()) {
                this.cache.getLogger().fine(queryVerboseMsg);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeUsingContext(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        QueryObserver observer = QueryObserverHolder.getInstance();
        long startTime = CachePerfStats.getStatTime();
        TXStateProxy tx = null;
        if (!((GemFireCacheImpl)this.cache).isClient()) {
            tx = ((TXManagerImpl)this.cache.getCacheTransactionManager()).internalSuspend();
        }
        try {
            observer.startQuery(this);
            observer.beforeQueryEvaluation(this.compiledQuery, context);
            Object results = null;
            if (testHook != null) {
                testHook.doTestHook(6);
            }
            try {
                this.compiledQuery.computeDependencies(context);
                if (testHook != null) {
                    testHook.doTestHook(1);
                }
                results = this.compiledQuery.evaluate(context);
            }
            catch (QueryExecutionCanceledException e) {
                try {
                    if (this.canceledException != null) {
                        throw this.canceledException;
                    }
                    throw new QueryExecutionCanceledException("Query was canceled. It may be due to low memory or the query was running longer than the MAX_QUERY_EXECUTION_TIME.");
                }
                catch (Throwable throwable) {
                    observer.afterQueryEvaluation(results);
                    throw throwable;
                }
            }
            observer.afterQueryEvaluation(results);
            Object object = results;
            return object;
        }
        finally {
            observer.endQuery();
            long endTime = CachePerfStats.getStatTime();
            this.updateStatistics(endTime - startTime);
            pdxClassToFieldsMap.remove();
            pdxClassToMethodsMap.remove();
            if (tx != null) {
                ((TXManagerImpl)this.cache.getCacheTransactionManager()).resume(tx);
            }
        }
    }

    private QueryExecutor checkQueryOnPR(Object[] parameters) throws RegionNotFoundException {
        ArrayList<QueryExecutor> prs = new ArrayList<QueryExecutor>();
        for (Object regionPath : this.getRegionsInQuery(parameters)) {
            Region rgn = this.cache.getRegion((String)regionPath);
            if (rgn == null) {
                this.cache.getCancelCriterion().checkCancelInProgress(null);
                throw new RegionNotFoundException(LocalizedStrings.DefaultQuery_REGION_NOT_FOUND_0.toLocalizedString(regionPath));
            }
            if (!(rgn instanceof QueryExecutor)) continue;
            prs.add((QueryExecutor)((Object)rgn));
        }
        if (prs.size() == 1) {
            return (QueryExecutor)prs.get(0);
        }
        if (prs.size() > 1) {
            if (!this.isQueryWithFunctionContext()) {
                throw new UnsupportedOperationException(LocalizedStrings.DefaultQuery_A_QUERY_ON_A_PARTITIONED_REGION_0_MAY_NOT_REFERENCE_ANY_OTHER_REGION_1.toLocalizedString(((QueryExecutor)prs.get(0)).getName(), ((QueryExecutor)prs.get(1)).getName()));
            }
            QueryExecutor other = null;
            for (QueryExecutor eachPR : prs) {
                boolean colocated = false;
                for (QueryExecutor allPRs : prs) {
                    if (eachPR == allPRs) continue;
                    other = allPRs;
                    if (!((PartitionedRegion)eachPR).colocatedByList.contains(allPRs) && !((PartitionedRegion)allPRs).colocatedByList.contains(eachPR)) continue;
                    colocated = true;
                    break;
                }
                if (colocated) continue;
                throw new UnsupportedOperationException(LocalizedStrings.DefaultQuery_A_QUERY_ON_A_PARTITIONED_REGION_0_MAY_NOT_REFERENCE_ANY_OTHER_NON_COLOCATED_PARTITIONED_REGION_1.toLocalizedString(eachPR.getName(), other.getName()));
            }
            CompiledSelect select = this.getSimpleSelect();
            if (select == null) {
                throw new UnsupportedOperationException(LocalizedStrings.DefaultQuery_QUERY_MUST_BE_A_SIMPLE_SELECT_WHEN_REFERENCING_A_PARTITIONED_REGION.toLocalizedString());
            }
            HashSet regions = new HashSet();
            CompiledValue whereClause = select.getWhereClause();
            if (whereClause != null) {
                whereClause.getRegionsInQuery(regions, parameters);
                if (!regions.isEmpty()) {
                    throw new UnsupportedOperationException(LocalizedStrings.DefaultQuery_THE_WHERE_CLAUSE_CANNOT_REFER_TO_A_REGION_WHEN_QUERYING_ON_A_PARTITIONED_REGION.toLocalizedString());
                }
            }
            List fromClause = select.getIterators();
            Iterator fromClauseIterator = fromClause.iterator();
            CompiledIteratorDef itrDef = (CompiledIteratorDef)fromClauseIterator.next();
            itrDef.visitNodes(new CompiledValue.NodeVisitor(){

                @Override
                public boolean visit(CompiledValue node) {
                    if (node instanceof CompiledSelect) {
                        throw new UnsupportedOperationException(LocalizedStrings.DefaultQuery_WHEN_QUERYING_A_PARTITIONEDREGION_THE_FIRST_FROM_CLAUSE_ITERATOR_MUST_NOT_CONTAIN_A_SUBQUERY.toLocalizedString());
                    }
                    return true;
                }
            });
            if (!this.isQueryWithFunctionContext()) {
                List<CompiledSortCriterion> orderBys;
                while (fromClauseIterator.hasNext()) {
                    itrDef = (CompiledIteratorDef)fromClauseIterator.next();
                    itrDef.getRegionsInQuery(regions, parameters);
                    if (regions.isEmpty()) continue;
                    throw new UnsupportedOperationException(LocalizedStrings.DefaultQuery_WHEN_QUERYING_A_PARTITIONED_REGION_THE_FROM_CLAUSE_ITERATORS_OTHER_THAN_THE_FIRST_ONE_MUST_NOT_REFERENCE_ANY_REGIONS.toLocalizedString());
                }
                List projs = select.getProjectionAttributes();
                if (projs != null) {
                    for (Object[] rawProj : projs) {
                        CompiledValue compiledValue = (CompiledValue)rawProj[1];
                        compiledValue.getRegionsInQuery(regions, parameters);
                        if (regions.isEmpty()) continue;
                        throw new UnsupportedOperationException(LocalizedStrings.DefaultQuery_WHEN_QUERYING_A_PARTITIONED_REGION_THE_PROJECTIONS_MUST_NOT_REFERENCE_ANY_REGIONS.toLocalizedString());
                    }
                }
                if ((orderBys = select.getOrderByAttrs()) != null) {
                    for (CompiledValue compiledValue : orderBys) {
                        compiledValue.getRegionsInQuery(regions, parameters);
                        if (regions.isEmpty()) continue;
                        throw new UnsupportedOperationException(LocalizedStrings.DefaultQuery_WHEN_QUERYING_A_PARTITIONED_REGION_THE_ORDERBY_ATTRIBUTES_MUST_NOT_REFERENCE_ANY_REGIONS.toLocalizedString());
                    }
                }
            }
            return (QueryExecutor)prs.get(0);
        }
        return null;
    }

    private void updateStatistics(long executionTime) {
        this.numExecutions.incrementAndGet();
        this.totalExecutionTime.addAndGet(executionTime);
        ((GemFireCacheImpl)this.cache).getCachePerfStats().endQueryExecution(executionTime);
    }

    @Override
    public void compile() throws TypeMismatchException, NameResolutionException {
        throw new UnsupportedOperationException(LocalizedStrings.DefaultQuery_NOT_YET_IMPLEMENTED.toLocalizedString());
    }

    @Override
    public boolean isCompiled() {
        return this.isCompiled;
    }

    public boolean isTraced() {
        return this.traceOn;
    }

    public Set getRegionsInQuery(Object[] parameters) {
        HashSet regions = new HashSet();
        this.compiledQuery.getRegionsInQuery(regions, parameters);
        return Collections.unmodifiableSet(regions);
    }

    public CompiledSelect getSimpleSelect() {
        if (this.compiledQuery instanceof CompiledSelect) {
            return (CompiledSelect)this.compiledQuery;
        }
        return null;
    }

    public CompiledSelect getSelect() {
        return (CompiledSelect)this.compiledQuery;
    }

    public int getLimit(Object[] bindArguments) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.compiledQuery instanceof CompiledSelect ? ((CompiledSelect)this.compiledQuery).getLimitValue(bindArguments) : -1;
    }

    public void setServerProxy(ServerProxy serverProxy) {
        this.serverProxy = serverProxy;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public CacheRuntimeException getQueryCanceledException() {
        return this.canceledException;
    }

    public boolean[] getQueryCompletedForMonitoring() {
        return this.queryCompletedForMonitoring;
    }

    public void setQueryCompletedForMonitoring(boolean value) {
        this.queryCompletedForMonitoring[0] = value;
    }

    public void setCanceled(boolean isCanceled, CacheRuntimeException canceledException) {
        this.isCanceled = isCanceled;
        this.canceledException = canceledException;
    }

    public void setIsCqQuery(boolean isCqQuery) {
        this.isCqQuery = isCqQuery;
    }

    public boolean isCqQuery() {
        return this.isCqQuery;
    }

    public void setCqQuery(InternalCqQuery cqQuery) {
        this.cqQuery = cqQuery;
    }

    public void setLastUsed(boolean lastUsed) {
        this.lastUsed = lastUsed;
    }

    public boolean getLastUsed() {
        return this.lastUsed;
    }

    public InternalCqQuery getCqQuery() {
        return this.cqQuery;
    }

    public String toString() {
        StringBuffer tempBuff = new StringBuffer("Query String = ");
        tempBuff.append(this.queryString);
        tempBuff.append(';');
        tempBuff.append("isCancelled = ");
        tempBuff.append(this.isCanceled);
        tempBuff.append("; Total Executions = ");
        tempBuff.append(this.numExecutions);
        tempBuff.append("; Total Execution Time = ");
        tempBuff.append(this.totalExecutionTime);
        return tempBuff.toString();
    }

    void setProxyCache(ProxyCache proxyCache) {
        this.proxyCache = proxyCache;
    }

    public static void setTestCompiledQueryClearTime(int val) {
        TEST_COMPILED_QUERY_CLEAR_TIME = val;
    }

    public static String getLogMessage(QueryObserver observer, long startTime, int resultSize, String query) {
        String usedIndexesString = null;
        String rowCountString = null;
        float time = 0.0f;
        time = (float)(NanoTimer.getTime() - startTime) / 1000000.0f;
        if (observer != null && observer instanceof IndexTrackingQueryObserver) {
            IndexTrackingQueryObserver indexObserver = (IndexTrackingQueryObserver)observer;
            Map usedIndexes = indexObserver.getUsedIndexes();
            indexObserver.reset();
            StringBuffer buf = new StringBuffer();
            buf.append(" indexesUsed(");
            buf.append(usedIndexes.size());
            buf.append(")");
            if (usedIndexes.size() > 0) {
                buf.append(":");
                Iterator itr = usedIndexes.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    buf.append(entry.getKey().toString() + entry.getValue());
                    if (!itr.hasNext()) continue;
                    buf.append(",");
                }
            }
            usedIndexesString = buf.toString();
        } else if (QUERY_VERBOSE) {
            usedIndexesString = " indexesUsed(NA due to other observer in the way: " + observer.getClass().getName() + ")";
        }
        if (resultSize != -1) {
            rowCountString = " rowCount = " + resultSize + ";";
        }
        return "Query Executed in " + time + " ms;" + (rowCountString != null ? rowCountString : "") + (usedIndexesString != null ? usedIndexesString : "") + " \"" + query + "\"";
    }

    public static String getLogMessage(IndexTrackingQueryObserver indexObserver, long startTime, String otherObserver, int resultSize, String query, BucketRegion bucket) {
        String usedIndexesString = null;
        String rowCountString = null;
        float time = 0.0f;
        if (startTime > 0L) {
            time = (float)(NanoTimer.getTime() - startTime) / 1000000.0f;
        }
        if (indexObserver != null) {
            Map usedIndexes = indexObserver.getUsedIndexes(bucket.getFullPath());
            StringBuffer buf = new StringBuffer();
            buf.append(" indexesUsed(");
            buf.append(usedIndexes.size());
            buf.append(")");
            if (usedIndexes.size() > 0) {
                buf.append(":");
                Iterator itr = usedIndexes.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    buf.append(entry.getKey().toString() + "(Results: " + entry.getValue() + ", Bucket: " + bucket.getId() + ")");
                    if (!itr.hasNext()) continue;
                    buf.append(",");
                }
            }
            usedIndexesString = buf.toString();
        } else if (QUERY_VERBOSE) {
            usedIndexesString = " indexesUsed(NA due to other observer in the way: " + otherObserver + ")";
        }
        rowCountString = " rowCount = " + resultSize + ";";
        return "Query Executed" + (startTime > 0L ? " in " + time + " ms;" : ";") + (rowCountString != null ? rowCountString : "") + (usedIndexesString != null ? usedIndexesString : "") + " \"" + query + "\"";
    }

    @Override
    public Object execute(RegionFunctionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.execute(context, EMPTY_ARRAY);
    }

    @Override
    public Object execute(RegionFunctionContext context, Object[] parameters) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        block6: {
            Object result = null;
            if (context == null) {
                throw new IllegalArgumentException(LocalizedStrings.DefaultQuery_FUNCTIONCONTEXT_CANNOT_BE_NULL.toLocalizedString());
            }
            this.isQueryWithFunctionContext = true;
            if (parameters == null) {
                throw new IllegalArgumentException(LocalizedStrings.DefaultQuery_PARAMETERS_CANNOT_BE_NULL.toLocalizedString());
            }
            long startTime = 0L;
            if (this.traceOn && this.cache != null) {
                startTime = NanoTimer.getTime();
            }
            QueryObserver indexObserver = null;
            QueryExecutor qe = this.checkQueryOnPR(parameters);
            try {
                indexObserver = this.startTrace();
                if (qe == null) break block6;
                Set<Integer> buckets = null;
                LocalDataSet localDataSet = (LocalDataSet)PartitionRegionHelper.getLocalDataForContext(context);
                buckets = localDataSet.getBucketSet();
                Object object = result = qe.executeQuery(this, parameters, buckets);
                this.endTrace(indexObserver, startTime, result);
                return object;
            }
            catch (Throwable throwable) {
                this.endTrace(indexObserver, startTime, result);
                throw throwable;
            }
        }
        throw new IllegalArgumentException(LocalizedStrings.DefaultQuery_API_ONLY_FOR_PR.toLocalizedString());
    }

    public boolean isQueryWithFunctionContext() {
        return this.isQueryWithFunctionContext;
    }

    public QueryObserver startTrace() {
        QueryObserver queryObserver = null;
        if (this.traceOn && this.cache != null) {
            QueryObserver qo = QueryObserverHolder.getInstance();
            if (qo instanceof IndexTrackingQueryObserver) {
                queryObserver = qo;
            } else if (!QueryObserverHolder.hasObserver()) {
                queryObserver = new IndexTrackingQueryObserver();
                QueryObserverHolder.setInstance(queryObserver);
            } else {
                queryObserver = qo;
            }
        }
        return queryObserver;
    }

    public void endTrace(QueryObserver indexObserver, long startTime, Object result) {
        if (this.traceOn && this.cache != null) {
            int resultSize = -1;
            if (result instanceof Collection) {
                resultSize = ((Collection)result).size();
            }
            String queryVerboseMsg = DefaultQuery.getLogMessage(indexObserver, startTime, resultSize, this.queryString);
            this.cache.getLogger().info(queryVerboseMsg);
        }
    }

    public void endTrace(QueryObserver indexObserver, long startTime, Collection<Collection> result) {
        if (this.cache != null && this.cache.getLogger().infoEnabled() && this.traceOn) {
            int resultSize = 0;
            Iterator<Collection> iterator = result.iterator();
            while (iterator.hasNext()) {
                resultSize += iterator.next().size();
            }
            String queryVerboseMsg = DefaultQuery.getLogMessage(indexObserver, startTime, resultSize, this.queryString);
            if (this.cache.getLogger().infoEnabled()) {
                this.cache.getLogger().info(queryVerboseMsg);
            }
        }
    }

    public boolean isRemoteQuery() {
        return this.isRemoteQuery;
    }

    public void setRemoteQuery(boolean isRemoteQuery) {
        this.isRemoteQuery = isRemoteQuery;
    }

    public void keepResultsSerialized(CompiledSelect cs, ExecutionContext context) {
        if (this.isRemoteQuery() && cs.getIterators().size() == context.getAllIndependentIteratorsOfCurrentScope().size() && cs.getWhereClause() == null && cs.getProjectionAttributes() == null && !cs.isDistinct() && cs.getOrderByAttrs() == null) {
            this.setKeepSerialized(true);
        }
    }

    public boolean isKeepSerialized() {
        return this.keepSerialized;
    }

    private void setKeepSerialized(boolean keepSerialized) {
        this.keepSerialized = keepSerialized;
    }

    static {
        pdxReadSerialized = new ThreadLocal(){

            protected Boolean initialValue() {
                return new Boolean(Boolean.FALSE);
            }
        };
        reservedKeywords = new HashSet<String>();
        reservedKeywords.add("hint");
        reservedKeywords.add("all");
        reservedKeywords.add("map");
        reservedKeywords.add("count");
        reservedKeywords.add("sum");
        reservedKeywords.add("nvl");
        reservedKeywords.add("unique");
        reservedKeywords.add("except");
        reservedKeywords.add("declare");
        reservedKeywords.add("for");
        reservedKeywords.add("list");
        reservedKeywords.add("min");
        reservedKeywords.add("element");
        reservedKeywords.add("false");
        reservedKeywords.add("abs");
        reservedKeywords.add("true");
        reservedKeywords.add("bag");
        reservedKeywords.add("time");
        reservedKeywords.add("define");
        reservedKeywords.add("and");
        reservedKeywords.add("asc");
        reservedKeywords.add("desc");
        reservedKeywords.add("select");
        reservedKeywords.add("intersect");
        reservedKeywords.add("flatten");
        reservedKeywords.add("float");
        reservedKeywords.add("import");
        reservedKeywords.add("exists");
        reservedKeywords.add("distinct");
        reservedKeywords.add("boolean");
        reservedKeywords.add("string");
        reservedKeywords.add("group");
        reservedKeywords.add("interval");
        reservedKeywords.add("orelse");
        reservedKeywords.add("where");
        reservedKeywords.add("trace");
        reservedKeywords.add("first");
        reservedKeywords.add("set");
        reservedKeywords.add("octet");
        reservedKeywords.add("nil");
        reservedKeywords.add("avg");
        reservedKeywords.add("order");
        reservedKeywords.add("long");
        reservedKeywords.add("limit");
        reservedKeywords.add("mod");
        reservedKeywords.add("type");
        reservedKeywords.add("undefine");
        reservedKeywords.add("in");
        reservedKeywords.add("null");
        reservedKeywords.add("some");
        reservedKeywords.add("to_date");
        reservedKeywords.add("short");
        reservedKeywords.add("enum");
        reservedKeywords.add("timestamp");
        reservedKeywords.add("having");
        reservedKeywords.add("dictionary");
        reservedKeywords.add("char");
        reservedKeywords.add("listtoset");
        reservedKeywords.add("array");
        reservedKeywords.add("union");
        reservedKeywords.add("or");
        reservedKeywords.add("max");
        reservedKeywords.add("from");
        reservedKeywords.add("query");
        reservedKeywords.add("collection");
        reservedKeywords.add("like");
        reservedKeywords.add("date");
        reservedKeywords.add("byte");
        reservedKeywords.add("any");
        reservedKeywords.add("is_undefined");
        reservedKeywords.add("double");
        reservedKeywords.add("int");
        reservedKeywords.add("andthen");
        reservedKeywords.add("last");
        reservedKeywords.add("struct");
        reservedKeywords.add("undefined");
        reservedKeywords.add("is_defined");
        reservedKeywords.add("not");
        reservedKeywords.add("by");
        reservedKeywords.add("as");
        pdxClassToFieldsMap = new ThreadLocal(){

            protected Map<String, Set<String>> initialValue() {
                return new HashMap<String, Set<String>>();
            }
        };
        pdxClassToMethodsMap = new ThreadLocal(){

            protected Map<String, Set<String>> initialValue() {
                return new HashMap<String, Set<String>>();
            }
        };
    }

    public static interface TestHook {
        public void doTestHook(int var1);

        public void doTestHook(String var1);
    }

    class DefaultQueryStatistics
    implements QueryStatistics {
        DefaultQueryStatistics() {
        }

        @Override
        public long getTotalExecutionTime() {
            return DefaultQuery.this.totalExecutionTime.get();
        }

        @Override
        public long getNumExecutions() {
            return DefaultQuery.this.numExecutions.get();
        }
    }
}

