/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.client.internal.ClientMetadataService;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.EndpointManager;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.cache.client.internal.PingOp;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class LiveServerPinger
extends EndpointManager.EndpointListenerAdapter {
    private static final Logger logger = LogService.getLogger();
    private static final long NANOS_PER_MS = 1000000L;
    private final ConcurrentMap taskFutures = new ConcurrentHashMap();
    protected final InternalPool pool;
    protected final long pingIntervalNanos;

    public LiveServerPinger(InternalPool pool) {
        this.pool = pool;
        this.pingIntervalNanos = pool.getPingInterval() * 1000000L;
    }

    @Override
    public void endpointCrashed(Endpoint endpoint) {
        this.cancelFuture(endpoint);
    }

    @Override
    public void endpointNoLongerInUse(Endpoint endpoint) {
        this.cancelFuture(endpoint);
    }

    @Override
    public void endpointNowInUse(Endpoint endpoint) {
        block2: {
            try {
                ScheduledFuture<?> future = this.pool.getBackgroundProcessor().scheduleWithFixedDelay(new PingTask(endpoint), this.pingIntervalNanos, this.pingIntervalNanos, TimeUnit.NANOSECONDS);
                this.taskFutures.put(endpoint, future);
            }
            catch (RejectedExecutionException e) {
                if (this.pool.getCancelCriterion().isCancelInProgress()) break block2;
                throw e;
            }
        }
    }

    private void cancelFuture(Endpoint endpoint) {
        Future future = (Future)this.taskFutures.remove(endpoint);
        if (future != null) {
            future.cancel(false);
        }
    }

    private class PingTask
    extends PoolImpl.PoolTask {
        private final Endpoint endpoint;

        public PingTask(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public void run2() {
            if (this.endpoint.timeToPing(LiveServerPinger.this.pingIntervalNanos)) {
                try {
                    PingOp.execute(LiveServerPinger.this.pool, this.endpoint.getLocation());
                }
                catch (Exception e) {
                    GemFireCacheImpl cache;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Error occured while pinging server: {} - {}", (Object)this.endpoint.getLocation(), (Object)e.getMessage());
                    }
                    if ((cache = GemFireCacheImpl.getInstance()) != null) {
                        ClientMetadataService cms = cache.getClientMetadataService();
                        cms.removeBucketServerLocation(this.endpoint.getLocation());
                    }
                    LiveServerPinger.this.pool.getEndpointManager().serverCrashed(this.endpoint);
                }
            }
        }
    }
}

