/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.GemFireException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ClientMetadataService;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.ExecuteRegionFunctionOp;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.SingleHopClientExecutor;
import org.apache.geode.cache.client.internal.SingleHopOperationCallable;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.BucketMovedException;
import org.apache.geode.internal.cache.execute.FunctionStats;
import org.apache.geode.internal.cache.execute.InternalFunctionException;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.ServerRegionFunctionExecutor;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class ExecuteRegionFunctionSingleHopOp {
    private static final Logger logger = LogService.getLogger();

    private ExecuteRegionFunctionSingleHopOp() {
    }

    public static void execute(ExecutablePool pool, Region region, Function function, ServerRegionFunctionExecutor serverRegionExecutor, ResultCollector resultCollector, byte hasResult, Map<ServerLocation, ? extends HashSet> serverToFilterMap, int mRetryAttempts, boolean allBuckets) {
        boolean reexecute = false;
        HashSet<String> failedNodes = new HashSet<String>();
        int maxRetryAttempts = 0;
        if (function.isHA()) {
            maxRetryAttempts = mRetryAttempts;
        }
        ClientMetadataService cms = ((GemFireCacheImpl)region.getCache()).getClientMetadataService();
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("ExecuteRegionFunctionSingleHopOp#execute : The serverToFilterMap is : {}", serverToFilterMap);
        }
        List<SingleHopOperationCallable> callableTasks = ExecuteRegionFunctionSingleHopOp.constructAndGetExecuteFunctionTasks(region.getFullPath(), serverRegionExecutor, serverToFilterMap, (PoolImpl)pool, function, hasResult, resultCollector, cms, allBuckets);
        reexecute = SingleHopClientExecutor.submitAllHA(callableTasks, (LocalRegion)region, function.isHA(), resultCollector, failedNodes);
        if (isDebugEnabled) {
            logger.debug("ExecuteRegionFunctionSingleHopOp#execute : The size of callableTask is : {}", (Object)callableTasks.size());
        }
        if (reexecute) {
            resultCollector.clearResults();
            if (function.isHA()) {
                ExecuteRegionFunctionOp.reexecute(pool, region.getFullPath(), function, serverRegionExecutor, resultCollector, hasResult, failedNodes, maxRetryAttempts - 1);
            }
        }
        resultCollector.endResults();
    }

    public static void execute(ExecutablePool pool, Region region, String functionId, ServerRegionFunctionExecutor serverRegionExecutor, ResultCollector resultCollector, byte hasResult, Map<ServerLocation, ? extends HashSet> serverToFilterMap, int mRetryAttempts, boolean allBuckets, boolean isHA, boolean optimizeForWrite) {
        boolean reexecute = false;
        HashSet<String> failedNodes = new HashSet<String>();
        int maxRetryAttempts = 0;
        if (isHA) {
            maxRetryAttempts = mRetryAttempts;
        }
        ClientMetadataService cms = ((GemFireCacheImpl)region.getCache()).getClientMetadataService();
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("ExecuteRegionFunctionSingleHopOp#execute : The serverToFilterMap is : {}", serverToFilterMap);
        }
        List<SingleHopOperationCallable> callableTasks = ExecuteRegionFunctionSingleHopOp.constructAndGetExecuteFunctionTasks(region.getFullPath(), serverRegionExecutor, serverToFilterMap, (PoolImpl)pool, functionId, hasResult, resultCollector, cms, allBuckets, isHA, optimizeForWrite);
        reexecute = SingleHopClientExecutor.submitAllHA(callableTasks, (LocalRegion)region, isHA, resultCollector, failedNodes);
        if (isDebugEnabled) {
            logger.debug("ExecuteRegionFunctionSingleHopOp#execute : The size of callableTask is: {}, reexecute={}", (Object)callableTasks.size(), (Object)reexecute);
        }
        if (reexecute) {
            resultCollector.clearResults();
            if (isHA) {
                ExecuteRegionFunctionOp.reexecute(pool, region.getFullPath(), functionId, serverRegionExecutor, resultCollector, hasResult, failedNodes, maxRetryAttempts - 1, isHA, optimizeForWrite);
            }
        }
        resultCollector.endResults();
    }

    static List<SingleHopOperationCallable> constructAndGetExecuteFunctionTasks(String region, ServerRegionFunctionExecutor serverRegionExecutor, Map<ServerLocation, ? extends HashSet> serverToFilterMap, PoolImpl pool, Function function, byte hasResult, ResultCollector rc, ClientMetadataService cms, boolean allBucket) {
        ArrayList<SingleHopOperationCallable> tasks = new ArrayList<SingleHopOperationCallable>();
        ArrayList<ServerLocation> servers = new ArrayList<ServerLocation>(serverToFilterMap.keySet());
        if (logger.isDebugEnabled()) {
            logger.debug("Constructing tasks for the servers {}", servers);
        }
        for (ServerLocation server : servers) {
            ServerRegionFunctionExecutor executor = (ServerRegionFunctionExecutor)serverRegionExecutor.withFilter((Set)serverToFilterMap.get(server));
            ExecuteRegionFunctionSingleHopOpImpl op = new ExecuteRegionFunctionSingleHopOpImpl(region, function, executor, rc, hasResult, new HashSet<String>(), allBucket);
            SingleHopOperationCallable task = new SingleHopOperationCallable(new ServerLocation(server.getHostName(), server.getPort()), pool, op, UserAttributes.userAttributes.get());
            tasks.add(task);
        }
        return tasks;
    }

    static List<SingleHopOperationCallable> constructAndGetExecuteFunctionTasks(String region, ServerRegionFunctionExecutor serverRegionExecutor, Map<ServerLocation, ? extends HashSet> serverToFilterMap, PoolImpl pool, String functionId, byte hasResult, ResultCollector rc, ClientMetadataService cms, boolean allBucket, boolean isHA, boolean optimizeForWrite) {
        ArrayList<SingleHopOperationCallable> tasks = new ArrayList<SingleHopOperationCallable>();
        ArrayList<ServerLocation> servers = new ArrayList<ServerLocation>(serverToFilterMap.keySet());
        if (logger.isDebugEnabled()) {
            logger.debug("Constructing tasks for the servers {}", servers);
        }
        for (ServerLocation server : servers) {
            ServerRegionFunctionExecutor executor = (ServerRegionFunctionExecutor)serverRegionExecutor.withFilter((Set)serverToFilterMap.get(server));
            ExecuteRegionFunctionSingleHopOpImpl op = new ExecuteRegionFunctionSingleHopOpImpl(region, functionId, executor, rc, hasResult, new HashSet<String>(), allBucket, isHA, optimizeForWrite);
            SingleHopOperationCallable task = new SingleHopOperationCallable(new ServerLocation(server.getHostName(), server.getPort()), pool, op, UserAttributes.userAttributes.get());
            tasks.add(task);
        }
        return tasks;
    }

    static class ExecuteRegionFunctionSingleHopOpImpl
    extends AbstractOp {
        private final ResultCollector resultCollector;
        private final String functionId;
        private final String regionName;
        private final ServerRegionFunctionExecutor executor;
        private final byte hasResult;
        private Set<String> failedNodes = new HashSet<String>();
        private boolean isHA;
        private boolean optimizeForWrite;

        public ExecuteRegionFunctionSingleHopOpImpl(String region, Function function, ServerRegionFunctionExecutor serverRegionExecutor, ResultCollector rc, byte hasResult, Set<String> removedNodes, boolean allBuckets) {
            super(79, 8 + serverRegionExecutor.getFilter().size() + removedNodes.size());
            this.isHA = function.isHA();
            this.optimizeForWrite = function.optimizeForWrite();
            byte functionState = AbstractExecution.getFunctionState(function.isHA(), function.hasResult(), function.optimizeForWrite());
            Set routingObjects = serverRegionExecutor.getFilter();
            Object args = serverRegionExecutor.getArguments();
            MemberMappedArgument memberMappedArg = serverRegionExecutor.getMemberMappedArgument();
            this.addBytes(functionState);
            this.getMessage().addStringPart(region);
            if (serverRegionExecutor.isFnSerializationReqd()) {
                this.getMessage().addStringOrObjPart(function);
            } else {
                this.getMessage().addStringOrObjPart(function.getId());
            }
            this.getMessage().addObjPart(args);
            this.getMessage().addObjPart(memberMappedArg);
            this.getMessage().addBytesPart(new byte[]{allBuckets ? (byte)1 : 0});
            this.getMessage().addIntPart(routingObjects.size());
            for (Object e : routingObjects) {
                if (allBuckets) {
                    this.getMessage().addIntPart((Integer)e);
                    continue;
                }
                this.getMessage().addStringOrObjPart(e);
            }
            this.getMessage().addIntPart(removedNodes.size());
            for (Object object : removedNodes) {
                this.getMessage().addStringOrObjPart(object);
            }
            this.resultCollector = rc;
            this.regionName = region;
            this.functionId = function.getId();
            this.executor = serverRegionExecutor;
            this.hasResult = functionState;
            this.failedNodes = removedNodes;
        }

        public ExecuteRegionFunctionSingleHopOpImpl(String region, String functionId, ServerRegionFunctionExecutor serverRegionExecutor, ResultCollector rc, byte hasResult, Set<String> removedNodes, boolean allBuckets, boolean isHA, boolean optimizeForWrite) {
            super(79, 8 + serverRegionExecutor.getFilter().size() + removedNodes.size());
            this.isHA = isHA;
            this.optimizeForWrite = optimizeForWrite;
            Set routingObjects = serverRegionExecutor.getFilter();
            Object args = serverRegionExecutor.getArguments();
            byte functionState = AbstractExecution.getFunctionState(isHA, hasResult == 1, optimizeForWrite);
            MemberMappedArgument memberMappedArg = serverRegionExecutor.getMemberMappedArgument();
            this.addBytes(functionState);
            this.getMessage().addStringPart(region);
            this.getMessage().addStringOrObjPart(functionId);
            this.getMessage().addObjPart(args);
            this.getMessage().addObjPart(memberMappedArg);
            this.getMessage().addBytesPart(new byte[]{allBuckets ? (byte)1 : 0});
            this.getMessage().addIntPart(routingObjects.size());
            for (Object e : routingObjects) {
                if (allBuckets) {
                    this.getMessage().addIntPart((Integer)e);
                    continue;
                }
                this.getMessage().addStringOrObjPart(e);
            }
            this.getMessage().addIntPart(removedNodes.size());
            for (Object object : removedNodes) {
                this.getMessage().addStringOrObjPart(object);
            }
            this.resultCollector = rc;
            this.regionName = region;
            this.functionId = functionId;
            this.executor = serverRegionExecutor;
            this.hasResult = functionState;
            this.failedNodes = removedNodes;
        }

        private void addBytes(byte functionState) {
            if (GemFireCacheImpl.getClientFunctionTimeout() == 0) {
                this.getMessage().addBytesPart(new byte[]{functionState});
            } else {
                byte[] bytes = new byte[5];
                bytes[0] = functionState;
                Part.encodeInt(GemFireCacheImpl.getClientFunctionTimeout(), bytes, 1);
                this.getMessage().addBytesPart(bytes);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object processResponse(Message msg) throws Exception {
            ChunkedMessage executeFunctionResponseMsg = (ChunkedMessage)msg;
            try {
                executeFunctionResponseMsg.readHeader();
                switch (executeFunctionResponseMsg.getMessageType()) {
                    case 60: {
                        Object resultResponse;
                        boolean isDebugEnabled = logger.isDebugEnabled();
                        if (isDebugEnabled) {
                            logger.debug("ExecuteRegionFunctionSingleHopOpImpl#processResponse: received message of type EXECUTE_REGION_FUNCTION_RESULT.");
                        }
                        GemFireException exception = null;
                        do {
                            Object memberID;
                            InternalFunctionInvocationTargetException fite;
                            executeFunctionResponseMsg.receiveChunk();
                            resultResponse = executeFunctionResponseMsg.getPart(0).getObject();
                            Object result = resultResponse instanceof ArrayList ? ((ArrayList)resultResponse).get(0) : resultResponse;
                            if (result instanceof FunctionException) {
                                FunctionException ex = (FunctionException)result;
                                if (isDebugEnabled) {
                                    logger.debug("ExecuteRegionFunctionSingleHopOpImpl#processResponse: received Exception. {}", ex.getCause());
                                }
                                if (ex instanceof InternalFunctionException) {
                                    Throwable cause = ex.getCause();
                                    DistributedMember memberID2 = (DistributedMember)((ArrayList)resultResponse).get(1);
                                    this.resultCollector.addResult(memberID2, cause);
                                    FunctionStats.getFunctionStats(this.functionId, this.executor.getRegion().getSystem()).incResultsReceived();
                                    continue;
                                }
                                if (((FunctionException)result).getCause() instanceof InternalFunctionInvocationTargetException) {
                                    InternalFunctionInvocationTargetException ifite = (InternalFunctionInvocationTargetException)ex.getCause();
                                    this.failedNodes.addAll(ifite.getFailedNodeSet());
                                }
                                if (ex.getMessage().equals("Buckets are null")) continue;
                                exception = ex;
                                continue;
                            }
                            if (result instanceof BucketMovedException) {
                                fite = new InternalFunctionInvocationTargetException(((BucketMovedException)result).getMessage());
                                exception = new FunctionException(fite);
                                continue;
                            }
                            if (result instanceof CacheClosedException) {
                                fite = new InternalFunctionInvocationTargetException(((CacheClosedException)result).getMessage());
                                if (resultResponse instanceof ArrayList) {
                                    memberID = (DistributedMember)((ArrayList)resultResponse).get(1);
                                    this.failedNodes.add(memberID.getId());
                                }
                                exception = new FunctionException(fite);
                                continue;
                            }
                            if (result instanceof Throwable) {
                                String s = "While performing a remote " + this.getOpName();
                                exception = new ServerOperationException(s, (Throwable)result);
                                continue;
                            }
                            DistributedMember memberID3 = (DistributedMember)((ArrayList)resultResponse).get(1);
                            memberID = this.resultCollector;
                            synchronized (memberID) {
                                this.resultCollector.addResult(memberID3, result);
                            }
                            FunctionStats.getFunctionStats(this.functionId, this.executor.getRegion().getSystem()).incResultsReceived();
                        } while (!executeFunctionResponseMsg.isLastChunk());
                        if (exception != null) {
                            throw exception;
                        }
                        if (isDebugEnabled) {
                            logger.debug("ExecuteRegionFunctionSingleHopOpImpl#processResponse: received all the results from server successfully.");
                        }
                        resultResponse = null;
                        return resultResponse;
                    }
                    case 2: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("ExecuteRegionFunctionSingleHopOpImpl#processResponse: received message of type EXCEPTION");
                        }
                        executeFunctionResponseMsg.receiveChunk();
                        Part part0 = executeFunctionResponseMsg.getPart(0);
                        Object obj = part0.getObject();
                        if (obj instanceof FunctionException) {
                            FunctionException ex = (FunctionException)obj;
                            if (((FunctionException)obj).getCause() instanceof InternalFunctionInvocationTargetException) {
                                InternalFunctionInvocationTargetException ifite = (InternalFunctionInvocationTargetException)ex.getCause();
                                this.failedNodes.addAll(ifite.getFailedNodeSet());
                            }
                            if (!ex.getMessage().equals("Buckets are null")) {
                                throw ex;
                            }
                            Object var8_14 = null;
                            return var8_14;
                        }
                        if (obj instanceof Throwable) {
                            String s = "While performing a remote " + this.getOpName();
                            throw new ServerOperationException(s, (Throwable)obj);
                        }
                        break;
                    }
                    case 61: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("ExecuteRegionFunctionSingleHopOpImpl#processResponse: received message of type EXECUTE_REGION_FUNCTION_ERROR");
                        }
                        executeFunctionResponseMsg.receiveChunk();
                        String errorMessage = executeFunctionResponseMsg.getPart(0).getString();
                        throw new ServerOperationException(errorMessage);
                    }
                    default: {
                        throw new InternalGemFireError("Unknown message type " + executeFunctionResponseMsg.getMessageType());
                    }
                }
            }
            finally {
                executeFunctionResponseMsg.clear();
            }
            return null;
        }

        ResultCollector getResultCollector() {
            return this.resultCollector;
        }

        String getFunctionId() {
            return this.functionId;
        }

        String getRegionName() {
            return this.regionName;
        }

        ServerRegionFunctionExecutor getExecutor() {
            return this.executor;
        }

        byte getHasResult() {
            return this.hasResult;
        }

        boolean isHA() {
            return this.isHA;
        }

        boolean optimizeForWrite() {
            return this.optimizeForWrite;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 61;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startExecuteFunction();
        }

        protected String getOpName() {
            return "executeRegionFunctionSingleHop";
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endExecuteFunctionSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endExecuteFunction(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected Message createResponseMessage() {
            return new ChunkedMessage(1, Version.CURRENT);
        }
    }
}

