/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.asyncqueue.internal;

import org.apache.geode.CancelException;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueStats;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.RegionQueue;
import org.apache.geode.internal.cache.UpdateAttributesProcessor;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.GatewaySenderAdvisor;
import org.apache.geode.internal.cache.wan.GatewaySenderAttributes;
import org.apache.geode.internal.cache.wan.GatewaySenderConfigurationException;
import org.apache.geode.internal.cache.wan.serial.ConcurrentSerialGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.serial.SerialGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.serial.SerialGatewaySenderQueue;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class SerialAsyncEventQueueImpl
extends AbstractGatewaySender {
    private static final Logger logger = LogService.getLogger();
    final ThreadGroup loggerGroup = LoggingThreadGroup.createThreadGroup("Remote Site Discovery Logger Group", logger);

    public SerialAsyncEventQueueImpl() {
        this.isParallel = false;
    }

    public SerialAsyncEventQueueImpl(Cache cache, GatewaySenderAttributes attrs) {
        super(cache, attrs);
        if (!(this.cache instanceof CacheCreation)) {
            this.statistics = new AsyncEventQueueStats(cache.getDistributedSystem(), AsyncEventQueueImpl.getAsyncEventQueueIdFromSenderId(this.id));
        }
    }

    @Override
    public void start() {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting gatewaySender : {}", (Object)this);
        }
        this.getLifeCycleLock().writeLock().lock();
        try {
            String locators;
            if (this.isRunning()) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GatewaySender_SENDER_0_IS_ALREADY_RUNNING, this.getId()));
                return;
            }
            if (this.remoteDSId != -1 && (locators = ((GemFireCacheImpl)this.cache).getDistributedSystem().getConfig().getLocators()).length() == 0) {
                throw new GatewaySenderConfigurationException(LocalizedStrings.AbstractGatewaySender_LOCATOR_SHOULD_BE_CONFIGURED_BEFORE_STARTING_GATEWAY_SENDER.toLocalizedString());
            }
            this.getSenderAdvisor().initDLockService();
            if (!this.isPrimary()) {
                if (this.getSenderAdvisor().volunteerForPrimary()) {
                    this.getSenderAdvisor().makePrimary();
                } else {
                    this.getSenderAdvisor().makeSecondary();
                }
            }
            this.eventProcessor = this.getDispatcherThreads() > 1 ? new ConcurrentSerialGatewaySenderEventProcessor(this) : new SerialGatewaySenderEventProcessor(this, this.getId());
            this.eventProcessor.start();
            this.waitForRunningStatus();
            this.startTime = System.currentTimeMillis();
            if (!this.isAsyncEventQueue()) {
                ((GemFireCacheImpl)this.getCache()).getPdxRegistry().gatewaySenderStarted(this);
            }
            new UpdateAttributesProcessor(this).distribute(false);
            InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
            system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_START, this);
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.SerialGatewaySenderImpl_STARTED__0, this));
            this.enqueueTempEvents();
        }
        finally {
            this.getLifeCycleLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping Gateway Sender : {}", (Object)this);
        }
        this.getLifeCycleLock().writeLock().lock();
        try {
            AbstractGatewaySenderEventProcessor ev = this.eventProcessor;
            if (ev != null && !ev.isStopped()) {
                ev.stopProcessing();
            }
            this.stompProxyDead();
            for (AsyncEventListener listener : this.listeners) {
                listener.close();
            }
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.GatewayImpl_STOPPED__0, this));
            this.clearTempEventsAfterSenderStopped();
        }
        finally {
            this.getLifeCycleLock().writeLock().unlock();
        }
        if (this.isPrimary()) {
            try {
                DistributedLockService.destroy(this.getSenderAdvisor().getDLockServiceName());
            }
            catch (IllegalArgumentException ev) {
                // empty catch block
            }
        }
        if (this.getQueues() != null && !this.getQueues().isEmpty()) {
            for (RegionQueue q : this.getQueues()) {
                ((SerialGatewaySenderQueue)q).cleanUp();
            }
        }
        this.setIsPrimary(false);
        try {
            new UpdateAttributesProcessor(this).distribute(false);
        }
        catch (CancelException ev) {
            // empty catch block
        }
        Thread lockObtainingThread = this.getSenderAdvisor().getLockObtainingThread();
        if (lockObtainingThread != null && lockObtainingThread.isAlive()) {
            try {
                lockObtainingThread.join(3000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            if (lockObtainingThread.isAlive()) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.GatewaySender_COULD_NOT_STOP_LOCK_OBTAINING_THREAD_DURING_GATEWAY_SENDER_STOP));
            }
        }
        InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
        system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_STOP, this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SerialGatewaySender{");
        sb.append("id=" + this.getId());
        sb.append(",remoteDsId=" + this.getRemoteDSId());
        sb.append(",isRunning =" + this.isRunning());
        sb.append(",isPrimary =" + this.isPrimary());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile profile) {
        assert (profile instanceof GatewaySenderAdvisor.GatewaySenderProfile);
        GatewaySenderAdvisor.GatewaySenderProfile pf = (GatewaySenderAdvisor.GatewaySenderProfile)profile;
        pf.Id = this.getId();
        pf.startTime = this.getStartTime();
        pf.remoteDSId = this.getRemoteDSId();
        pf.isRunning = this.isRunning();
        pf.isPrimary = this.isPrimary();
        pf.isParallel = false;
        pf.isBatchConflationEnabled = this.isBatchConflationEnabled();
        pf.isPersistenceEnabled = this.isPersistenceEnabled();
        pf.alertThreshold = this.getAlertThreshold();
        pf.manualStart = this.isManualStart();
        for (GatewayEventFilter gatewayEventFilter : this.getGatewayEventFilters()) {
            pf.eventFiltersClassNames.add(gatewayEventFilter.getClass().getName());
        }
        for (GatewayTransportFilter gatewayTransportFilter : this.getGatewayTransportFilters()) {
            pf.transFiltersClassNames.add(gatewayTransportFilter.getClass().getName());
        }
        for (AsyncEventListener asyncEventListener : this.getAsyncEventListeners()) {
            pf.senderEventListenerClassNames.add(asyncEventListener.getClass().getName());
        }
        pf.isDiskSynchronous = this.isDiskSynchronous();
        pf.dispatcherThreads = this.getDispatcherThreads();
        pf.orderPolicy = this.getOrderPolicy();
        pf.serverLocation = this.getServerLocation();
    }

    @Override
    protected void setModifiedEventId(EntryEventImpl clonedEvent) {
        EventID originalEventId = clonedEvent.getEventId();
        long originalThreadId = originalEventId.getThreadID();
        long newThreadId = originalThreadId;
        if (!ThreadIdentifier.isWanTypeThreadID(newThreadId)) {
            newThreadId = ThreadIdentifier.createFakeThreadIDForParallelGSPrimaryBucket(0, originalThreadId, this.getEventIdIndex());
        }
        EventID newEventId = new EventID(originalEventId.getMembershipID(), newThreadId, originalEventId.getSequenceID());
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Generated event id for event with key={}, original event id={}, originalThreadId={}, new event id={}, newThreadId={}", (Object)this, clonedEvent.getKey(), (Object)originalEventId, (Object)originalThreadId, (Object)newEventId, (Object)newThreadId);
        }
        clonedEvent.setEventId(newEventId);
    }
}

