/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.admin.AdminDistributedSystem;
import org.apache.geode.admin.CacheVm;
import org.apache.geode.admin.DistributedSystemHealthConfig;
import org.apache.geode.admin.DistributionLocator;
import org.apache.geode.admin.GemFireHealth;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.admin.StatisticResource;
import org.apache.geode.admin.SystemMember;
import org.apache.geode.admin.SystemMemberCache;
import org.apache.geode.admin.SystemMemberCacheServer;
import org.apache.geode.admin.SystemMemberRegion;
import org.apache.geode.admin.jmx.Agent;

public class ManagedResourceType
implements Serializable {
    private static final long serialVersionUID = 3752874768667480449L;
    public static final ManagedResourceType AGENT = new ManagedResourceType("Agent", Agent.class);
    public static final ManagedResourceType DISTRIBUTED_SYSTEM = new ManagedResourceType("AdminDistributedSystem", AdminDistributedSystem.class);
    public static final ManagedResourceType SYSTEM_MEMBER = new ManagedResourceType("SystemMember", SystemMember.class);
    public static final ManagedResourceType SYSTEM_MEMBER_CACHE = new ManagedResourceType("SystemMemberCache", SystemMemberCache.class);
    public static final ManagedResourceType SYSTEM_MEMBER_REGION = new ManagedResourceType("SystemMemberRegion", SystemMemberRegion.class);
    public static final ManagedResourceType SYSTEM_MEMBER_CACHE_SERVER = new ManagedResourceType("SystemMemberCacheServer", SystemMemberCacheServer.class);
    public static final ManagedResourceType CACHE_VM = new ManagedResourceType("CacheVm", CacheVm.class);
    public static final ManagedResourceType STATISTIC_RESOURCE = new ManagedResourceType("StatisticResource", StatisticResource.class);
    public static final ManagedResourceType GEMFIRE_HEALTH = new ManagedResourceType("GemFireHealth", GemFireHealth.class);
    public static final ManagedResourceType DISTRIBUTED_SYSTEM_HEALTH_CONFIG = new ManagedResourceType("DistributedSystemHealthConfig", DistributedSystemHealthConfig.class);
    public static final ManagedResourceType GEMFIRE_HEALTH_CONFIG = new ManagedResourceType("GemFireHealthConfig", GemFireHealthConfig.class);
    public static final ManagedResourceType DISTRIBUTION_LOCATOR = new ManagedResourceType("DistributionLocator", DistributionLocator.class);
    private final transient String name;
    private final transient Class clazz;
    public final int ordinal = nextOrdinal++;
    private static int nextOrdinal = 0;
    private static final ManagedResourceType[] VALUES = new ManagedResourceType[]{AGENT, DISTRIBUTED_SYSTEM, SYSTEM_MEMBER, SYSTEM_MEMBER_CACHE, SYSTEM_MEMBER_REGION, SYSTEM_MEMBER_CACHE_SERVER, CACHE_VM, STATISTIC_RESOURCE, GEMFIRE_HEALTH, DISTRIBUTED_SYSTEM_HEALTH_CONFIG, GEMFIRE_HEALTH_CONFIG, DISTRIBUTION_LOCATOR};

    private Object readResolve() throws ObjectStreamException {
        return VALUES[this.ordinal];
    }

    private ManagedResourceType(String name, Class clazz) {
        this.name = name;
        this.clazz = clazz;
    }

    public static ManagedResourceType fromOrdinal(int ordinal) {
        return VALUES[ordinal];
    }

    public String getName() {
        return this.name;
    }

    public Class getClassType() {
        return this.clazz;
    }

    public String getClassTypeName() {
        return this.clazz.getName();
    }

    public boolean isAgent() {
        return this.equals(AGENT);
    }

    public boolean isDistributedSystem() {
        return this.equals(DISTRIBUTED_SYSTEM);
    }

    public boolean isSystemMember() {
        return this.equals(SYSTEM_MEMBER);
    }

    public boolean isStatisticResource() {
        return this.equals(STATISTIC_RESOURCE);
    }

    public boolean isGemFireHealth() {
        return this.equals(GEMFIRE_HEALTH);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof ManagedResourceType)) {
            return false;
        }
        ManagedResourceType that = (ManagedResourceType)other;
        if (!StringUtils.equals((String)this.name, (String)that.name)) {
            return false;
        }
        return this.clazz == that.clazz || this.clazz != null && this.clazz.equals(that.clazz);
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        result = 37 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 37 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        return result;
    }
}

