/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.admin.internal.FinishBackupResponse;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.internal.admin.remote.AdminFailureResponse;
import org.apache.geode.internal.admin.remote.AdminMultipleReplyProcessor;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.CliLegacyMessage;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class FinishBackupRequest
extends CliLegacyMessage {
    private static final Logger logger = LogService.getLogger();
    private File targetDir;
    private File baselineDir;
    private boolean abort;

    public FinishBackupRequest() {
    }

    public FinishBackupRequest(File targetDir, File baselineDir, boolean abort) {
        this.targetDir = targetDir;
        this.baselineDir = baselineDir;
        this.abort = abort;
    }

    public static Map<DistributedMember, Set<PersistentID>> send(DM dm, Set recipients, File targetDir, File baselineDir, boolean abort) {
        FinishBackupRequest request = new FinishBackupRequest(targetDir, baselineDir, abort);
        request.setRecipients(recipients);
        FinishBackupReplyProcessor replyProcessor = new FinishBackupReplyProcessor(dm, (Collection)recipients);
        request.msgId = replyProcessor.getProcessorId();
        dm.putOutgoing(request);
        try {
            replyProcessor.waitForReplies();
        }
        catch (ReplyException e) {
            if (!(e.getCause() instanceof CancelException)) {
                throw e;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        AdminResponse response = request.createResponse((DistributionManager)dm);
        response.setSender(dm.getDistributionManagerId());
        replyProcessor.process(response);
        return replyProcessor.results;
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        HashSet<PersistentID> persistentIds;
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null || cache.getBackupManager() == null) {
            persistentIds = new HashSet<PersistentID>();
        } else {
            try {
                persistentIds = cache.getBackupManager().finishBackup(this.targetDir, this.baselineDir, this.abort);
            }
            catch (IOException e) {
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.CliLegacyMessage_ERROR, this.getClass()), (Throwable)e);
                return AdminFailureResponse.create(dm, this.getSender(), e);
            }
        }
        return new FinishBackupResponse(this.getSender(), persistentIds);
    }

    @Override
    public int getDSFID() {
        return 2114;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.targetDir = DataSerializer.readFile(in);
        this.baselineDir = DataSerializer.readFile(in);
        this.abort = DataSerializer.readBoolean(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeFile(this.targetDir, out);
        DataSerializer.writeFile(this.baselineDir, out);
        DataSerializer.writeBoolean(this.abort, out);
    }

    private static class FinishBackupReplyProcessor
    extends AdminMultipleReplyProcessor {
        Map<DistributedMember, Set<PersistentID>> results = Collections.synchronizedMap(new HashMap());

        public FinishBackupReplyProcessor(DM dm, Collection initMembers) {
            super(dm, initMembers);
        }

        @Override
        protected boolean stopBecauseOfExceptions() {
            return false;
        }

        @Override
        protected int getAckWaitThreshold() {
            return 0;
        }

        @Override
        public long getAckSevereAlertThresholdMS() {
            return Long.MAX_VALUE;
        }

        @Override
        protected void process(DistributionMessage msg, boolean warn) {
            HashSet<PersistentID> persistentIds;
            if (msg instanceof FinishBackupResponse && (persistentIds = ((FinishBackupResponse)msg).getPersistentIds()) != null && !persistentIds.isEmpty()) {
                this.results.put(msg.getSender(), persistentIds);
            }
            super.process(msg, warn);
        }
    }
}

