% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-funcs.R
\name{register_binding}
\alias{register_binding}
\title{Register compute bindings}
\usage{
register_binding(fun_name, fun, registry = nse_funcs)
}
\arguments{
\item{fun_name}{A string containing a function name in the form \code{"function"} or
\code{"package::function"}. The package name is currently not used but
may be used in the future to allow these types of function calls.}

\item{fun}{A function or \code{NULL} to un-register a previous function.
This function must accept \code{Expression} objects as arguments and return
\code{Expression} objects instead of regular R objects.}

\item{registry}{An environment in which the functions should be
assigned.}

\item{agg_fun}{An aggregate function or \code{NULL} to un-register a previous
aggregate function. This function must accept \code{Expression} objects as
arguments and return a \code{list()} with components:
\itemize{
\item \code{fun}: string function name
\item \code{data}: \code{Expression} (these are all currently a single field)
\item \code{options}: list of function options, as passed to call_function
}}
}
\value{
The previously registered binding or \code{NULL} if no previously
registered function existed.
}
\description{
The \code{register_binding()} and \code{register_binding_agg()} functions
are used to populate a list of functions that operate on (and return)
Expressions. These are the basis for the \code{.data} mask inside dplyr methods.
}
\section{Writing bindings}{

When to use \code{build_expr()} vs. \code{Expression$create()}?

Use \code{build_expr()} if you need to
\itemize{
\item map R function names to Arrow C++ functions
\item wrap R inputs (vectors) as Array/Scalar
}

\code{Expression$create()} is lower level. Most of the bindings use it
because they manage the preparation of the user-provided inputs
and don't need or don't want to the automatic conversion of R objects
to \link{Scalar}.
}

\keyword{internal}
