/**
 * \file list-mon-message.h
 * \brief List of monster message types
 *
 * id   - the message constant name
 * text - the message text
 */

/* id					text */
MON_MSG(NONE,				"[is|are] hurt.")
MON_MSG(DIE,				"die[s].")
MON_MSG(DESTROYED,			"[is|are] destroyed.")
MON_MSG(RESIST_A_LOT,		"resist[s] a lot.")
MON_MSG(HIT_HARD,			"[is|are] hit hard.")
MON_MSG(RESIST,				"resist[s].")
MON_MSG(IMMUNE,				"[is|are] immune.")
MON_MSG(RESIST_SOMEWHAT,	"resist[s] somewhat.")
MON_MSG(UNAFFECTED,			"[is|are] unaffected!")
MON_MSG(SPAWN,				"spawn[s]!")
MON_MSG(HEALTHIER,			"look[s] healthier.")
MON_MSG(FALL_ASLEEP,		"fall[s] asleep!")
MON_MSG(WAKES_UP,			"wake[s] up.")
MON_MSG(CRINGE_LIGHT,		"cringe[s] from the light!")
MON_MSG(SHRIVEL_LIGHT,		"shrivel[s] away in the light!")
MON_MSG(LOSE_SKIN,			"lose[s] some skin!")
MON_MSG(DISSOLVE,			"dissolve[s]!")
MON_MSG(CATCH_FIRE,			"catch[es] fire!")
MON_MSG(BADLY_FROZEN,		"[is|are] badly frozen.")
MON_MSG(SHUDDER,			"shudder[s].")
MON_MSG(CHANGE,				"change[s]!")
MON_MSG(DISAPPEAR,			"disappear[s]!")
MON_MSG(MORE_DAZED,			"[is|are] even more stunned.")
MON_MSG(DAZED,				"[is|are] stunned.")
MON_MSG(NOT_DAZED,			"[is|are] no longer stunned.")
MON_MSG(MORE_CONFUSED,		"look[s] more confused.")
MON_MSG(CONFUSED,			"look[s] confused.")
MON_MSG(NOT_CONFUSED,		"[is|are] no longer confused.")
MON_MSG(MORE_SLOWED,		"look[s] more slowed.")
MON_MSG(SLOWED,				"look[s] slowed.")
MON_MSG(NOT_SLOWED	,		"speed[s] up.")
MON_MSG(MORE_HASTED,		"look[s] even faster!")
MON_MSG(HASTED,				"start[s] moving faster.")
MON_MSG(NOT_HASTED,			"slow[s] down.")
MON_MSG(MORE_AFRAID,		"look[s] more terrified!")
MON_MSG(FLEE_IN_TERROR,		"flee[s] in terror!")
MON_MSG(NOT_AFRAID,			"[is|are] no longer afraid.")
MON_MSG(MORIA_DEATH,		"~You hear [a|several] scream[|s] of agony!")
MON_MSG(DISENTEGRATES,		"disintegrate[s]!")
MON_MSG(FREEZE_SHATTER,		"freeze[s] and shatter[s]!")
MON_MSG(MANA_DRAIN	,		"lose[s] some mana!")
MON_MSG(BRIEF_PUZZLE,		"look[s] briefly puzzled.")
MON_MSG(MAINTAIN_SHAPE,		"maintain[s] the same shape.")
MON_MSG(UNHARMED,			"[is|are] unharmed.")
/* Dummy messages for monster pain - we use edit file info instead. */
MON_MSG(95,					"")
MON_MSG(75,					"")
MON_MSG(50,					"")
MON_MSG(35,					"")
MON_MSG(20,					"")
MON_MSG(10,					"")
MON_MSG(0,					"")
MON_MSG(MAX,				"")
