/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.project;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.io.FolderWrapper;
import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.StreamException;
import com.android.sdklib.internal.project.IPropertySource;
import com.android.sdklib.internal.project.ProjectPropertiesWorkingCopy;
import com.android.utils.ILogger;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProjectProperties
implements IPropertySource {
    protected static final Pattern PATTERN_PROP = Pattern.compile("^([a-zA-Z0-9._-]+)\\s*=\\s*(.*)\\s*$");
    public static final String PROPERTY_TARGET = "target";
    public static final String PROPERTY_RS_TARGET = "renderscript.target";
    public static final String PROPERTY_RS_SUPPORT = "renderscript.support.mode";
    public static final String PROPERTY_BUILD_TOOLS = "sdk.buildtools";
    public static final String PROPERTY_LIBRARY = "android.library";
    public static final String PROPERTY_LIB_REF = "android.library.reference.";
    private static final String PROPERTY_LIB_REF_REGEX = "android.library.reference.\\d+";
    public static final String PROPERTY_PROGUARD_CONFIG = "proguard.config";
    public static final String PROPERTY_RULES_PATH = "layoutrules.jars";
    public static final String PROPERTY_SDK = "sdk.dir";
    public static final String PROPERTY_NDK = "ndk.dir";
    private static final String PROPERTY_SDK_LEGACY = "sdk-location";
    public static final String PROPERTY_SPLIT_BY_DENSITY = "split.density";
    public static final String PROPERTY_SPLIT_BY_ABI = "split.abi";
    public static final String PROPERTY_SPLIT_BY_LOCALE = "split.locale";
    public static final String PROPERTY_TESTED_PROJECT = "tested.project.dir";
    public static final String PROPERTY_BUILD_SOURCE_DIR = "source.dir";
    public static final String PROPERTY_BUILD_OUT_DIR = "out.dir";
    public static final String PROPERTY_PACKAGE = "package";
    public static final String PROPERTY_VERSIONCODE = "versionCode";
    public static final String PROPERTY_PROJECTS = "projects";
    public static final String PROPERTY_KEY_STORE = "key.store";
    public static final String PROPERTY_KEY_ALIAS = "key.alias";
    private static final String LOCAL_HEADER = "# This file is automatically generated by Android Tools.\n# Do not modify this file -- YOUR CHANGES WILL BE ERASED!\n#\n# This file must *NOT* be checked into Version Control Systems,\n# as it contains information specific to your local configuration.\n\n";
    private static final String DEFAULT_HEADER = "# This file is automatically generated by Android Tools.\n# Do not modify this file -- YOUR CHANGES WILL BE ERASED!\n#\n# This file must be checked in Version Control Systems.\n#\n# To customize properties used by the Ant build system edit\n# \"ant.properties\", and override values to adapt the script to your\n# project structure.\n#\n# To enable ProGuard to shrink and obfuscate your code, uncomment this (available properties: sdk.dir, user.home):\n#proguard.config=${sdk.dir}/tools/proguard/proguard-android.txt:proguard-project.txt\n\n";
    private static final String BUILD_HEADER = "# This file is used to override default values used by the Ant build system.\n#\n# This file must be checked into Version Control Systems, as it is\n# integral to the build system of your project.\n\n# This file is only used by the Ant script.\n\n# You can use this to override default values such as\n#  'source.dir' for the location of your java source folder and\n#  'out.dir' for the location of your output folder.\n\n# You can also use it define how the release builds are signed by declaring\n# the following properties:\n#  'key.store' for the location of your keystore and\n#  'key.alias' for the name of the key to use.\n# The password will be asked during the build when you use the 'release' target.\n\n";
    protected final IAbstractFolder mProjectFolder;
    protected final Map<String, String> mProperties;
    protected final PropertyType mType;

    public static ProjectProperties load(String projectFolderOsPath, PropertyType type) {
        FolderWrapper wrapper = new FolderWrapper(projectFolderOsPath);
        return ProjectProperties.load((IAbstractFolder)wrapper, type);
    }

    public static ProjectProperties load(IAbstractFolder projectFolder, PropertyType type) {
        Map<String, String> map;
        IAbstractFile propFile;
        if (projectFolder.exists() && (propFile = projectFolder.getFile(type.mFilename)).exists() && (map = ProjectProperties.parsePropertyFile(propFile, null)) != null) {
            return new ProjectProperties(projectFolder, map, type);
        }
        return null;
    }

    public static boolean delete(IAbstractFolder projectFolder, PropertyType type) {
        IAbstractFile propFile;
        if (projectFolder.exists() && (propFile = projectFolder.getFile(type.mFilename)).exists()) {
            return propFile.delete();
        }
        return false;
    }

    public static boolean delete(String projectFolderOsPath, PropertyType type) {
        FolderWrapper wrapper = new FolderWrapper(projectFolderOsPath);
        return ProjectProperties.delete((IAbstractFolder)wrapper, type);
    }

    public static ProjectPropertiesWorkingCopy create(@NonNull String projectFolderOsPath, @NonNull PropertyType type) {
        FolderWrapper folder = new FolderWrapper(projectFolderOsPath);
        return ProjectProperties.create((IAbstractFolder)folder, type);
    }

    public static ProjectPropertiesWorkingCopy create(@NonNull IAbstractFolder projectFolder, @NonNull PropertyType type) {
        return new ProjectPropertiesWorkingCopy(projectFolder, new HashMap<String, String>(), type);
    }

    public static ProjectProperties createEmpty(@NonNull String projectFolderOsPath, @NonNull PropertyType type) {
        FolderWrapper folder = new FolderWrapper(projectFolderOsPath);
        return ProjectProperties.createEmpty((IAbstractFolder)folder, type);
    }

    public static ProjectProperties createEmpty(@NonNull IAbstractFolder projectFolder, @NonNull PropertyType type) {
        return new ProjectProperties(projectFolder, new HashMap<String, String>(), type);
    }

    public IAbstractFile getFile() {
        return this.mProjectFolder.getFile(this.mType.mFilename);
    }

    public ProjectPropertiesWorkingCopy makeWorkingCopy() {
        return this.makeWorkingCopy(this.mType);
    }

    public ProjectPropertiesWorkingCopy makeWorkingCopy(PropertyType type) {
        HashMap<String, String> propList = new HashMap<String, String>(this.mProperties);
        return new ProjectPropertiesWorkingCopy(this.mProjectFolder, propList, type);
    }

    public PropertyType getType() {
        return this.mType;
    }

    @Override
    public synchronized String getProperty(String name) {
        return this.mProperties.get(name);
    }

    public synchronized Set<String> keySet() {
        return new HashSet<String>(this.mProperties.keySet());
    }

    public synchronized void reload() {
        Map<String, String> map;
        IAbstractFile propFile;
        if (this.mProjectFolder.exists() && (propFile = this.mProjectFolder.getFile(this.mType.mFilename)).exists() && (map = ProjectProperties.parsePropertyFile(propFile, null)) != null) {
            this.mProperties.clear();
            this.mProperties.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> parsePropertyFile(@NonNull IAbstractFile propFile, @Nullable ILogger log) {
        InputStream is = null;
        try {
            is = propFile.getContents();
            Map<String, String> map = ProjectProperties.parsePropertyStream(is, propFile.getOsLocation(), log);
            return map;
        }
        catch (StreamException e) {
            if (log != null) {
                log.warning("Error parsing '%1$s': %2$s.", new Object[]{propFile.getOsLocation(), e.getMessage()});
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)is);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> parsePropertyStream(@NonNull InputStream propStream, @NonNull String propPath, @Nullable ILogger log) {
        HashMap<String, String> hashMap;
        BufferedReader reader;
        block12: {
            Map<String, String> map;
            block11: {
                reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(propStream, "UTF-8"));
                    String line = null;
                    HashMap<String, String> map2 = new HashMap<String, String>();
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                        Matcher m = PATTERN_PROP.matcher(line);
                        if (m.matches()) {
                            map2.put(m.group(1), ProjectProperties.unescape(m.group(2)));
                            continue;
                        }
                        if (log != null) {
                            log.warning("Error parsing '%1$s': \"%2$s\" is not a valid syntax", new Object[]{propPath, line});
                        }
                        map = null;
                        Closeables.closeQuietly((Closeable)reader);
                        break block11;
                    }
                    hashMap = map2;
                    Closeables.closeQuietly((Closeable)reader);
                    break block12;
                }
                catch (FileNotFoundException e) {
                    Closeables.closeQuietly(reader);
                    Closeables.closeQuietly((Closeable)propStream);
                    return null;
                }
                catch (IOException e) {
                    if (log == null) return null;
                    log.warning("Error parsing '%1$s': %2$s.", new Object[]{propPath, e.getMessage()});
                    return null;
                }
            }
            Closeables.closeQuietly((Closeable)propStream);
            return map;
        }
        Closeables.closeQuietly((Closeable)propStream);
        return hashMap;
        finally {
            Closeables.closeQuietly(reader);
            Closeables.closeQuietly((Closeable)propStream);
        }
    }

    protected ProjectProperties(@NonNull IAbstractFolder projectFolder, @NonNull Map<String, String> map, @NonNull PropertyType type) {
        this.mProjectFolder = projectFolder;
        this.mProperties = map;
        this.mType = type;
    }

    private static String unescape(String value) {
        return value.replaceAll("\\\\\\\\", "\\\\");
    }

    protected static String escape(String value) {
        return value.replaceAll("\\\\", "\\\\\\\\");
    }

    @Override
    public void debugPrint() {
        System.out.println("DEBUG PROJECTPROPERTIES: " + this.mProjectFolder);
        System.out.println("type: " + (Object)((Object)this.mType));
        for (Map.Entry<String, String> entry : this.mProperties.entrySet()) {
            System.out.println(entry.getKey() + " -> " + entry.getValue());
        }
        System.out.println("<<< DEBUG PROJECTPROPERTIES");
    }

    public static enum PropertyType {
        ANT("ant.properties", "# This file is used to override default values used by the Ant build system.\n#\n# This file must be checked into Version Control Systems, as it is\n# integral to the build system of your project.\n\n# This file is only used by the Ant script.\n\n# You can use this to override default values such as\n#  'source.dir' for the location of your java source folder and\n#  'out.dir' for the location of your output folder.\n\n# You can also use it define how the release builds are signed by declaring\n# the following properties:\n#  'key.store' for the location of your keystore and\n#  'key.alias' for the name of the key to use.\n# The password will be asked during the build when you use the 'release' target.\n\n", new String[]{"source.dir", "out.dir"}, null),
        PROJECT("project.properties", "# This file is automatically generated by Android Tools.\n# Do not modify this file -- YOUR CHANGES WILL BE ERASED!\n#\n# This file must be checked in Version Control Systems.\n#\n# To customize properties used by the Ant build system edit\n# \"ant.properties\", and override values to adapt the script to your\n# project structure.\n#\n# To enable ProGuard to shrink and obfuscate your code, uncomment this (available properties: sdk.dir, user.home):\n#proguard.config=${sdk.dir}/tools/proguard/proguard-android.txt:proguard-project.txt\n\n", new String[]{"target", "android.library", "android.library.reference.\\d+", "key.store", "key.alias", "proguard.config", "layoutrules.jars"}, null),
        LOCAL("local.properties", "# This file is automatically generated by Android Tools.\n# Do not modify this file -- YOUR CHANGES WILL BE ERASED!\n#\n# This file must *NOT* be checked into Version Control Systems,\n# as it contains information specific to your local configuration.\n\n", new String[]{"sdk.dir"}, new String[]{"sdk-location"}),
        LEGACY_DEFAULT("default.properties", null, null, null),
        LEGACY_BUILD("build.properties", null, null, null);

        private final String mFilename;
        private final String mHeader;
        private final Set<String> mKnownProps;
        private final Set<String> mRemovedProps;

        public static PropertyType[] getOrderedTypes() {
            return new PropertyType[]{LOCAL, ANT, PROJECT};
        }

        private PropertyType(String filename, String header, String[] validProps, String[] removedProps) {
            this.mFilename = filename;
            this.mHeader = header;
            HashSet<String> s = new HashSet<String>();
            if (validProps != null) {
                s.addAll(Arrays.asList(validProps));
            }
            this.mKnownProps = Collections.unmodifiableSet(s);
            s = new HashSet();
            if (removedProps != null) {
                s.addAll(Arrays.asList(removedProps));
            }
            this.mRemovedProps = Collections.unmodifiableSet(s);
        }

        public String getFilename() {
            return this.mFilename;
        }

        public String getHeader() {
            return this.mHeader;
        }

        public boolean isKnownProperty(String name) {
            for (String propRegex : this.mKnownProps) {
                if (!propRegex.equals(name) && !Pattern.matches(propRegex, name)) continue;
                return true;
            }
            return false;
        }

        public boolean isRemovedProperty(String name) {
            for (String propRegex : this.mRemovedProps) {
                if (!propRegex.equals(name) && !Pattern.matches(propRegex, name)) continue;
                return true;
            }
            return false;
        }
    }
}

