/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HIThemeButtonDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ExpanderDrawData
extends DrawData {
    public ExpanderDrawData() {
        this.state = new int[1];
    }

    HIThemeButtonDrawInfo getInfo() {
        int n = this.state[0];
        HIThemeButtonDrawInfo hIThemeButtonDrawInfo = new HIThemeButtonDrawInfo();
        hIThemeButtonDrawInfo.version = 0;
        hIThemeButtonDrawInfo.kind = 6;
        hIThemeButtonDrawInfo.value = (this.style & 0x400) != 0 ? 1 : 0;
        hIThemeButtonDrawInfo.state = (n & 8) != 0 ? 2 : ((n & 0x10) != 0 ? ((n & 0x20) == 0 ? 1 : 7) : ((n & 0x20) == 0 ? 0 : 8));
        return hIThemeButtonDrawInfo;
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        HIThemeButtonDrawInfo hIThemeButtonDrawInfo = this.getInfo();
        CGRect cGRect = new CGRect();
        cGRect.x = rectangle.x;
        cGRect.y = rectangle.y;
        cGRect.width = rectangle.width;
        cGRect.height = rectangle.height;
        CGRect cGRect2 = new CGRect();
        OS.HIThemeGetButtonBackgroundBounds(cGRect, hIThemeButtonDrawInfo, cGRect2);
        cGRect.x += cGRect.x - cGRect2.x;
        cGRect.y += cGRect.y - cGRect2.y;
        int[] nArray = new int[1];
        OS.GetThemeMetric(26, nArray);
        cGRect.width = nArray[0];
        OS.GetThemeMetric(25, nArray);
        cGRect.height = nArray[0];
        OS.HIThemeDrawButton(cGRect, hIThemeButtonDrawInfo, gC.handle, 0, null);
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (!rectangle.contains(point)) {
            return -1;
        }
        int[] nArray = new int[1];
        OS.GetThemeMetric(26, nArray);
        int n = nArray[0];
        OS.GetThemeMetric(25, nArray);
        int n2 = nArray[0];
        if (new Rectangle(rectangle.x, rectangle.y, n, n2).contains(point)) {
            return 0;
        }
        return -1;
    }
}

