/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

import com.android.traceview.Call;
import com.android.traceview.MethodData;
import com.android.traceview.TimeLineView;
import com.android.traceview.TraceAction;
import java.util.ArrayList;
import java.util.HashMap;

class ThreadData
implements TimeLineView.Row {
    private int mId;
    private String mName;
    private boolean mIsEmpty;
    private Call mRootCall;
    private ArrayList<Call> mStack = new ArrayList();
    private HashMap<MethodData, Integer> mStackMethods = new HashMap();
    boolean mHaveGlobalTime;
    long mGlobalStartTime;
    long mGlobalEndTime;
    boolean mHaveThreadTime;
    long mThreadStartTime;
    long mThreadEndTime;
    long mThreadCurrentTime;

    ThreadData(int id, String name, MethodData topLevel) {
        this.mId = id;
        this.mName = String.format("[%d] %s", id, name);
        this.mIsEmpty = true;
        this.mRootCall = new Call(this, topLevel, null);
        this.mRootCall.setName(this.mName);
        this.mStack.add(this.mRootCall);
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public Call getRootCall() {
        return this.mRootCall;
    }

    public boolean isEmpty() {
        return this.mIsEmpty;
    }

    Call enter(MethodData method, ArrayList<TraceAction> trace) {
        Integer num;
        if (this.mIsEmpty) {
            this.mIsEmpty = false;
            if (trace != null) {
                trace.add(new TraceAction(0, this.mRootCall));
            }
        }
        Call caller = this.top();
        Call call = new Call(this, method, caller);
        this.mStack.add(call);
        if (trace != null) {
            trace.add(new TraceAction(0, call));
        }
        if ((num = this.mStackMethods.get(method)) == null) {
            num = 0;
        } else if (num > 0) {
            call.setRecursive(true);
        }
        this.mStackMethods.put(method, num + 1);
        return call;
    }

    Call exit(MethodData method, ArrayList<TraceAction> trace) {
        Integer num;
        Call call = this.top();
        if (call.mCaller == null) {
            return null;
        }
        if (call.getMethodData() != method) {
            String error = "Method exit (" + method.getName() + ") does not match current method (" + call.getMethodData().getName() + ")";
            throw new RuntimeException(error);
        }
        this.mStack.remove(this.mStack.size() - 1);
        if (trace != null) {
            trace.add(new TraceAction(1, call));
        }
        if ((num = this.mStackMethods.get(method)) != null) {
            if (num == 1) {
                this.mStackMethods.remove(method);
            } else {
                this.mStackMethods.put(method, num - 1);
            }
        }
        return call;
    }

    Call top() {
        return this.mStack.get(this.mStack.size() - 1);
    }

    void endTrace(ArrayList<TraceAction> trace) {
        for (int i = this.mStack.size() - 1; i >= 1; --i) {
            Call call = this.mStack.get(i);
            call.mGlobalEndTime = this.mGlobalEndTime;
            call.mThreadEndTime = this.mThreadEndTime;
            if (trace == null) continue;
            trace.add(new TraceAction(2, call));
        }
        this.mStack.clear();
        this.mStackMethods.clear();
    }

    void updateRootCallTimeBounds() {
        if (!this.mIsEmpty) {
            this.mRootCall.mGlobalStartTime = this.mGlobalStartTime;
            this.mRootCall.mGlobalEndTime = this.mGlobalEndTime;
            this.mRootCall.mThreadStartTime = this.mThreadStartTime;
            this.mRootCall.mThreadEndTime = this.mThreadEndTime;
        }
    }

    public String toString() {
        return this.mName;
    }

    @Override
    public int getId() {
        return this.mId;
    }

    public long getCpuTime() {
        return this.mRootCall.mInclusiveCpuTime;
    }

    public long getRealTime() {
        return this.mRootCall.mInclusiveRealTime;
    }
}

