/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.xml.AndroidXPathFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.xml.sax.InputSource;

public class GetTypeTask
extends Task {
    private String mProjectTypeOut;

    public void setProjectTypeOut(String projectTypeOut) {
        this.mProjectTypeOut = projectTypeOut;
    }

    public void execute() throws BuildException {
        if (this.mProjectTypeOut == null) {
            throw new BuildException("Missing attribute projectTypeOut");
        }
        Project antProject = this.getProject();
        String libraryProp = antProject.getProperty("android.library");
        if (libraryProp != null && Boolean.valueOf(libraryProp).booleanValue()) {
            System.out.println("Project Type: Android Library");
            antProject.setProperty(this.mProjectTypeOut, "library");
            return;
        }
        if (antProject.getProperty("tested.project.dir") != null) {
            System.out.println("Project Type: Test Application");
            antProject.setProperty(this.mProjectTypeOut, "test");
            return;
        }
        try {
            File manifest = new File(antProject.getBaseDir(), "AndroidManifest.xml");
            XPath xPath = AndroidXPathFactory.newXPath();
            String value = xPath.evaluate("/manifest/instrumentation/@android:targetPackage", new InputSource(new FileInputStream(manifest)));
            if (value != null && value.length() > 0) {
                System.out.println("Project Type: Self-Tested Application");
                antProject.setProperty(this.mProjectTypeOut, "test-app");
                return;
            }
        }
        catch (XPathExpressionException e) {
            throw new BuildException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        System.out.println("Project Type: Application");
        antProject.setProperty(this.mProjectTypeOut, "app");
    }
}

