/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.traceview.editors;

import com.android.ide.eclipse.ddms.JavaSourceRevealer;
import com.android.ide.eclipse.traceview.TraceviewPlugin;
import com.android.traceview.ColorController;
import com.android.traceview.DmTraceReader;
import com.android.traceview.MethodData;
import com.android.traceview.ProfileView;
import com.android.traceview.SelectionController;
import com.android.traceview.TimeLineView;
import com.android.traceview.TraceReader;
import com.android.traceview.TraceUnits;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class TraceviewEditor
extends EditorPart
implements ProfileView.MethodHandler {
    private Composite mParent;
    private String mFilename;
    private Composite mContents;

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    private IFile getWorkspaceFile(IFileStore iFileStore) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] iFileArray = iWorkspaceRoot.findFilesForLocationURI(iFileStore.toURI());
        if (iFileArray != null && iFileArray.length == 1) {
            return iFileArray[0];
        }
        return null;
    }

    public void doSaveAs() {
        Shell shell = this.getSite().getShell();
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof FileEditorInput) {
            Object object;
            FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
            SaveAsDialog saveAsDialog = new SaveAsDialog(shell);
            IFile iFile = fileEditorInput.getFile();
            if (iFile != null) {
                saveAsDialog.setOriginalFile(iFile);
            }
            saveAsDialog.create();
            if (iFile != null && !iFile.isAccessible()) {
                object = String.format("The original file ''%s'' has been deleted or is not accessible.", iFile.getName());
                saveAsDialog.setErrorMessage(null);
                saveAsDialog.setMessage((String)object, 2);
            }
            if (saveAsDialog.open() == 1) {
                return;
            }
            object = saveAsDialog.getResult();
            if (object == null) {
                return;
            }
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IFile iFile2 = iWorkspace.getRoot().getFile(object);
            if (this.copy(shell, fileEditorInput.getURI(), iFile2.getLocationURI()) == null) {
                return;
            }
            try {
                iFile2.refreshLocal(0, null);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            FileEditorInput fileEditorInput2 = new FileEditorInput(iFile2);
            this.setInput((IEditorInput)fileEditorInput2);
            this.setPartName(fileEditorInput2.getName());
        } else if (iEditorInput instanceof FileStoreEditorInput) {
            IFileStore iFileStore;
            String string;
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)iEditorInput;
            FileDialog fileDialog = new FileDialog(shell, 8192);
            IPath iPath = URIUtil.toPath((URI)fileStoreEditorInput.getURI());
            if (iPath != null) {
                fileDialog.setFileName(iPath.lastSegment());
                fileDialog.setFilterPath(iPath.toOSString());
            }
            if ((string = fileDialog.open()) == null) {
                return;
            }
            File file = new File(string);
            if (file.exists() && (iFileStore = new MessageDialog(shell, "Save As", null, String.format("%s already exists.\nDo you want to replace it?", string), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() != 0) {
                return;
            }
            iFileStore = this.copy(shell, fileStoreEditorInput.getURI(), file.toURI());
            if (iFileStore != null) {
                IFile iFile = this.getWorkspaceFile(iFileStore);
                Object object = iFile != null ? new FileEditorInput(iFile) : new FileStoreEditorInput(iFileStore);
                this.setInput((IEditorInput)object);
                this.setPartName(object.getName());
            }
        }
    }

    private IFileStore copy(Shell shell, URI uRI, URI uRI2) {
        IFileStore iFileStore = null;
        IFileStore iFileStore2 = null;
        try {
            iFileStore = EFS.getStore((URI)uRI2);
            iFileStore2 = EFS.getStore((URI)uRI);
            iFileStore2.copy(iFileStore, 2, null);
        }
        catch (CoreException coreException) {
            String string = "Problems During Save As...";
            String string2 = String.format("Save could not be completed. %s", coreException.getMessage());
            MessageDialog.openError((Shell)shell, (String)string, (String)string2);
            return null;
        }
        return iFileStore;
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (iEditorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
            this.mFilename = fileEditorInput.getPath().toOSString();
            this.setSite((IWorkbenchPartSite)iEditorSite);
            this.setInput(iEditorInput);
            this.setPartName(iEditorInput.getName());
        } else if (iEditorInput instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)iEditorInput;
            this.mFilename = fileStoreEditorInput.getURI().getPath();
            this.setSite((IWorkbenchPartSite)iEditorSite);
            this.setInput(iEditorInput);
            this.setPartName(iEditorInput.getName());
        } else {
            throw new PartInitException("Input is not of type FileEditorInput nor FileStoreEditorInput: " + iEditorInput == null ? "null" : iEditorInput.toString());
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void createPartControl(Composite composite) {
        this.mParent = composite;
        try {
            DmTraceReader dmTraceReader = new DmTraceReader(this.mFilename, false);
            dmTraceReader.getTraceUnits().setTimeScale(TraceUnits.TimeScale.MilliSeconds);
            this.mContents = new Composite(this.mParent, 0);
            Display display = this.mContents.getDisplay();
            ColorController.assignMethodColors((Display)display, (MethodData[])dmTraceReader.getMethods());
            SelectionController selectionController = new SelectionController();
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            this.mContents.setLayout((Layout)gridLayout);
            Color color = display.getSystemColor(16);
            SashForm sashForm = new SashForm(this.mContents, 512);
            sashForm.setBackground(color);
            sashForm.SASH_WIDTH = 3;
            GridData gridData = new GridData(1808);
            sashForm.setLayoutData((Object)gridData);
            new TimeLineView((Composite)sashForm, (TraceReader)dmTraceReader, selectionController);
            new ProfileView((Composite)sashForm, (TraceReader)dmTraceReader, selectionController).setMethodHandler((ProfileView.MethodHandler)this);
        }
        catch (IOException iOException) {
            Label label = new Label(composite, 0);
            label.setText("Failed to read the stack trace.");
            Status status = new Status(4, "com.android.ide.eclipse.traceview", "Failed to read the stack trace.", (Throwable)iOException);
            TraceviewPlugin.getDefault().getLog().log((IStatus)status);
        }
        this.mParent.layout();
    }

    public void setFocus() {
        this.mParent.setFocus();
    }

    public void handleMethod(MethodData methodData) {
        String string = methodData.getMethodName();
        String string2 = methodData.getClassName().replaceAll("/", ".");
        String string3 = String.valueOf(string2) + "." + string;
        JavaSourceRevealer.revealMethod((String)string3, null, (int)-1, null);
    }
}

